/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net.ftp;

import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.ftp.DataTrans;
import COM.ibm.netdiver.net.ftp.FtpConstants;
import COM.ibm.netdiver.net.ftp.FtpDocGenerator;
import COM.ibm.netdiver.net.ftp.FtpReply;
import COM.ibm.netdiver.net.ftp.FtpTransaction;
import COM.ibm.netdiver.util.ASCIIInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public final class FtpCommand
implements FtpConstants {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    InputStream in;
    ASCIIInputStream dataIn;
    DataOutputStream dataOut;
    Socket sockFtp;
    FtpTransaction owner;
    DataTrans dtran;
    FtpReply ftpReply;
    InputStream cmdIn;
    String host;
    int port;
    String filename;
    String dirpath;
    String currentPath;
    String lastLine;
    Vector vWelcome;

    public FtpCommand(FtpTransaction ftpTransaction) {
        this.owner = ftpTransaction;
    }

    public int connection(String string, URI uRI) {
        try {
            this.host = string;
            this.sockFtp = new Socket(string, 21);
            this.dataOut = new DataOutputStream(new BufferedOutputStream(this.sockFtp.getOutputStream()));
            this.in = this.sockFtp.getInputStream();
            this.dataIn = new ASCIIInputStream(this.in);
            this.ftpReply = new FtpReply(this.dataIn);
            if (this.getReply() == 220) {
                return 1;
            }
        }
        catch (UnknownHostException unknownHostException) {
            return 0;
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
            return -1;
        }
        return 0;
    }

    public int isActiveConnection() {
        try {
            this.sendCommand(10, "I");
            int n = this.getReply();
            if (n == 200 || n == 220) {
                return 1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return 0;
    }

    public int login() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        try {
            this.sendCommand(n, this.owner.getAuth(n, bl));
            while (bl2) {
                int n2 = this.getReply();
                bl = false;
                switch (n2) {
                    case 230: {
                        this.sendCommand(10, "I");
                        n2 = this.getReply();
                        return 1;
                    }
                    case 331: {
                        n = 1;
                        break;
                    }
                    case 530: {
                        bl = true;
                        n = 0;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                String string = this.owner.getAuth(n, bl);
                if (string != null) {
                    this.sendCommand(n, string);
                    continue;
                }
                return 0;
            }
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public int logout() {
        try {
            this.sendCommand(7, " ");
            this.ftpReply.stopReply();
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getFtpContents(URI uRI) {
        String string = uRI.getNetLoc();
        try {
            int n;
            int n2 = this.setupDataConnection(string);
            if (n2 != 1) {
                return n2;
            }
            if (this.filename == "DIRECTORY.html") {
                this.sendCommand(27, " ");
                n = this.getReply();
            } else {
                String string2 = this.getDirFileName();
                this.sendCommand(13, string2);
                n = this.getReply();
                if (n == 550) {
                    if (!this.confirmDir(string2)) return 0;
                    this.dirpath = string2;
                    this.filename = "DIRECTORY.html";
                    this.sendCommand(27, this.dirpath);
                    n = this.getReply();
                } else {
                    this.dirpath = null;
                }
            }
            if (n != 150 && n != 125) return 0;
            if (this.filename == "DIRECTORY.html") {
                FtpDocGenerator ftpDocGenerator = new FtpDocGenerator(new ASCIIInputStream(this.dtran.startDataIn()));
                this.in = ftpDocGenerator.generateDirDoc(this.dirpath);
                return 1;
            } else {
                this.in = this.dtran.startDataIn();
            }
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public boolean confirmDir(String string) {
        try {
            this.sendCommand(25, " ");
            if (this.getReply() == 257) {
                this.sendCommand(3, string);
                if (this.getReply() == 250) {
                    this.sendCommand(3, this.currentPath);
                    this.getReply();
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void sendCommand(int n, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FtpConstants.cmdList[n]);
        if (string != " ") {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        stringBuffer.append("\r\n");
        this.dataOut.writeBytes(stringBuffer.toString());
        this.dataOut.flush();
    }

    public int getReplyCode() throws IOException {
        int n;
        String string;
        while ((string = this.ftpReply.getLastReply(true)) != null) {
            if (string.length() > 0) break;
        }
        if (string != null) {
            this.lastLine = string;
        }
        if ((n = this.getCodeFromLine(string)) != 0 && n != -1 && string.indexOf(" ") != 3) {
            n += 1000;
        }
        return n;
    }

    public int getReply() throws IOException {
        int n = 0;
        int n2 = 1000;
        while (n2 != 0) {
            n = this.getReplyCode();
            this.retrieveInfo(n);
            if (n >= 1000) {
                n2 = n - 1000;
                continue;
            }
            if (n2 != 1000 && n2 != n) continue;
            n2 = 0;
        }
        return n;
    }

    public int getCodeFromLine(String string) {
        if (string == null || string.length() < 3) {
            return 0;
        }
        String string2 = string.substring(0, 3);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public int setupDataConnection(String string) {
        try {
            this.dtran = new DataTrans();
            if (this.dtran == null) {
                return 0;
            }
            int n = this.dtran.queryLocalPort();
            this.sendCommand(8, this.createStrAddress(InetAddress.getLocalHost(), n));
            if (this.getReply() != 200) {
                return 0;
            }
            return 1;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private void retrieveInfo(int n) throws IOException {
        if (n == 1230 || n == 230) {
            if (this.vWelcome == null) {
                this.vWelcome = new Vector();
            }
            if (this.lastLine.length() > 4) {
                String string = new String(this.lastLine.substring(4));
                this.vWelcome.addElement(string);
            }
        }
        if (n == 257) {
            this.currentPath = this.lastLine.substring(this.lastLine.indexOf(" ") + 2);
            this.currentPath = this.currentPath.substring(0, this.currentPath.indexOf(" ") - 1);
        }
    }

    private String createStrAddress(InetAddress inetAddress, int n) {
        String string = inetAddress.toString();
        string = string.substring(string.indexOf("/") + 1);
        string = string.replace('.', ',');
        string = string.concat("," + Integer.toString(n / 256) + "," + Integer.toString(n % 256));
        return string;
    }

    public void setFileName(URI uRI, String string) {
        String string2 = uRI.getAbsPath();
        if (string2 != null) {
            this.dirpath = null;
            int n = string2.indexOf(string);
            if (n >= 0) {
                string2 = string2.substring(n + string.length());
            }
        } else {
            string2 = uRI.getPath();
        }
        if (string2.compareTo("/") == 0) {
            this.dirpath = null;
            this.filename = "DIRECTORY.html";
            return;
        }
        if (string2.startsWith("/")) {
            this.filename = string2.substring(1);
            return;
        }
        this.filename = string2;
    }

    public String getDirFileName() {
        if (this.dirpath == null) {
            return this.filename;
        }
        if (this.filename.startsWith("/")) {
            return this.filename;
        }
        if (this.filename.startsWith(this.dirpath)) {
            return this.filename;
        }
        return String.valueOf(this.dirpath) + "/" + this.filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.owner.getInputStream();
        }
        return this.in;
    }

    public long getContentLength() throws IOException {
        return -1L;
    }
}

