/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net.http;

import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.http.Header;
import COM.ibm.netdiver.net.http.Transaction;
import COM.ibm.netdiver.net.http.Version;
import COM.ibm.netdiver.util.ASCIIInputStream;
import COM.ibm.netdiver.util.Constant;
import COM.ibm.netdiver.util.FileSource;
import COM.ibm.netdiver.util.Source;
import COM.ibm.netdiver.util.StreamSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class Message
implements Constant {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    Header header;
    Source entity;
    Version version;
    Transaction owner;
    URI uri;
    int status;
    public static final byte S_Initial = 0;
    public static final byte S_Open = 1;
    public static final byte S_Connect = 2;
    public static final byte S_Header = 3;
    public static final byte S_Body = 4;

    protected Message(InputStream inputStream) throws IOException {
        String string;
        ASCIIInputStream aSCIIInputStream;
        ASCIIInputStream aSCIIInputStream2 = aSCIIInputStream = inputStream instanceof ASCIIInputStream ? (ASCIIInputStream)inputStream : new ASCIIInputStream(inputStream);
        if (this.owner != null) {
            this.owner.setStatus(3);
        }
        while ((string = aSCIIInputStream.readLine()) != null) {
            if (string.length() <= 0) continue;
        }
        if (string == null) {
            throw new IOException();
        }
        this.loadFirstLine(string);
        this.header = new Header(aSCIIInputStream);
        if (this.owner != null) {
            this.owner.setStatus(4);
        }
        this.entity = new StreamSource(inputStream);
    }

    protected abstract void loadFirstLine(String var1) throws IOException;

    protected Message(Transaction transaction, URI uRI, Header header) {
        this.owner = transaction;
        this.uri = uRI;
        this.header = header;
        this.version = transaction.getVersion();
    }

    protected Message() {
    }

    public void setEntity(Source source) {
        this.entity = source;
        if (source instanceof FileSource) {
            File file = ((FileSource)source).getFile();
            this.setField((byte)38, Long.toString(file.length()));
            this.setField((byte)42, this.owner.getContentTypeString(file.getName()));
        }
    }

    public Source getEntity() {
        return this.entity;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setField(byte by, Object object) {
        this.header.set(by, object);
    }

    public Object getField(byte by) {
        return this.header.get(by);
    }

    public String getFieldString(byte by) {
        return this.header.getString(by);
    }

    public boolean isSimple() {
        return this.version == null || this.version.getValue() == 9;
    }

    public URI getURI() {
        return this.uri;
    }

    public Version getVersion() {
        return this.version;
    }
}

