/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net.http;

import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.http.Header;
import COM.ibm.netdiver.net.http.Message;
import COM.ibm.netdiver.net.http.Response;
import COM.ibm.netdiver.net.http.Transaction;
import COM.ibm.netdiver.util.StreamSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Request
extends Message {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    int method;
    static final int UNKNOWN = 0;
    static final int GET = 1;
    static final int HEAD = 2;
    static final int POST = 3;
    static final int PUT = 4;
    static final int DELETE = 5;
    static final int TRACE = 6;
    static final int OPTIONS = 7;
    static final int EXTENSION = 8;
    static final String[] methodSymbol = new String[]{"UNKNOWN", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "OPTIONS", "EXTENSION"};
    Socket sock;

    public Request(Transaction transaction, int n, URI uRI, Header header) {
        super(transaction, uRI, header);
        this.method = n;
    }

    public Request(Transaction transaction, URI uRI, Header header) {
        this(transaction, 1, uRI, header);
    }

    public Request(Transaction transaction, int n, URI uRI) {
        this(transaction, n, uRI, new Header());
    }

    public Request(Transaction transaction, URI uRI) {
        this(transaction, 1, uRI, new Header());
    }

    public Response getResponse() throws IOException {
        URI uRI = this.owner.getProxy();
        this.sock = uRI != null ? new Socket(uRI.getHost(), uRI.getPort()) : new Socket(this.uri.getHost(), this.uri.getPort());
        this.owner.setStatus(1);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.sock.getInputStream());
        this.owner.setStatus(2);
        dataOutputStream.writeBytes(this.getRequestLine(uRI != null));
        dataOutputStream.flush();
        if (this.isSimple()) {
            return new Response(new StreamSource(bufferedInputStream));
        }
        this.header.writeTo(dataOutputStream, 13);
        dataOutputStream.flush();
        return new Response(bufferedInputStream);
    }

    public String getRequestLine(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(methodSymbol[this.method]);
        stringBuffer.append(' ');
        stringBuffer.append(this.uri.toExternalFormWithoutFragment(bl));
        if (this.version != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.version.toString());
        }
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    protected void loadFirstLine(String string) throws IOException {
    }

    int getMethod() {
        return this.method;
    }

    public void close() throws IOException {
        if (this.sock != null) {
            this.sock.close();
        }
    }
}

