/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.util;

import COM.ibm.netdiver.util.Debug;
import java.util.Vector;

public class ThreadQueue
implements Runnable {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Vector requests;
    private Vector zombies;
    private int priority;
    int maxThreads;
    Thread[] running;
    Thread self;
    boolean stop = false;
    boolean terminate = false;
    boolean notified = false;
    private static int MAX_THREADS = 4;
    private static final int DEQUEUE = 0;
    private static final int ENQUEUE = 1;
    private static final int EXPIRE = 2;

    public ThreadQueue() {
        this(MAX_THREADS);
    }

    public ThreadQueue(int n) {
        this.maxThreads = n;
        this.running = new Thread[this.maxThreads];
        this.priority = Thread.currentThread().getPriority();
        this.requests = new Vector();
        this.self = new Thread(this);
        this.self.start();
    }

    public void push(Runnable runnable, String string, int n) {
        int n2 = this.priority + n;
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > 10) {
            n2 = 10;
        }
        this.queue(1, new ThreadQueueElement(this, runnable, string, n2));
    }

    public void push(Runnable runnable) {
        this.push(runnable, null, 0);
    }

    public void push(Runnable runnable, String string) {
        this.push(runnable, string, 0);
    }

    public synchronized void processNext() {
        this.notified = true;
        this.notify();
    }

    private synchronized void waitNotification() {
        try {
            if (!this.notified || this.requests.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            Debug.println(this, 1, (Object)interruptedException);
        }
        this.notified = false;
    }

    private synchronized ThreadQueueElement queue(int n, ThreadQueueElement threadQueueElement) {
        ThreadQueueElement threadQueueElement2 = null;
        switch (n) {
            case 0: {
                if (this.requests.size() <= 0) break;
                Debug.println(this, 1, (Object)("Dequeue from: " + this.requests.size()));
                try {
                    threadQueueElement2 = (ThreadQueueElement)this.requests.elementAt(0);
                    this.requests.removeElementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Debug.println(this, 1, (Object)arrayIndexOutOfBoundsException);
                }
                break;
            }
            case 1: {
                if (this.stop) {
                    this.salvage();
                    this.stop = false;
                }
                Debug.println(this, 1, (Object)("Enqueue from: " + this.requests.size()));
                this.requests.addElement(threadQueueElement);
                break;
            }
            case 2: {
                Debug.println(this, 1, (Object)("Expire from: " + this.requests.size()));
                this.requests.setSize(0);
                break;
            }
        }
        this.processNext();
        return threadQueueElement2;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block0: while (true) {
            this.waitNotification();
            if (this.terminate) break;
            var1_1 = 0;
            while (true) {
                if (var1_1 >= this.maxThreads) continue block0;
                if (this.running[var1_1] == null) ** GOTO lbl14
                if (this.running[var1_1].isAlive()) {
                    if (this.stop) {
                        Debug.println(this, 1, (Object)("call stop() for " + this.running[var1_1].getName()));
                        this.running[var1_1].stop();
                    }
                } else {
                    this.running[var1_1] = null;
lbl14:
                    // 2 sources

                    if ((var2_2 = this.queue(0, null)) != null) ** break;
                    continue block0;
                    this.running[var1_1] = var2_2.name != null ? new Thread((Runnable)var2_2, var2_2.name) : new Thread(var2_2);
                    this.running[var1_1].setPriority(var2_2.priority);
                    this.running[var1_1].start();
                }
                ++var1_1;
            }
            break;
        }
    }

    public void stop() {
        this.queue(2, null);
        this.stop = true;
        this.processNext();
    }

    public int getActiveCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxThreads) {
            if (this.running[n2] != null && this.running[n2].isAlive()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private synchronized void salvage() {
        int n;
        if (this.zombies != null) {
            n = 0;
            while (n < this.zombies.size()) {
                Thread thread = (Thread)this.zombies.elementAt(n);
                if (thread != null && thread.isAlive()) {
                    this.zombies.removeElementAt(n);
                    --n;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.maxThreads) {
            if (this.running[n] != null) {
                if (this.running[n].isAlive()) {
                    Debug.println(this, 1, (Object)("undead " + this.running[n].getName()));
                    if (this.zombies == null) {
                        this.zombies = new Vector();
                    }
                    this.zombies.addElement(this.running[n]);
                }
                this.running[n] = null;
            }
            ++n;
        }
    }

    public void terminate() {
        this.terminate = true;
        this.processNext();
        if (this.zombies != null) {
            int n = this.zombies.size();
            int n2 = 0;
            while (n2 < n) {
                Thread thread = (Thread)this.zombies.elementAt(n2);
                if (thread != null && thread.isAlive()) {
                    thread.destroy();
                }
                ++n2;
            }
        }
    }

    final class ThreadQueueElement
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        Runnable target;
        String name;
        int priority;
        ThreadQueue queue;

        ThreadQueueElement(ThreadQueue threadQueue2, Runnable runnable, String string, int n) {
            ThreadQueue.this = ThreadQueue.this;
            this.queue = threadQueue2;
            this.target = runnable;
            this.priority = n;
            this.name = string;
        }

        public void run() {
            this.target.run();
            this.queue.processNext();
        }
    }
}

