/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.util.StringTokenizer;

public abstract class Address
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    protected static final String ERROR_MISSING_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_ADDRESS");
    protected static final String ERROR_OCTET_NUMBER = DHCPServerGUI.getResourceString("ERROR_OCTET_NUMBER");
    protected static final String ERROR_OCTET_RANGE = DHCPServerGUI.getResourceString("ERROR_OCTET_RANGE");
    protected static final String ERROR_TWO_DOTS = DHCPServerGUI.getResourceString("ERROR_TWO_DOTS");
    protected static final String ERROR_START_OR_END_DOT = DHCPServerGUI.getResourceString("ERROR_START_OR_END_DOT");
    protected static final String ERROR_VALUE_IS_OCTAL = DHCPServerGUI.getResourceString("ERROR_VALUE_IS_OCTAL");
    protected static final String ERROR_NON_DECIMAL_OCTET = DHCPServerGUI.getResourceString("ERROR_NON_DECIMAL_OCTET");
    protected String address;
    protected int intAddress;
    protected boolean valid;

    public Address() {
        this.initAddress();
    }

    public static int dottedTo32BitAddress(String string) {
        if (string == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return 0;
        }
        int n = 0;
        try {
            n += Integer.parseInt(stringTokenizer.nextToken());
            int n2 = 1;
            while (n2 < 4) {
                n <<= 8;
                n += Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static final String integerToDottedDecimal(int n) {
        int[] nArray = new int[4];
        int n2 = 3;
        while (n2 >= 0) {
            nArray[n2] = n & 0xFF;
            n >>>= 8;
            --n2;
        }
        return String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
    }

    public static int lsbFromDottedDecimal(String string) {
        if (string == null) {
            return -1;
        }
        int n = Address.dottedTo32BitAddress(string.trim());
        boolean bl = false;
        int n2 = 0;
        while (n2 < 32) {
            if ((1 << n2 & n) != 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return -1;
        }
        return 32 - n2;
    }

    protected static Message validateAddress(String string) {
        return Address.validateAddressFormat(string);
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        Message message = Address.validateAddressFormat(string);
        if (message == null) {
            this.address = string.trim();
            this.intAddress = Address.dottedTo32BitAddress(this.address);
            this.valid = true;
            return null;
        }
        this.initAddress();
        return message;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getAddress() {
        return this.getStringAddress();
    }

    public String getStringAddress() {
        if (!this.valid) {
            return null;
        }
        return this.address;
    }

    public final String toString() {
        return this.getStringAddress();
    }

    public final int getIntegerAddress() {
        if (!this.valid) {
            return 0;
        }
        return this.intAddress;
    }

    public final void initAddress() {
        this.valid = false;
        this.intAddress = 0;
    }

    public Object clone() {
        Address address;
        try {
            address = (Address)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ShouldNotOccurException("Address caught " + cloneNotSupportedException + " when trying to clone " + this.address);
        }
        address.intAddress = this.intAddress;
        address.valid = this.valid;
        return address;
    }

    protected static Message validateAddressFormat(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        char[] cArray = string2.toCharArray();
        int n = 0;
        while (n < string2.length()) {
            if (!Character.isDigit(cArray[n]) && cArray[n] != '.') {
                return new Message(ERROR_NON_DECIMAL_OCTET);
            }
            ++n;
        }
        if (string2.indexOf(46) == 0 || string2.lastIndexOf(46) == string2.length() - 1) {
            return new Message(ERROR_START_OR_END_DOT);
        }
        if (string2.indexOf("..") != -1) {
            return new Message(ERROR_TWO_DOTS);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != 4) {
            return new Message(ERROR_OCTET_NUMBER);
        }
        int n2 = 0;
        while (n2 < 4) {
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.trim();
            if (!string4.equals(string3)) {
                return new Message(ERROR_NON_DECIMAL_OCTET);
            }
            try {
                int n3 = Integer.parseInt(string4);
                if (string4.length() > 1 && string4.charAt(0) == '0') {
                    return new Message(ERROR_VALUE_IS_OCTAL);
                }
                if (n3 < 0 || n3 > 255) {
                    return new Message(ERROR_OCTET_RANGE);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Message(ERROR_NON_DECIMAL_OCTET);
            }
            ++n2;
        }
        return null;
    }
}

