/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Keyword;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import java.text.MessageFormat;

public class BooleanKeyword
extends Keyword
implements Cloneable {
    private boolean value;
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String KEYWORD_VALUE_YES = "yes";
    public static final String KEYWORD_VALUE_NO = "no";

    public BooleanKeyword(String string, ConfigItem configItem) {
        super(string, configItem);
    }

    public BooleanKeyword(String string, boolean bl) {
        this(string, null);
        this.setValue(bl);
    }

    public BooleanKeyword(String string, ConfigItem configItem, boolean bl) {
        this(string, configItem);
        this.setValue(bl);
    }

    public String toString() {
        return String.valueOf(this.keyword) + " " + BooleanKeyword.mapBooleanKeyword(this.getValue());
    }

    public boolean getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return BooleanKeyword.mapBooleanKeyword(this.value);
    }

    public Message setValue(String string) {
        if ((string = string.trim()).equalsIgnoreCase(KEYWORD_VALUE_YES) || string.equalsIgnoreCase("true")) {
            return this.setValue(true);
        }
        if (string.equalsIgnoreCase(KEYWORD_VALUE_NO) || string.equalsIgnoreCase("false")) {
            return this.setValue(false);
        }
        Object[] objectArray = new Object[]{this.keyword, "{yes, no}"};
        return new Message(MessageFormat.format(Keyword.ERROR_INVALID_VALUE_FOR_KEYWORD, objectArray));
    }

    public Message setValue(boolean bl) {
        this.value = bl;
        return null;
    }

    public static final String mapBooleanKeyword(boolean bl) {
        if (bl) {
            return KEYWORD_VALUE_YES;
        }
        return KEYWORD_VALUE_NO;
    }

    public Object clone() {
        BooleanKeyword booleanKeyword = (BooleanKeyword)super.clone();
        return booleanKeyword;
    }
}

