/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.HardwareType;
import COM.ibm.raleigh.dhcpsgui.biz.LSA1Group;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CommonClient
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INCOMPLETE_CLIENT = DHCPServerGUI.getResourceString("ERROR_INCOMPLETE_CLIENT");
    private static final String ERROR_CLASS_PARENT = DHCPServerGUI.getResourceString("ERROR_CLASS_PARENT");
    private static final String ERROR_WRONG_PARENT = DHCPServerGUI.getResourceString("ERROR_WRONG_PARENT");
    private static final String ERROR_CLIENTID_TYPE0 = DHCPServerGUI.getResourceString("ERROR_CLIENTID_TYPE0");
    private static final String ERROR_CLIENTID_TOO_LONG = DHCPServerGUI.getResourceString("ERROR_CLIENTID_TOO_LONG");
    private static final String ERROR_CLIENTID_BAD_HEX = DHCPServerGUI.getResourceString("ERROR_CLIENTID_BAD_HEX");
    private static final String ERROR_MISSING_CLIENTID = DHCPServerGUI.getResourceString("ERROR_MISSING_CLIENTID");
    private static final String ERROR_IS_EXCLUDED_ADDR = DHCPServerGUI.getResourceString("ERROR_IS_EXCLUDED_ADDR");
    private static final String ERROR_TYPE_INVALID = DHCPServerGUI.getResourceString("ERROR_TYPE_INVALID");
    private static final String ERROR_INVALID_ID_IN_SUBNET = DHCPServerGUI.getResourceString("ERROR_INVALID_ID_IN_SUBNET");
    private static final String ERROR_INVALID_ID_AT_GLOBAL = DHCPServerGUI.getResourceString("ERROR_INVALID_ID_AT_GLOBAL");
    private static final String ERROR_INVALID_ID_IN_LSA1GROUP = DHCPServerGUI.getResourceString("ERROR_INVALID_ID_IN_LSA1GROUP");
    private static final String ERROR_INVALID_ID_IN_LSA2GROUP = DHCPServerGUI.getResourceString("ERROR_INVALID_ID_IN_LSA2GROUP");
    protected static final String TEXT_IP_ADDRESS = DHCPServerGUI.getResourceString("TEXT_IP_ADDRESS");
    protected static final String TEXT_ID = DHCPServerGUI.getResourceString("TEXT_ID");
    protected static final String TEXT_TYPE = DHCPServerGUI.getResourceString("TEXT_TYPE");
    private static final String TEXT_ID_TYPE = DHCPServerGUI.getResourceString("TEXT_ID_TYPE");
    private static final String TEXT_ID_VALUE = DHCPServerGUI.getResourceString("TEXT_ID_VALUE");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TEXT_ILLEGAL_CHARS = DHCPServerGUI.getResourceString("TEXT_ILLEGAL_CHARS");
    public static final String KEYWORD_CLIENT = "client";
    public static final String TEXT_EXCLUDE = "exclude";
    private HardwareType hwtype = new HardwareType();
    private String idValue;
    private boolean validIDAndType = false;

    public static Object parse(ConfigItem configItem, String string) {
        Message message;
        ConfigItem configItem2;
        Client client;
        ConfigItem configItem3;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        String string6 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            if (string2 == null || string3 == null || string4 == null) {
                return new Message(ERROR_INCOMPLETE_CLIENT);
            }
            string6 = Parsing.getAllAfter(string, string4);
        } else {
            if (string2 == null || string3 == null) {
                return new Message(ERROR_INCOMPLETE_CLIENT);
            }
            string6 = Parsing.getAllAfter(string, string3);
            string6 = string4 == null ? Parsing.getAllAfter(string, string3) : (string4.equals(TEXT_EXCLUDE) ? Parsing.getAllAfter(string, string4) : Parsing.getAllAfter(string, string3));
        }
        if (string6 != null && (string6 = string6.trim()).length() > 0 && (string5 = ConfigItem.breakOutAlias(string6)) == null) {
            return new Message(TEXT_ILLEGAL_CHARS);
        }
        if (string4 != null) {
            if (string2.equals("0") && string3.equals("0")) {
                if (configItem instanceof ConfigItemWithExcludedAddresses) {
                    Message message2 = ((ConfigItemWithExcludedAddresses)configItem).addExcludedAddress(string4);
                    if (message2 == null) {
                        ConfigItem configItem4 = configItem;
                        while (!(configItem4 instanceof Global) && !(configItem4 instanceof BINLGlobal)) {
                            configItem4 = configItem4.getParent();
                        }
                        if (((ConfigItemWithExcludedAddresses)configItem4).getClientWithIPAddress(string4) != null) {
                            return new Message("Another client with same IP Address");
                        }
                    }
                    return message2;
                }
                return new Message(ERROR_WRONG_PARENT);
            }
            if (string4.toUpperCase().equals("NONE") || string4.equalsIgnoreCase(TEXT_EXCLUDE)) {
                configItem3 = new ExcludedClient();
                client = configItem3;
            } else {
                configItem3 = new Client();
                client = configItem3;
                configItem2 = configItem;
                while (!(configItem2 instanceof Global) && !(configItem2 instanceof BINLGlobal)) {
                    configItem2 = configItem2.getParent();
                }
                if (((ConfigItemWithExcludedAddresses)configItem2).verifyAddressExcluded(string4) != null) {
                    return new Message("This client has been excluded before");
                }
                if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                    message = ((Client)configItem3).setAddress(string4);
                    if (message != null) {
                        return message;
                    }
                    message = ((Client)configItem3).validateAddress(configItem);
                    if (message != null) {
                        return message;
                    }
                }
            }
        } else {
            configItem3 = new Client();
            client = configItem3;
            configItem2 = configItem;
            while (!(configItem2 instanceof Global) && !(configItem2 instanceof BINLGlobal)) {
                configItem2 = configItem2.getParent();
            }
            if (((ConfigItemWithExcludedAddresses)configItem2).verifyAddressExcluded(string4) != null) {
                return new Message("This client has been excluded before");
            }
        }
        message = client.setIdType(string2);
        if (message != null) {
            return message;
        }
        message = client.setIdValue(string3);
        if (message != null) {
            return message;
        }
        configItem3 = configItem;
        while (!(configItem3 instanceof Global) && !(configItem3 instanceof BINLGlobal)) {
            configItem3 = configItem3.getParent();
        }
        message = client.validateIDAndType(configItem3);
        if (message != null) {
            return message;
        }
        if (string5 != null && (message = client.setAlias(string5)) != null) {
            return message;
        }
        if (client.commit(configItem)) {
            return client;
        }
        return new Message(ConfigItem.ERROR_WRONG_SCOPE);
    }

    public Message setIdTypeUsingIndex(int n) {
        return this.hwtype.setIdTypeFromIndex(n);
    }

    public Message setIdType(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Message(ERROR_TYPE_INVALID);
        }
        return this.hwtype.setIdTypeFromInteger(n);
    }

    public Message setIdType(int n) {
        return this.hwtype.setIdTypeFromInteger(n);
    }

    public String getTypeDescription() {
        return this.hwtype.getIdTypeDescription();
    }

    public int getIdTypeAsIndex() {
        return this.hwtype.getIdTypeAsIndex();
    }

    public String getIdTypeAsString() {
        return this.hwtype.getIdTypeAsString();
    }

    public int getIdType() {
        return this.hwtype.getIdTypeAsIndex();
    }

    public Message setIdValue(String string) {
        if (string != null) {
            this.idValue = string.trim();
            if (this.idValue.length() != 0) {
                return null;
            }
        }
        return new Message(ERROR_MISSING_CLIENTID);
    }

    public String getIdValue() {
        return this.idValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message validateIDAndType(ConfigItem configItem) {
        Object object;
        Object object2;
        this.validIDAndType = false;
        if (this.idValue == null) {
            return null;
        }
        int n = this.hwtype.getIdTypeAsInteger();
        if (n != 0) {
            object2 = this.idValue.toLowerCase();
            if (((String)object2).startsWith("0x")) {
                if (((String)object2).length() <= 2) return new Message(ERROR_CLIENTID_BAD_HEX);
                object2 = ((String)object2).substring(2);
            }
            if (((StringTokenizer)(object = new StringTokenizer((String)object2, "01234567890abcdef"))).countTokens() != 0) return new Message(ERROR_CLIENTID_TYPE0);
            if (((String)object2).length() > 12) {
                return new Message(ERROR_CLIENTID_TOO_LONG);
            }
        } else if (this.idValue.equals("0")) {
            return new Message(ERROR_IS_EXCLUDED_ADDR);
        }
        object2 = configItem;
        while (!(object2 instanceof Global) && !(object2 instanceof BINLGlobal)) {
            object2 = ((ConfigItem)object2).getParent();
        }
        object = (CommonClient)((ConfigItemWithExcludedAddresses)object2).getClientWithMacAddress("COM.ibm.raleigh.dhcpsgui.biz.Client", n, this.idValue);
        if (object != null && !object.equals(this)) {
            if (((ConfigItem)object).getParent() instanceof Global || ((ConfigItem)object).getParent() instanceof BINLGlobal) {
                return new Message(ERROR_INVALID_ID_AT_GLOBAL);
            }
            if (((ConfigItem)object).getParent() instanceof LSA2Group && this.getParent() instanceof LSA2Group) {
                return new Message(ERROR_INVALID_ID_IN_LSA2GROUP);
            }
            if (((ConfigItem)object).getParent() instanceof LSA1Group && this.getParent() instanceof LSA1Group) {
                return new Message(ERROR_INVALID_ID_IN_LSA1GROUP);
            }
            if (((ConfigItem)object).getParent() instanceof Subnetwork && this.getParent() instanceof Subnetwork) {
                return new Message(ERROR_INVALID_ID_IN_SUBNET);
            }
        }
        if (!(this instanceof ExcludedClient) && (object = (CommonClient)((ConfigItemWithExcludedAddresses)object2).getClientWithMacAddress("COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient", n, this.idValue)) != null && !object.equals(this)) {
            if (((ConfigItem)object).getParent() instanceof Global || ((ConfigItem)object).getParent() instanceof BINLGlobal) {
                return new Message(ERROR_INVALID_ID_AT_GLOBAL);
            }
            if (((ConfigItem)object).getParent() instanceof LSA2Group && this.getParent() instanceof LSA2Group) {
                return new Message(ERROR_INVALID_ID_IN_LSA2GROUP);
            }
            if (((ConfigItem)object).getParent() instanceof LSA1Group && this.getParent() instanceof LSA1Group) {
                return new Message(ERROR_INVALID_ID_IN_LSA1GROUP);
            }
            if (((ConfigItem)object).getParent() instanceof Subnetwork && this.getParent() instanceof Subnetwork) {
                return new Message(ERROR_INVALID_ID_IN_SUBNET);
            }
        }
        this.validIDAndType = true;
        return null;
    }

    public Vector buildClientVector(ConfigItem configItem, CommonClient commonClient) {
        Object e;
        Enumeration enumeration = configItem.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient", false);
        Enumeration enumeration2 = configItem.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Client", false);
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (e == commonClient) continue;
            vector.addElement(e);
        }
        while (enumeration2.hasMoreElements()) {
            e = enumeration2.nextElement();
            if (e == commonClient) continue;
            vector.addElement(e);
        }
        return vector;
    }

    public boolean isValidIDAndType() {
        return this.validIDAndType;
    }

    public static String[] getTypeList() {
        return HardwareType.getHWTypeStrings();
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global || configItem instanceof BINLGlobal || configItem instanceof LSA2Group || configItem instanceof LSA1Group || configItem instanceof Subnetwork;
    }

    public String getName() {
        String string = this.getAlias();
        if (string.equals("")) {
            return String.valueOf(this.getItemType()) + " ";
        }
        return String.valueOf(this.getItemType()) + " " + string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("client ");
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            stringBuffer.append(String.valueOf(this.hwtype.getIdTypeAsString()) + " " + this.getIdValue());
            if (this instanceof ExcludedClient) {
                stringBuffer.append(" exclude");
            }
        } else {
            stringBuffer.append(String.valueOf(this.hwtype.getIdTypeAsString()) + " " + this.getIdValue() + " " + this.getAddress());
        }
        if (!this.getAlias().equals("")) {
            stringBuffer.append(" (alias=" + this.getAliasWithQuotes());
        }
        return stringBuffer.toString();
    }

    public Object itemClone() {
        CommonClient commonClient = (CommonClient)super.itemClone();
        commonClient.hwtype = (HardwareType)this.hwtype.clone();
        return commonClient;
    }

    abstract String getAddress();

    public int getIdTypeAsInteger() {
        return this.hwtype.getIdTypeAsInteger();
    }
}

