/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.AddressRange;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public abstract class ConfigItemWithExcludedAddresses
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INVALID_SUBNET = DHCPServerGUI.getResourceString("ERROR_INVALID_SUBNET");
    private static final String ATTN_LIST_TOO_BIG = DHCPServerGUI.getResourceString("ATTN_LIST_TOO_BIG");
    protected IPSubnetAddress address;
    protected IPSubnetMask mask;
    protected boolean validsubnet = false;
    private Vector excludedAddresses = new Vector();
    private AddressRange temprange = new AddressRange();

    ConfigItemWithExcludedAddresses() {
    }

    public Message addExcludedAddress(String string, boolean bl) {
        IPAddress iPAddress = new IPAddress();
        Message message = iPAddress.setIPAddress(string);
        if (message == null && (message = this.validateExcludedAddress(iPAddress)) == null && bl) {
            this.excludedAddresses.addElement(iPAddress);
        }
        return message;
    }

    public Message addExcludedAddress(String string) {
        return this.addExcludedAddress(string, true);
    }

    public Message addExcludedAddresses(String string, String string2) {
        if (this.validsubnet) {
            this.temprange.initRange();
            this.temprange.setSubnetDefinition(this.address, this.mask);
        } else {
            new Message(ERROR_INVALID_SUBNET);
        }
        Message message = this.addExcludedAddress(string, false);
        if (message != null) {
            return message;
        }
        message = this.temprange.setAddressRangeStart(string);
        if (message != null) {
            return message;
        }
        message = this.addExcludedAddress(string2, false);
        if (message != null) {
            return message;
        }
        message = this.temprange.setAddressRangeEnd(string2);
        if (message != null) {
            return message;
        }
        message = this.temprange.validateAddressRange();
        if (message != null) {
            return message;
        }
        Enumeration enumeration = this.temprange.getAllAddresses();
        while (enumeration.hasMoreElements()) {
            message = this.addExcludedAddress((String)enumeration.nextElement());
            if (message == null) continue;
            return message;
        }
        if (this.excludedAddresses.size() > 10) {
            return new Message(ATTN_LIST_TOO_BIG);
        }
        return null;
    }

    public abstract Message validateExcludedAddress(IPAddress var1);

    public Message deleteExcludedAddress(String string) {
        int n = 0;
        while (n < this.excludedAddresses.size()) {
            if (this.excludedAddresses.elementAt(n).toString().equals(string.trim())) {
                this.excludedAddresses.removeElementAt(n);
                return null;
            }
            ++n;
        }
        return null;
    }

    public Enumeration getExcludedAddresses() {
        return this.excludedAddresses.elements();
    }

    String formatExcludedAddressesAsClients(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    protected void writeScopedItems(Stack stack, StringBuffer stringBuffer) {
        Enumeration enumeration = this.getExcludedAddresses();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n" + stack.peek() + "client" + " 0 0 " + enumeration.nextElement().toString());
        }
        super.writeScopedItems(stack, stringBuffer);
    }

    public Object itemClone() {
        ConfigItemWithExcludedAddresses configItemWithExcludedAddresses = (ConfigItemWithExcludedAddresses)super.itemClone();
        configItemWithExcludedAddresses.excludedAddresses = new Vector(this.excludedAddresses.size());
        int n = 0;
        while (n < this.excludedAddresses.size()) {
            configItemWithExcludedAddresses.excludedAddresses.addElement(((IPAddress)this.excludedAddresses.elementAt(n)).clone());
            ++n;
        }
        this.fieldClone(configItemWithExcludedAddresses);
        return configItemWithExcludedAddresses;
    }

    private void fieldClone(ConfigItemWithExcludedAddresses configItemWithExcludedAddresses) {
        configItemWithExcludedAddresses.temprange = this.temprange == null ? null : (AddressRange)this.temprange.clone();
        configItemWithExcludedAddresses.address = this.address == null ? null : (IPSubnetAddress)this.address.clone();
        configItemWithExcludedAddresses.mask = this.mask == null ? null : (IPSubnetMask)this.mask.clone();
        configItemWithExcludedAddresses.validsubnet = this.validsubnet;
    }

    public Object replacementClone() {
        ConfigItemWithExcludedAddresses configItemWithExcludedAddresses = (ConfigItemWithExcludedAddresses)super.replacementClone();
        this.fieldClone(configItemWithExcludedAddresses);
        return configItemWithExcludedAddresses;
    }

    public Object getClientWithIPAddress(String string) {
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Client", true);
        while (enumeration.hasMoreElements()) {
            Client client = (Client)enumeration.nextElement();
            if (!client.getAddress().equals(string)) continue;
            return client;
        }
        return null;
    }

    public Object getClientWithMacAddress(String string, int n, String string2) {
        Enumeration enumeration = this.getConfigItems(string, true);
        while (enumeration.hasMoreElements()) {
            CommonClient commonClient = (CommonClient)enumeration.nextElement();
            if (!commonClient.getIdValue().equals(string2.trim()) || commonClient.getIdTypeAsInteger() != n) continue;
            return commonClient;
        }
        return null;
    }

    public Object verifyAddressExcluded(String string) {
        Enumeration enumeration = this.getExcludedAddresses();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().toString().equals(string.trim())) continue;
            return this;
        }
        Enumeration enumeration2 = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Subnetwork", true);
        while (enumeration2.hasMoreElements()) {
            Subnetwork subnetwork = (Subnetwork)enumeration2.nextElement();
            enumeration = subnetwork.getExcludedAddresses();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().toString().equals(string.trim())) continue;
                return subnetwork;
            }
        }
        return null;
    }
}

