/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.ListCriteria;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Validatable;
import COM.ibm.raleigh.dhcpsgui.io.BINLTreeBuilder;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.TreeBuilder;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import COM.ibm.raleigh.utilExt.SortedHashtable;
import java.util.Enumeration;
import java.util.Vector;

public class Configuration
extends ConfigItem
implements Validatable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_DHCP_SERVER = DHCPServerGUI.getResourceString("TEXT_DHCP_SERVER");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    public static Configuration currentConfiguration;
    private IPAddress address;
    private TreeBuilder tb;
    private BINLTreeBuilder tbBinl;
    private boolean isValid = true;
    private String serverType;

    public Configuration(String string) {
        this.setItemType(string);
        currentConfiguration = this;
    }

    public boolean initializeItem() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            configItem.removeAllObservers();
        }
        this.children.removeAllElements();
        if (currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            new BINLServerParameters(this);
            new BINLGlobal(this);
        } else {
            new ServerParameters(this);
            new Global(this);
        }
        this.address = null;
        return true;
    }

    public boolean initializeItem(DHCPFile dHCPFile) {
        boolean bl = this.initializeItem();
        if (currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            this.tbBinl = BINLTreeBuilder.getTreeBuilder(dHCPFile);
            bl = this.tbBinl.buildConfigTree(this.getBINLServerParameters(), this.getBINLGlobal());
            currentConfiguration.setIsValid(bl);
        } else {
            this.tb = TreeBuilder.getTreeBuilder(dHCPFile);
            bl = this.tb.buildConfigTree(this.getServerParameters(), this.getGlobal());
            currentConfiguration.setIsValid(bl);
        }
        return bl;
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getName());
        return vector.elements();
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public boolean wereErrorsInFile() {
        if (this.tb != null) {
            return this.tb.wereErrorsInFile();
        }
        return true;
    }

    public String getAddress() {
        if (this.address != null) {
            return this.address.getIPAddress();
        }
        return null;
    }

    public String toString() {
        return "";
    }

    public Message setAddress(String string) {
        this.address = new IPAddress();
        return this.address.setIPAddress(string);
    }

    public String getName() {
        String string = this.getAddress();
        if (string != null) {
            return String.valueOf(this.getItemType()) + " " + string;
        }
        return this.getItemType();
    }

    public Global getGlobal() {
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Global", false);
        if (enumeration.hasMoreElements()) {
            Global global = (Global)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                throw new ShouldNotOccurException("Configuration has more than one Global element.");
            }
            return global;
        }
        throw new ShouldNotOccurException("Configuration doesn't have a Global object");
    }

    public BINLGlobal getBINLGlobal() {
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal", false);
        if (enumeration.hasMoreElements()) {
            BINLGlobal bINLGlobal = (BINLGlobal)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                throw new ShouldNotOccurException("Configuration has more than one Global element.");
            }
            return bINLGlobal;
        }
        throw new ShouldNotOccurException("Configuration doesn't have a Global object");
    }

    public ServerParameters getServerParameters() {
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.ServerParameters", false);
        if (enumeration.hasMoreElements()) {
            ServerParameters serverParameters = (ServerParameters)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                throw new ShouldNotOccurException("Configuration has more than one ServerParameters element.");
            }
            return serverParameters;
        }
        throw new ShouldNotOccurException("Configuration doesn't have a ServerParameters object");
    }

    public BINLServerParameters getBINLServerParameters() {
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters", false);
        if (enumeration.hasMoreElements()) {
            BINLServerParameters bINLServerParameters = (BINLServerParameters)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                throw new ShouldNotOccurException("Configuration has more than one ServerParameters element.");
            }
            return bINLServerParameters;
        }
        throw new ShouldNotOccurException("Configuration doesn't have a ServerParameters object");
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem == null;
    }

    String getTypeSpecificScheme() {
        return "DHCP Server ";
    }

    public SortedHashtable getUsedOptions() {
        SortedHashtable sortedHashtable = new SortedHashtable();
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Option", true);
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            String string = option.getTag();
            if (sortedHashtable.containsKey(string)) continue;
            sortedHashtable.put(string, option);
        }
        return sortedHashtable;
    }

    public boolean getWhetherOptionUsed(String string) {
        SortedHashtable sortedHashtable = this.getUsedOptions();
        return sortedHashtable.containsKey(string);
    }

    public String getItemType() {
        return this.serverType;
    }

    public void setItemType(String string) {
        this.serverType = string;
    }

    public Message validate() {
        Message message = null;
        Enumeration enumeration = this.getConfigItems(new Eval(), true).elements();
        while (enumeration.hasMoreElements()) {
            Message message2 = ((Validatable)enumeration.nextElement()).validate();
            if (message2 == null) continue;
            if (message == null) {
                message = message2;
                continue;
            }
            message.concat(message2);
        }
        return message;
    }

    private class Eval
    implements ListCriteria {
        public Object meetsCriteria(ConfigItem configItem) {
            if (configItem instanceof Validatable) {
                return configItem;
            }
            return null;
        }

        Eval() {
            Configuration.this = Configuration.this;
        }
    }
}

