/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.ARecKeyInfo;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DDNSKeyword;
import COM.ibm.raleigh.dhcpsgui.biz.DomainOrAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.io.DHCPServer;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DDNSKeySupport {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_DOMAIN_IN_LIST = DHCPServerGUI.getResourceString("TEXT_DOMAIN_IN_LIST");
    private static final String TEXT_COMMAND_COMPLETED = DHCPServerGUI.getResourceString("TEXT_COMMAND_COMPLETED");
    private ServerParameters serverParameters;
    static final String KEYWORD_releaseDNSA = "releaseDNSA";
    static final String KEYWORD_releaseDNSP = "releaseDNSP";
    static final String KEYWORD_updateDNSA = "updateDNSA";
    static final String KEYWORD_updateDNSP = "updateDNSP";
    static final String KEYWORD_updateDNS = "updateDNS";
    private static final String defaultUpdateDNSAString = "\"nsupdate -f -h%s -s\"d;a;*;a;a;%s;s;%s;3110400;q\"\"";
    private static final String defaultUpdateDNSPString = "\"nsupdate -f -r%s -s\"d;ptr;*;a;ptr;%s;s;%s;0;q\"\"";
    private static final String defaultReleaseDNSAString = "\"nsupdate -f -h%s  -s\"d;a;%s;s;%s;0;q\"\"";
    private static final String defaultReleaseDNSPString = "\"nsupdate -f -r%s -s\"d;ptr;%s;s;%s;0;q\"\"";
    private DDNSKeyword releaseDNSA = new DDNSKeyword("releaseDNSA", "\"nsupdate -f -h%s  -s\"d;a;%s;s;%s;0;q\"\"");
    private DDNSKeyword releaseDNSP = new DDNSKeyword("releaseDNSP", "\"nsupdate -f -r%s -s\"d;ptr;%s;s;%s;0;q\"\"");
    private DDNSKeyword updateDNSA = new DDNSKeyword("updateDNSA", "\"nsupdate -f -h%s -s\"d;a;*;a;a;%s;s;%s;3110400;q\"\"");
    private DDNSKeyword updateDNSP = new DDNSKeyword("updateDNSP", "\"nsupdate -f -r%s -s\"d;ptr;*;a;ptr;%s;s;%s;0;q\"\"");
    private ARecKeyInfo theARecKeyInfoObject = new ARecKeyInfo(this);
    private Hashtable domains = new Hashtable();

    public DDNSKeySupport(ServerParameters serverParameters) {
        this.serverParameters = serverParameters;
        serverParameters.addKeyword(KEYWORD_releaseDNSA.toUpperCase(), this.releaseDNSA);
        serverParameters.addKeyword(KEYWORD_releaseDNSP.toUpperCase(), this.releaseDNSP);
        serverParameters.addKeyword(KEYWORD_updateDNSA.toUpperCase(), this.updateDNSA);
        serverParameters.addKeyword(KEYWORD_updateDNSP.toUpperCase(), this.updateDNSP);
        serverParameters.addKeyword("(ARecKeyInfo".toUpperCase(), this.theARecKeyInfoObject);
        this.initialize();
        this.updateDNSA.setAutoUpdate(true);
        this.releaseDNSA.setAutoUpdate(true);
    }

    void initialize() {
        this.domains.clear();
    }

    public boolean getAutoDNSP() {
        return this.updateDNSP.isAutoUpdate();
    }

    public void setAutoDNSP(boolean bl) {
        this.updateDNSP.setAutoUpdate(bl);
        this.releaseDNSP.setAutoUpdate(bl);
    }

    public Message addDomain(String string, String string2) {
        if (this.domains.containsKey(string = string.trim())) {
            Object[] objectArray = new Object[]{string};
            return new Message(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_DOMAIN_IN_LIST"), objectArray));
        }
        string2 = string2.trim();
        Message message = DomainOrAddress.isValidHostOrAddress(string);
        if (message == null && (message = DomainOrAddress.isValidHostOrAddress(string2)) == null) {
            this.domains.put(string, String.valueOf(string) + "  " + string2);
        }
        return message;
    }

    public boolean removeDomain(String string) {
        if (this.domains.containsKey(string = string.trim())) {
            this.domains.remove(string);
            return true;
        }
        return false;
    }

    public Enumeration getDomains() {
        return this.domains.elements();
    }

    public Enumeration getARecKeyInformation() {
        Vector<String> vector = new Vector<String>(5);
        Enumeration enumeration = this.getDomains();
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), " ");
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            vector.addElement("*." + string + "!" + string2);
        }
        return vector.elements();
    }

    public static boolean generateARecKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "!");
        if (stringTokenizer.countTokens() != 2) {
            throw new ShouldNotOccurException("<domain!server> was expected");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(4);
        vector.addElement(String.valueOf(DDNSKeySupport.getNSupdateCmd()) + " ");
        vector.addElement("-f ");
        vector.addElement("-g ");
        vector.addElement("-h " + string2 + " ");
        vector.addElement("-p " + string3 + " ");
        return DDNSKeySupport.issueCommand(vector, true);
    }

    public Enumeration getPtrRecKeyInformation() {
        Configuration configuration = (Configuration)this.serverParameters.getParent();
        String string = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>(5);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = configuration.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Subnetwork", true);
        while (enumeration.hasMoreElements()) {
            Subnetwork subnetwork = (Subnetwork)enumeration.nextElement();
            String string3 = subnetwork.getAddress();
            String string4 = subnetwork.getDDNSServer();
            if (string4 == null) continue;
            StringBuffer stringBuffer2 = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            if (stringTokenizer.countTokens() == 4) {
                int n = 0;
                while (n <= 2) {
                    string = stringTokenizer.nextToken();
                    if (n > 0 && string.equals("0")) break;
                    if (n < 2) {
                        stringBuffer.insert(0, String.valueOf(string) + ".");
                    }
                    stringBuffer2.insert(0, String.valueOf(string) + ".");
                    ++n;
                }
            } else {
                throw new ShouldNotOccurException();
            }
            stringBuffer2.insert(0, "*.");
            if (!vector.contains(String.valueOf(stringBuffer2.toString()) + "in-addr.arpa" + "!" + string4)) {
                vector.addElement(String.valueOf(stringBuffer2.toString()) + "in-addr.arpa" + "!" + string4);
            }
            if (string.equals("0") || string.equals(null)) continue;
            StringBuffer stringBuffer3 = new StringBuffer();
            String string5 = subnetwork.getPoolRange();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ".");
            if (stringTokenizer2.countTokens() == 7) {
                Object object;
                int n = 0;
                while (n <= 5) {
                    string2 = stringTokenizer2.nextToken();
                    if (n == 3) {
                        int n2 = string2.indexOf(45);
                        object = string2.substring(n2 + 1);
                        stringBuffer3.insert(0, String.valueOf(object) + '.');
                    }
                    if (n > 3) {
                        stringBuffer3.insert(0, String.valueOf(string2) + '.');
                    }
                    ++n;
                }
                stringBuffer3.insert(0, "*.");
                Integer n3 = new Integer(string);
                object = new Integer(string2);
                int n4 = n3 + 1;
                while (n4 <= (Integer)object) {
                    StringBuffer stringBuffer4 = new StringBuffer();
                    stringBuffer4.insert(0, "." + stringBuffer.toString());
                    stringBuffer4.insert(0, n4);
                    stringBuffer4.insert(0, "*.");
                    if (!vector.contains(String.valueOf(stringBuffer4.toString()) + "in-addr.arpa" + "!" + string4)) {
                        vector.addElement(String.valueOf(stringBuffer4.toString()) + "in-addr.arpa" + "!" + string4);
                    }
                    ++n4;
                }
                continue;
            }
            throw new ShouldNotOccurException();
        }
        return vector.elements();
    }

    public static boolean generatePtrRecKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "!");
        if (stringTokenizer.countTokens() != 2) {
            throw new ShouldNotOccurException("<address!server> was expected");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(5);
        vector.addElement(String.valueOf(DDNSKeySupport.getNSupdateCmd()) + " ");
        vector.addElement("-f ");
        vector.addElement("-h " + string2 + " ");
        vector.addElement("-g ");
        vector.addElement("-p" + string3 + " ");
        return DDNSKeySupport.issueCommand(vector, true);
    }

    private static String getNSupdateCmd() {
        File file = new File(String.valueOf(DHCPServer.getETCdir()) + File.separatorChar + ".." + File.separatorChar + "bin" + File.separatorChar + "nsupdate.exe");
        return file.getAbsolutePath();
    }

    private static boolean issueCommand(Vector vector, boolean bl) {
        block11: {
            int n = -1;
            if (vector != null && !vector.isEmpty()) {
                Runtime runtime = Runtime.getRuntime();
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    stringBuffer.append(" " + (String)objectArray[n2]);
                    ++n2;
                }
                System.out.println("issuing command: " + stringBuffer.toString());
                try {
                    Process process = runtime.exec((String[])objectArray);
                    if (bl) {
                        try {
                            n = process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                        try {
                            String string;
                            if (n != 0) {
                                Object[] objectArray2 = new Object[]{objectArray[0], new Integer(n)};
                                string = MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_COMMAND_COMPLETED"), objectArray2);
                            } else {
                                Object[] objectArray3 = new Object[]{objectArray[0], new Integer(n)};
                                string = MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_COMMAND_COMPLETED"), objectArray3);
                            }
                            System.out.println(string);
                            return n == 0;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            break block11;
                        }
                    }
                    return true;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.toString());
                    return false;
                }
            }
            throw new IllegalArgumentException();
        }
        return true;
    }
}

