/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.util.StringTokenizer;

public class HexString
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_MISSING_HEX_PREFIX_OR_QUOTES = DHCPServerGUI.getResourceString("ERROR_MISSING_HEX_PREFIX_OR_QUOTES");
    private static final String ERROR_HEX_PAIRS = DHCPServerGUI.getResourceString("ERROR_HEX_PAIRS");
    private static final String ERROR_HEX_DIGITS = DHCPServerGUI.getResourceString("ERROR_HEX_DIGITS");
    private static final String ERROR_MISSING_HEX_STRING = DHCPServerGUI.getResourceString("ERROR_MISSING_HEX_STRING");
    private String hexstring;
    private boolean valid;
    private String displayvalue;

    public HexString() {
        this.valid = false;
    }

    public HexString(String string) {
        this.setHexString(string);
    }

    public String toString() {
        if (this.valid) {
            return "hex\"" + this.hexstring + "\"";
        }
        return null;
    }

    public String getHexString() {
        if (this.valid) {
            return this.hexstring;
        }
        return null;
    }

    public String getDisplayValue() {
        return this.displayvalue;
    }

    public String getCompressedHexString() {
        if (this.valid) {
            return HexString.toCompressedString(this.hexstring);
        }
        return null;
    }

    public void setHexString(String string) {
        this.hexstring = string;
        this.valid = false;
    }

    public void setDisplayValue(String string) {
        this.displayvalue = string;
    }

    public Message setHexStringAndValidate(String string, boolean bl) {
        this.hexstring = string;
        return this.validate(bl);
    }

    private Message validate(boolean bl) {
        this.valid = false;
        if (this.hexstring == null || this.hexstring.equals("")) {
            return new Message(ERROR_MISSING_HEX_STRING);
        }
        this.hexstring = this.hexstring.trim();
        if (bl) {
            if (!this.hexstring.toLowerCase().startsWith("hex") || this.hexstring.length() <= 3) {
                return new Message(ERROR_MISSING_HEX_PREFIX_OR_QUOTES);
            }
            this.hexstring = this.hexstring.substring(3).trim();
            if (this.hexstring.length() > 0 && !this.hexstring.startsWith("\"")) {
                return new Message(ERROR_MISSING_HEX_PREFIX_OR_QUOTES);
            }
            if (this.hexstring.length() < 2 || !this.hexstring.endsWith("\"")) {
                return new Message(ERROR_HEX_DIGITS);
            }
            this.hexstring = this.hexstring.substring(1, this.hexstring.length() - 1);
        } else if (this.hexstring.length() > 2 && this.hexstring.startsWith("\"") && this.hexstring.endsWith("\"")) {
            this.hexstring = this.hexstring.substring(1, this.hexstring.length() - 1);
        }
        if (this.hexstring.length() == 0) {
            return new Message(ERROR_MISSING_HEX_STRING);
        }
        this.hexstring = HexString.toCompressedString(this.hexstring);
        StringTokenizer stringTokenizer = new StringTokenizer(this.hexstring, "ABCDEFabcdef0123456789");
        if (stringTokenizer.countTokens() != 0) {
            return new Message(ERROR_HEX_DIGITS);
        }
        if (this.hexstring.length() % 2 != 0) {
            return new Message(ERROR_HEX_PAIRS);
        }
        this.hexstring = HexString.toCanonicalForm(this.hexstring);
        this.valid = true;
        return null;
    }

    public Object clone() {
        HexString hexString;
        try {
            hexString = (HexString)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ShouldNotOccurException("HexString caught " + cloneNotSupportedException + " when trying to clone itself");
        }
        return hexString;
    }

    static String toCanonicalForm(String string) {
        String string2 = HexString.toCompressedString(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        stringBuffer.append(string2.substring(0, 2));
        int n2 = 2;
        while (n2 < n) {
            stringBuffer.append(" ");
            stringBuffer.append(string2.substring(n2, n2 + 2));
            n2 += 2;
        }
        return stringBuffer.toString();
    }

    static String toCompressedString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer = stringBuffer.append(stringTokenizer.nextToken());
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

