/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;

public class IPBroadcastAddress
extends Address {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_BROADCAST_ADDRESS = DHCPServerGUI.getResourceString("ERROR_BROADCAST_ADDRESS");
    private static final String ERROR_MISSING_BROADCAST_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_BROADCAST_ADDRESS");

    public static Message validateAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_BROADCAST_ADDRESS);
        }
        String string2 = string.trim();
        Message message = Address.validateAddressFormat(string2);
        if (message == null) {
            message = IPBroadcastAddress.checkLastOctet(string2);
        }
        return message;
    }

    public Message setIPBroadcastAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_BROADCAST_ADDRESS);
        }
        return this.setAddress(string.trim());
    }

    public String getIPBroadcastAddress() {
        return this.getAddress();
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_BROADCAST_ADDRESS);
        }
        Message message = super.setAddress(string.trim());
        if (message == null && (message = IPBroadcastAddress.checkLastOctet(this.address)) != null) {
            super.initAddress();
        }
        return message;
    }

    public Object clone() {
        return (IPBroadcastAddress)super.clone();
    }

    private static Message checkLastOctet(String string) {
        if (string == null || string.equals("")) {
            return new Message(ERROR_MISSING_BROADCAST_ADDRESS);
        }
        int n = Integer.parseInt(string.trim().substring(string.lastIndexOf(46) + 1));
        if ((n | 1) != n) {
            return new Message(ERROR_BROADCAST_ADDRESS);
        }
        return null;
    }
}

