/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.LogItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.BoundedInteger;
import COM.ibm.raleigh.utilExt.Filename;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class LogFile {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_DESCRIPTION_LOG_SYSTEM_ERRORS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_SYSTEM_ERRORS");
    private static final String TEXT_DESCRIPTION_LOG_ACCOUNTING = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_ACCOUNTING");
    private static final String TEXT_DESCRIPTION_LOG_OBJECT_ERRORS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_OBJECT_ERRORS");
    private static final String TEXT_DESCRIPTION_LOG_EVENTS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_EVENTS");
    private static final String TEXT_DESCRIPTION_LOG_PROTOCOL_ERRORS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_PROTOCOL_ERRORS");
    private static final String TEXT_DESCRIPTION_LOG_WARNINGS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_WARNINGS");
    private static final String TEXT_DESCRIPTION_LOG_INFORMATION = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_INFORMATION");
    private static final String TEXT_DESCRIPTION_LOG_TRACE = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_TRACE");
    private static final String TEXT_DESCRIPTION_LOG_SERVER_ACTIONS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_SERVER_ACTIONS");
    private static final String TEXT_DESCRIPTION_LOG_STATISTICS = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION_LOG_STATISTICS");
    private static final String TEXT_WILL_NOT_LOG = DHCPServerGUI.getResourceString("TEXT_WILL_NOT_LOG");
    private static final String ERROR_KEYWORD_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_KEYWORD_NOT_VALID");
    private static final String ERROR_INVALID_FILENAME = DHCPServerGUI.getResourceString("ERROR_INVALID_FILENAME");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TEXT_INVALID_BINL_LOGFILE = DHCPServerGUI.getResourceString("TEXT_INVALID_BINL_LOGFILE");
    private static final String TEXT_INVALID_DHCP_LOGFILE = DHCPServerGUI.getResourceString("TEXT_INVALID_DHCP_LOGFILE");
    private Filename logFileName;
    private BoundedInteger logFileSize = new BoundedInteger();
    private BoundedInteger numLogFiles = new BoundedInteger();
    private Vector logItems;
    private static final String NONE = "";
    public static final String KEYWORD_NUM_LOG_FILES = "numLogFiles";
    public static final String KEYWORD_LOG_FILE_SIZE = "logFileSize";
    public static final String KEYWORD_LOG_FILE_NAME = "logFileName";
    public static final String KEYWORD_LOG_SYSTEM_ERRORS = "SYSERR";
    public static final String KEYWORD_LOG_ACCOUNTING = "ACNTING";
    public static final String KEYWORD_LOG_OBJECT_ERRORS = "OBJERR";
    public static final String KEYWORD_LOG_EVENTS = "EVENT";
    public static final String KEYWORD_LOG_PROTOCOL_ERRORS = "PROTERR";
    public static final String KEYWORD_LOG_WARNINGS = "WARNING";
    public static final String KEYWORD_LOG_INFORMATION = "INFO";
    public static final String KEYWORD_LOG_TRACE = "TRACE";
    public static final String KEYWORD_LOG_SERVER_ACTIONS = "ACTION";
    public static final String KEYWORD_LOG_STATISTICS = "STAT";

    public LogFile() {
        this.logFileSize.setRange(1, Integer.MAX_VALUE);
        this.numLogFiles.setRange(0, Integer.MAX_VALUE);
        this.logItems = new Vector(10);
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_SYSTEM_ERRORS, KEYWORD_LOG_SYSTEM_ERRORS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_ACCOUNTING, KEYWORD_LOG_ACCOUNTING));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_OBJECT_ERRORS, KEYWORD_LOG_OBJECT_ERRORS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_EVENTS, KEYWORD_LOG_EVENTS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_PROTOCOL_ERRORS, KEYWORD_LOG_PROTOCOL_ERRORS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_WARNINGS, KEYWORD_LOG_WARNINGS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_INFORMATION, KEYWORD_LOG_INFORMATION));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_TRACE, KEYWORD_LOG_TRACE));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_SERVER_ACTIONS, KEYWORD_LOG_SERVER_ACTIONS));
        this.logItems.addElement(new LogItem(TEXT_DESCRIPTION_LOG_STATISTICS, KEYWORD_LOG_STATISTICS));
        this.initialize();
    }

    protected void initialize() {
        int n = this.logItems.size() - 1;
        while (n >= 0) {
            ((LogItem)this.logItems.elementAt(n)).setState(false);
            --n;
        }
        this.logFileSize.setValue("100");
        this.numLogFiles.setValue("10");
        this.setLogItemState(KEYWORD_LOG_SYSTEM_ERRORS, true);
        this.setLogItemState(KEYWORD_LOG_OBJECT_ERRORS, true);
        this.setLogItemState(KEYWORD_LOG_WARNINGS, true);
        this.setLogItemState(KEYWORD_LOG_INFORMATION, true);
    }

    public Message setParameter(String string, String string2) {
        if (string.equalsIgnoreCase(KEYWORD_NUM_LOG_FILES)) {
            return this.setNumLogFiles(string2);
        }
        if (string.equalsIgnoreCase(KEYWORD_LOG_FILE_SIZE)) {
            return this.setLogFileSize(string2);
        }
        if (string.equalsIgnoreCase(KEYWORD_LOG_FILE_NAME)) {
            return this.setLogFileName(string2);
        }
        if (string.equalsIgnoreCase("logItem")) {
            return this.setLogItemState(string2, true);
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getLogFileName();
        if (!string.equals(NONE)) {
            stringBuffer.append("\nlogFileName " + string);
        }
        if (!(string = this.getLogFileSize()).equals(NONE)) {
            stringBuffer.append("\nlogFileSize " + string);
        }
        if (!(string = this.getNumLogFiles()).equals(NONE)) {
            stringBuffer.append("\nnumLogFiles " + string);
        }
        Enumeration enumeration = this.getLogItems();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }

    public Message isLogStateValid() {
        if (!this.getNumLogFiles().equals(NONE) && Integer.parseInt(this.getNumLogFiles()) >= 1 && (this.getLogItemCount() == 0 || this.getLogFileName().equals(NONE) || this.getLogFileSize().equals(NONE) || this.getNumLogFiles().equals(NONE))) {
            return new Message(TEXT_WILL_NOT_LOG);
        }
        return null;
    }

    public Message setLogFileName(String string) {
        string = string.trim();
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            if (string.equalsIgnoreCase("dhcpsd.log")) {
                return new Message(TEXT_INVALID_BINL_LOGFILE);
            }
        } else if (string.equalsIgnoreCase("binlsd.log")) {
            return new Message(TEXT_INVALID_DHCP_LOGFILE);
        }
        if (this.logFileName == null) {
            this.logFileName = new Filename(string);
        }
        return this.logFileName.setFilename(string);
    }

    public String getLogFileName() {
        String string = Configuration.currentConfiguration.getItemType();
        if (string.equalsIgnoreCase(TEXT_BINL_SERVER)) {
            if (this.logFileName == null) {
                this.logFileName = new Filename("binlsd.log");
            }
        } else if (this.logFileName == null) {
            this.logFileName = new Filename("dhcpsd.log");
        }
        return this.logFileName.getFilename();
    }

    public Message setLogFileSize(String string) {
        return this.logFileSize.setValue(string);
    }

    public String getLogFileSize() {
        return this.logFileSize.getValue();
    }

    public Enumeration getLogItems() {
        return this.logItems.elements();
    }

    public Message setNumLogFiles(String string) {
        return this.numLogFiles.setValue(string);
    }

    public String getNumLogFiles() {
        return this.numLogFiles.getValue();
    }

    public Message setLogItemState(String string, boolean bl) {
        int n = 0;
        while (n < this.logItems.size()) {
            LogItem logItem = (LogItem)this.logItems.elementAt(n);
            if (logItem.getKeyword().equalsIgnoreCase(string)) {
                logItem.setState(bl);
                return null;
            }
            ++n;
        }
        Object[] objectArray = new Object[]{string};
        return new Message(MessageFormat.format(ERROR_KEYWORD_NOT_VALID, objectArray));
    }

    public int getLogItemCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.logItems.size()) {
            LogItem logItem = (LogItem)this.logItems.elementAt(n2);
            if (logItem.getState()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }
}

