/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetProfile;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import java.util.Enumeration;
import java.util.Vector;

public class NetNode {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private NetNode rightchild;
    private NetNode leftchild;
    private int network;
    private Vector[] subnetList = new Vector[25];

    public NetNode() {
        this(0);
    }

    public NetNode(int n) {
        this.network = n;
        int n2 = 0;
        while (n2 < 25) {
            this.subnetList[n2] = new Vector();
            ++n2;
        }
    }

    public void setRightChild(NetNode netNode) {
        this.rightchild = netNode;
    }

    public NetNode getRightChild() {
        return this.rightchild;
    }

    public void setLeftChild(NetNode netNode) {
        this.leftchild = netNode;
    }

    public NetNode getLeftChild() {
        return this.leftchild;
    }

    public void setNetwork(int n) {
        this.network = n;
    }

    public int getNetwork() {
        return this.network;
    }

    public void addSubnet(Subnetwork subnetwork) {
        IPSubnetMask iPSubnetMask = subnetwork.getMaskObject();
        int n = Address.lsbFromDottedDecimal(iPSubnetMask.getDottedAddress());
        if (n > 23) {
            n = 24;
        }
        SubnetProfile subnetProfile = null;
        int n2 = this.subnetList[n].size();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            subnetProfile = (SubnetProfile)this.subnetList[n].elementAt(n3);
            if (subnetProfile.getAddress().equals(subnetwork.getAddress())) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            subnetProfile.addSubnet(subnetwork, subnetwork.getPoolRangeObject());
            return;
        }
        subnetProfile = new SubnetProfile(subnetwork.getAddress());
        this.subnetList[n].addElement(subnetProfile);
        subnetProfile.addSubnet(subnetwork, subnetwork.getPoolRangeObject());
    }

    public void addSubnetProfile(SubnetProfile subnetProfile, int n) {
        this.subnetList[n].addElement(subnetProfile);
    }

    public Enumeration getSubnetInfo(int n) {
        return this.subnetList[n].elements();
    }
}

