/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.CommonOption;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.HexString;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.PXEOptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Option
extends CommonOption {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private OptionSkeleton oSkel;
    private static final String ERROR_INVALID_OPTION_SYNTAX = DHCPServerGUI.getResourceString("ERROR_INVALID_OPTION_SYNTAX");
    private static final String ERROR_OPTION_TAG_INVALID = DHCPServerGUI.getResourceString("ERROR_OPTION_TAG_INVALID");
    private static final String TEXT_OPTION_TYPE = DHCPServerGUI.getResourceString("TEXT_OPTION_TYPE");
    private static final String TEXT_OPTION_ONE_LINE_DESCRIPTION = DHCPServerGUI.getResourceString("TEXT_OPTION_ONE_LINE_DESCRIPTION");
    public static final String TEXT_SKELETON_CREATED = DHCPServerGUI.getResourceString("TEXT_SKELETON_CREATED");
    public static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");

    public String getLongDescription() {
        return this.oSkel.getLongDescription();
    }

    public String getBriefDescription() {
        return this.oSkel.getBriefDescription();
    }

    public String getDatatype() {
        return this.oSkel.getDatatype();
    }

    public String getItemType() {
        return TEXT_OPTION_TYPE;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() throws ShouldNotOccurException {
        block36: {
            block38: {
                block41: {
                    block40: {
                        block39: {
                            block37: {
                                block35: {
                                    var1_1 = new StringBuffer();
                                    var2_2 = this.oSkel.getDatatype();
                                    if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(Option.TEXT_BINL_SERVER)) {
                                        var1_1.append("pxeoption " + this.getTag());
                                    } else if (this.getParent() instanceof Vendor) {
                                        var3_3 = ((Vendor)this.getParent()).getVendorName();
                                        if (var3_3.equalsIgnoreCase("PXEClient")) {
                                            var4_4 = Configuration.currentConfiguration.getServerParameters();
                                            if (var4_4.getServerType().getValue().equalsIgnoreCase("dhcp")) {
                                                var1_1.append(String.valueOf('#') + "option" + " " + this.getTag());
                                            } else {
                                                var1_1.append("option " + this.getTag());
                                            }
                                        } else {
                                            var1_1.append("option " + this.getTag());
                                        }
                                    } else {
                                        var1_1.append("option " + this.getTag());
                                    }
                                    var3_3 = this.getValue();
                                    if (!this.oSkel.isRFC_architected()) break block35;
                                    if (var2_2.equals("String") && var3_3.trim().indexOf(" ") > 0) {
                                        if (!this.hexformat) {
                                            var1_1.append(" \"" + var3_3 + "\"");
                                        } else {
                                            var1_1.append(" " + this.hexstring.toString());
                                        }
                                    } else if (!this.hexformat) {
                                        var1_1.append(" " + var3_3);
                                    } else {
                                        var1_1.append(" " + this.hexstring.toString());
                                    }
                                    break block36;
                                }
                                var4_4 = null;
                                if (!var2_2.equals("Boolean") && !var2_2.equals("Choice")) break block37;
                                var5_5 = this.oSkel.getChoiceValues();
                                try {
                                    var4_4 = Integer.toHexString(var5_5.indexOf(var3_3));
                                }
                                catch (Exception v0) {
                                    return var1_1.toString();
                                }
                                if (var4_4.length() == 1) {
                                    var4_4 = "0" + (String)var4_4;
                                }
                                break block38;
                            }
                            if (!var2_2.equals("Integer")) break block39;
                            try {
                                var4_4 = Integer.toHexString(Integer.parseInt(var3_3));
                            }
                            catch (Exception v1) {
                                return var1_1.toString();
                            }
                            if (var4_4.length() % 2 != 0) {
                                var4_4 = "0" + (String)var4_4;
                            }
                            break block38;
                        }
                        if (!var2_2.equals("Time")) break block40;
                        try {
                            var4_4 = Integer.toHexString(Integer.parseInt(var3_3));
                            if (true) ** GOTO lbl71
                        }
                        catch (Exception v2) {
                            return var1_1.toString();
                        }
                        do {
                            var4_4 = "0" + (String)var4_4;
lbl71:
                            // 2 sources

                        } while (var4_4.length() < 8);
                        break block38;
                    }
                    if (!var2_2.equals("IP address") && !var2_2.equals("Multicast IP address")) break block41;
                    try {
                        var4_4 = Integer.toHexString(Address.dottedTo32BitAddress(var3_3));
                        if (true) ** GOTO lbl82
                    }
                    catch (Exception v3) {
                        return var1_1.toString();
                    }
                    do {
                        var4_4 = "0" + (String)var4_4;
lbl82:
                        // 2 sources

                    } while (var4_4.length() < 8);
                    break block38;
                }
                if (!var2_2.equals("IP addresses")) break block38;
                var5_6 = new StringTokenizer(var3_3, " ");
                var6_7 = new StringBuffer();
                while (var5_6.hasMoreTokens()) {
                    try {
                        var7_8 = Integer.toHexString(Address.dottedTo32BitAddress(var5_6.nextToken()));
                        if (true) ** GOTO lbl96
                    }
                    catch (Exception v4) {
                        return var1_1.toString();
                    }
                    do {
                        var7_8 = "0" + var7_8;
lbl96:
                        // 2 sources

                    } while (var7_8.length() < 8);
                    var6_7.append(var7_8);
                }
                var4_4 = var6_7.toString();
            }
            if (var4_4 != null) {
                if (var4_4.length() % 2 != 0) {
                    var4_4 = "0" + (String)var4_4;
                }
                var1_1.append(" hex\"" + HexString.toCanonicalForm((String)var4_4) + "\"");
            } else if (this.hexformat) {
                var1_1.append(" " + this.hexstring.toString());
            } else {
                var1_1.append(" \"" + var3_3 + "\"");
            }
        }
        return var1_1.toString();
    }

    public static Object parse(ConfigItem configItem, String string) {
        return CommonOption.commonParse(new Option(), configItem, string);
    }

    public Message setTag(String string, ConfigItem configItem) {
        Object[] objectArray;
        Message message = null;
        String string2 = null;
        if (configItem instanceof Vendor) {
            objectArray = (Object[])configItem;
            string2 = objectArray.getVendorName();
        } else {
            string2 = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? "PXEClient" : null;
        }
        message = CommonOption.isValidTag(string);
        if (message == null) {
            this.tag = string;
            this.oSkel = string2 == null ? OptionSkeletonManager.getOptionSkeleton(this.tag) : (string2.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.getOptionSkeleton(this.tag) : OptionSkeletonManager.getOptionSkeleton(this.tag));
            if (this.oSkel == null && (message = this.createMinimalSkeleton(this.tag, string2)) == null) {
                this.oSkel = string2 == null ? OptionSkeletonManager.getOptionSkeleton(this.tag) : (string2.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.getOptionSkeleton(this.tag) : OptionSkeletonManager.getOptionSkeleton(this.tag));
                objectArray = new Object[]{this.tag};
                this.addMessage(new Message(MessageFormat.format(TEXT_SKELETON_CREATED, objectArray)));
            }
        }
        return message;
    }

    private Message createMinimalSkeleton(String string, String string2) {
        Message message = string2 == null ? OptionSkeletonManager.createSkeleton(string, "", "", "String", "") : (string2.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.createSkeleton(string, "", "", "String", "") : OptionSkeletonManager.createSkeleton(string, "", "", "String", ""));
        return message;
    }

    public String getName() {
        return String.valueOf(this.getItemType()) + this.getTag() + " " + this.getValue();
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global && !this.getTag().equals("51") || configItem instanceof BINLGlobal || configItem instanceof Subnetwork || configItem instanceof DHCPClass || configItem instanceof Vendor || configItem instanceof LSA2Group || configItem instanceof Client;
    }

    String getTypeSpecificScheme() {
        if (this.getParent() instanceof Global) {
            return "DHCP Global Options";
        }
        if (this.getParent() instanceof Subnetwork) {
            return "DHCP Pool Options";
        }
        if (this.getParent() instanceof DHCPClass) {
            return "DHCP Class Options";
        }
        if (this.getParent() instanceof Client) {
            return "DHCP Client Options";
        }
        if (this.getParent() instanceof Vendor) {
            return "DHCP Vendor Options";
        }
        return "DHCP No Icon";
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = new Object[]{this.getItemType(), this.getTag(), this.getBriefDescription()};
        vector.addElement(MessageFormat.format(TEXT_OPTION_ONE_LINE_DESCRIPTION, objectArray));
        String string = this.getLongDescription();
        int n = string.indexOf(".");
        if (n > 0 && n < 60) {
            vector.addElement("(" + string.substring(0, n) + "... )");
        }
        return vector.elements();
    }

    public Object clone() {
        Option option = (Option)super.clone();
        return option;
    }
}

