/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.HexString;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPBroadcastAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPMulticastAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.PXEOptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.BoundedInteger;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionValidator {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_NOT_AN_INTEGER = DHCPServerGUI.getResourceString("ERROR_NOT_AN_INTEGER");
    private static final String ERROR_TIME_NOT_INTEGER = DHCPServerGUI.getResourceString("ERROR_TIME_NOT_INTEGER");
    private static final String ERROR_BAD_BOOLEAN = DHCPServerGUI.getResourceString("ERROR_BAD_BOOLEAN");
    private static final String ERROR_BAD_CHOICE = DHCPServerGUI.getResourceString("ERROR_BAD_CHOICE");
    private static final String ERROR_OUT_OF_ORDER = DHCPServerGUI.getResourceString("ERROR_OUT_OF_ORDER");
    private static final String ERROR_NOT_INTEGER_IN_LIST = DHCPServerGUI.getResourceString("ERROR_NOT_INTEGER_IN_LIST");
    private static final String ERROR_EMPTY_LIST = DHCPServerGUI.getResourceString("ERROR_EMPTY_LIST");
    private static final String ERROR_NO_MATE = DHCPServerGUI.getResourceString("ERROR_NO_MATE");
    private static final String ERROR_NO_MATE_MASK = DHCPServerGUI.getResourceString("ERROR_NO_MATE_MASK");
    private static final String ERROR_NOT_SUPPOSED_TO_BE_ADDRESS = DHCPServerGUI.getResourceString("ERROR_NOT_SUPPOSED_TO_BE_ADDRESS");
    private static final String TEXT_LIST_LOCATION = DHCPServerGUI.getResourceString("TEXT_LIST_LOCATION");
    private static final String TEXT_FULL_VALUE = DHCPServerGUI.getResourceString("TEXT_FULL_VALUE");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    public static final String DELETE_OPTION = "Delete option";
    private static String dataLabel;
    private static Integer dataMinimum;
    private static Integer dataMaximum;
    private static String dataType;
    private static String tag;
    private static Message msg;
    private static String theVendorName;

    public static Object validateOption(String string, String string2, ConfigItem configItem) {
        Object object;
        tag = string;
        if (configItem instanceof Vendor) {
            object = (Vendor)configItem;
            theVendorName = ((Vendor)object).getVendorName();
        } else {
            theVendorName = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? "PXEClient" : null;
        }
        OptionSkeleton optionSkeleton = theVendorName == null ? OptionSkeletonManager.getOptionSkeleton(tag) : (theVendorName.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.getOptionSkeleton(tag) : OptionSkeletonManager.getOptionSkeleton(tag));
        if (optionSkeleton == null) {
            throw new ShouldNotOccurException("OptionSkeleton does not exist for option with tag = " + tag);
        }
        dataType = optionSkeleton.getDatatype();
        if (dataType == null) {
            throw new ShouldNotOccurException("OptionValidator validateOption():  DHCP option tag exists but its data type is null.");
        }
        msg = null;
        object = string2.trim();
        if (tag.equals("51")) {
            if (theVendorName == null) {
                return Lease.validateLeaseValue((String)object);
            }
            if (theVendorName.equalsIgnoreCase("PXEClient")) {
                return null;
            }
            return Lease.validateLeaseValue((String)object);
        }
        if (dataType.equals("Boolean") || dataType.equals("Choice")) {
            return OptionValidator.choiceCheck((String)object);
        }
        if (dataType.equals("Integer")) {
            return OptionValidator.integerCheck((String)object);
        }
        if (dataType.equals("Time")) {
            return OptionValidator.timeCheck((String)object);
        }
        if (dataType.equals("Time short")) {
            return OptionValidator.shortTimeCheck((String)object);
        }
        if (dataType.equals("Integer list")) {
            return OptionValidator.integerListCheck((String)object);
        }
        if (dataType.equals("IP address")) {
            return OptionValidator.addressCheck((String)object);
        }
        if (dataType.equals("Multicast IP address")) {
            return OptionValidator.multicastAddressCheck((String)object);
        }
        if (dataType.equals("IP addresses")) {
            return OptionValidator.addressListCheck((String)object);
        }
        if (dataType.equals("IP address pairs")) {
            return OptionValidator.addressPairCheck((String)object, false);
        }
        if (dataType.equals("String")) {
            return OptionValidator.alphaNumCheck((String)object);
        }
        if (dataType.equals("Mask in either Integer or IP address format")) {
            return OptionValidator.maskCheck((String)object);
        }
        if (dataType.equals("Broadcast IP address")) {
            return OptionValidator.broadcastCheck((String)object);
        }
        if (dataType.equals("IP address pairs with mask")) {
            return OptionValidator.addressPairCheck((String)object, true);
        }
        if (dataType.equals("Menu Prompt")) {
            int n = ((String)object).indexOf(" ");
            if (n > 0) {
                String string3 = ((String)object).substring(0, n);
                return OptionValidator.integerCheck(string3);
            }
            return OptionValidator.integerCheck((String)object);
        }
        return null;
    }

    public static Object validateOption(String string, HexString hexString, ConfigItem configItem) {
        if (configItem instanceof Vendor) {
            Vendor vendor = (Vendor)configItem;
            theVendorName = vendor.getVendorName();
        } else {
            theVendorName = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? "PXEClient" : null;
        }
        tag = string;
        OptionSkeleton optionSkeleton = theVendorName == null ? OptionSkeletonManager.getOptionSkeleton(tag) : (theVendorName.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.getOptionSkeleton(tag) : OptionSkeletonManager.getOptionSkeleton(tag));
        if (optionSkeleton == null) {
            throw new ShouldNotOccurException("OptionSkeleton does not exist for option with tag = " + tag);
        }
        dataType = optionSkeleton.getDatatype();
        if (dataType == null) {
            throw new ShouldNotOccurException("OptionValidator validateOption():  DHCP option tag exists but its data type is null.");
        }
        msg = null;
        if (dataType.equals("Boolean") || dataType.equals("Choice")) {
            return OptionValidator.choiceCheck(hexString);
        }
        if (dataType.equals("Integer")) {
            return OptionValidator.integerCheck(hexString);
        }
        if (dataType.equals("Time")) {
            return OptionValidator.timeCheck(hexString);
        }
        if (dataType.equals("IP address")) {
            return OptionValidator.addressCheck(hexString);
        }
        if (dataType.equals("IP addresses")) {
            return OptionValidator.addressListCheck(hexString);
        }
        if (dataType.equals("String")) {
            return OptionValidator.alphaNumCheck(hexString);
        }
        return null;
    }

    private static Message choiceCheck(String string) {
        Vector vector = theVendorName == null ? OptionSkeletonManager.getChoiceValues(tag) : (theVendorName.equalsIgnoreCase("PXEClient") ? PXEOptionSkeletonManager.getChoiceValues(tag) : OptionSkeletonManager.getChoiceValues(tag));
        if (vector.indexOf(string) >= 0) {
            return null;
        }
        if (dataType == "Boolean") {
            return new Message(String.valueOf(ERROR_BAD_BOOLEAN) + string);
        }
        return new Message(String.valueOf(ERROR_BAD_CHOICE) + string);
    }

    private static Message choiceCheck(HexString hexString) {
        int n;
        try {
            n = Integer.parseInt(hexString.getCompressedHexString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{hexString.toString()};
            return new Message(MessageFormat.format(ERROR_NOT_AN_INTEGER, objectArray));
        }
        String string = String.valueOf(n);
        msg = OptionValidator.choiceCheck(string);
        if (msg == null) {
            hexString.setDisplayValue(string);
        }
        return msg;
    }

    private static Message integerCheck(String string) {
        if (theVendorName == null) {
            dataMinimum = OptionSkeletonManager.getDataMinimum(tag);
            dataMaximum = OptionSkeletonManager.getDataMaximum(tag);
        } else if (theVendorName.equalsIgnoreCase("PXEClient")) {
            dataMinimum = PXEOptionSkeletonManager.getDataMinimum(tag);
            dataMaximum = PXEOptionSkeletonManager.getDataMaximum(tag);
        } else {
            dataMinimum = OptionSkeletonManager.getDataMinimum(tag);
            dataMaximum = OptionSkeletonManager.getDataMaximum(tag);
        }
        return BoundedInteger.isIntegerWithinSpecifiedRange(string, dataMinimum, dataMaximum);
    }

    private static Message integerCheck(HexString hexString) {
        int n;
        try {
            n = Integer.parseInt(hexString.getCompressedHexString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{hexString.toString()};
            return new Message(MessageFormat.format(ERROR_NOT_AN_INTEGER, objectArray));
        }
        String string = String.valueOf(n);
        msg = OptionValidator.integerCheck(string);
        if (msg == null) {
            hexString.setDisplayValue(string);
        }
        return msg;
    }

    private static Object shortTimeCheck(String string) {
        if (string.trim().equals("0")) {
            return DELETE_OPTION;
        }
        return BoundedInteger.isIntegerWithinSpecifiedRange(string, 1, 255);
    }

    private static Object timeCheck(String string) {
        Integer n;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Message(String.valueOf(ERROR_TIME_NOT_INTEGER) + string);
        }
        if (n == 0) {
            return DELETE_OPTION;
        }
        return null;
    }

    private static Object timeCheck(HexString hexString) {
        int n;
        try {
            n = Integer.parseInt(hexString.getCompressedHexString(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{hexString.toString()};
            return new Message(MessageFormat.format(ERROR_NOT_AN_INTEGER, objectArray));
        }
        String string = String.valueOf(n);
        Object object = OptionValidator.timeCheck(string);
        if (object == null) {
            hexString.setDisplayValue(string);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private static Message integerListCheck(String var0) {
        var1_1 = new StringTokenizer(var0, " ");
        var2_2 = new Vector<Integer>();
        if (var1_1.hasMoreTokens()) ** GOTO lbl18
        return new Message(OptionValidator.ERROR_EMPTY_LIST);
lbl-1000:
        // 1 sources

        {
            var5_5 = var1_1.nextToken();
            var3_3 = OptionValidator.integerCheck(var5_5);
            if (var3_3 != null) {
                return var3_3;
            }
            var4_4 = Integer.parseInt(var5_5);
            if (var2_2.isEmpty()) {
                var2_2.addElement(new Integer(var4_4));
                continue;
            }
            var6_6 = (Integer)var2_2.lastElement();
            if (var6_6 == null) continue;
            if (var4_4 < var6_6) {
                return new Message(String.valueOf(OptionValidator.ERROR_OUT_OF_ORDER) + var0);
            }
            var2_2.addElement(new Integer(var4_4));
lbl18:
            // 4 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl19:
        // 1 sources

        return null;
    }

    private static Message addressCheck(String string) {
        msg = IPAddress.validateAddress(string);
        if (msg != null) {
            msg.setOtherData(String.valueOf(TEXT_FULL_VALUE) + string);
        }
        return msg;
    }

    private static Message multicastAddressCheck(String string) {
        msg = IPMulticastAddress.validateAddress(string);
        if (msg != null) {
            msg.setOtherData(String.valueOf(TEXT_FULL_VALUE) + string);
        }
        return msg;
    }

    private static Message addressCheck(HexString hexString) {
        int n;
        String string = hexString.getCompressedHexString();
        if (string.length() % 4 != 0) {
            return new Message(String.valueOf(TEXT_LIST_LOCATION) + hexString.toString());
        }
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{hexString.toString()};
            return new Message(MessageFormat.format(ERROR_NOT_AN_INTEGER, objectArray));
        }
        String string2 = Address.integerToDottedDecimal(n);
        msg = OptionValidator.addressCheck(string2);
        if (msg == null) {
            hexString.setDisplayValue(string2);
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    private static Message addressListCheck(String var0) {
        var1_1 = new StringTokenizer(var0, " ");
        if (var1_1.hasMoreTokens()) ** GOTO lbl8
        return new Message(OptionValidator.ERROR_EMPTY_LIST);
lbl-1000:
        // 1 sources

        {
            OptionValidator.msg = IPAddress.validateAddress(var1_1.nextToken());
            if (OptionValidator.msg == null) continue;
            OptionValidator.msg.setOtherData(String.valueOf(OptionValidator.TEXT_LIST_LOCATION) + var0);
            return OptionValidator.msg;
lbl8:
            // 2 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return null;
    }

    private static Message addressListCheck(HexString hexString) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = hexString.getCompressedHexString();
        if (string.length() % 4 != 0) {
            return new Message(String.valueOf(TEXT_LIST_LOCATION) + hexString.toString());
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Integer.parseInt(string.substring(n2, n2 + 8), 16);
            stringBuffer.append(String.valueOf(Address.integerToDottedDecimal(n3)) + " ");
            n2 += 8;
        }
        String string2 = stringBuffer.toString();
        msg = OptionValidator.addressListCheck(string2);
        if (msg == null) {
            hexString.setDisplayValue(string2);
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    private static Message addressPairCheck(String var0, boolean var1_1) {
        var2_2 = new StringTokenizer(var0, " ");
        if (var2_2.hasMoreTokens()) ** GOTO lbl15
        return new Message(String.valueOf(OptionValidator.ERROR_EMPTY_LIST) + var0);
lbl-1000:
        // 1 sources

        {
            var3_3 = new StringTokenizer(var2_2.nextToken(), ":");
            OptionValidator.msg = IPAddress.validateAddress(var3_3.nextToken());
            if (OptionValidator.msg == null) {
                if (!var3_3.hasMoreTokens()) {
                    if (!var1_1) {
                        return new Message(String.valueOf(OptionValidator.ERROR_NO_MATE) + var0);
                    }
                    return new Message(String.valueOf(OptionValidator.ERROR_NO_MATE_MASK) + var0);
                }
                OptionValidator.msg = var1_1 == false ? IPAddress.validateAddress(var3_3.nextToken()) : IPSubnetMask.validateAddress(var3_3.nextToken());
            }
            if (OptionValidator.msg == null) continue;
            OptionValidator.msg.setOtherData(String.valueOf(OptionValidator.TEXT_LIST_LOCATION) + var0);
            return OptionValidator.msg;
lbl15:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl16:
        // 1 sources

        return null;
    }

    private static Message alphaNumCheck(String string) {
        return null;
    }

    private static Message alphaNumCheck(HexString hexString) {
        if (msg == null) {
            hexString.setDisplayValue(hexString.toString());
        }
        return null;
    }

    private static Message maskCheck(String string) {
        msg = IPSubnetMask.validateAddress(string);
        if (msg != null) {
            msg.setOtherData(String.valueOf(TEXT_FULL_VALUE) + string);
        }
        return msg;
    }

    private static Message broadcastCheck(String string) {
        msg = IPBroadcastAddress.validateAddress(string);
        if (msg != null) {
            msg.setOtherData(String.valueOf(TEXT_FULL_VALUE) + string);
        }
        return msg;
    }

    static {
        theVendorName = null;
    }
}

