/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BooleanKeyword;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DDNSKeySupport;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.ImageServer;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.LogFile;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParametersKeyword;
import COM.ibm.raleigh.dhcpsgui.biz.ServerType;
import COM.ibm.raleigh.dhcpsgui.biz.UnlistedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServerParameters
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_KEYWORD_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_KEYWORD_NOT_VALID");
    private static final String TEXT_SERVER_PARAMETERS = DHCPServerGUI.getResourceString("TEXT_SERVER_PARAMETERS");
    public static final String VENDOR_PXECLIENT = "PXEClient";
    private String backupString;
    private LogFile logFile;
    private Lease lease;
    private DDNSKeySupport dDNSKeySupport;
    private UnlistedClient unlistedClient;
    private BooleanKeyword supportBOOTP;
    private BooleanKeyword broadcastReplies;
    private BooleanKeyword userMatchesVendor;
    private ServerType serverType;
    private ImageServer imageServer;
    private static final String KEYWORD_SUPPORT_BOOTP = "supportBOOTP";
    public static final String KEYWORD_SUPPORT_UNLISTED_CLIENTS = "supportUnlistedClients";
    private static final String KEYWORD_ALL_ROUTES_BROADCAST = "allRoutesBroadcast";
    private static final String KEYWORD_USER_MATCHES_VENDOR = "UserMatchesVendorClass";
    public static final boolean USE_RIF_OR_SRB = false;
    public static final boolean ALL_ROUTES_BROADCAST = true;
    private Hashtable keywordTable = new Hashtable();

    ServerParameters(ConfigItem configItem) {
        this.logFile = new LogFile();
        this.lease = new Lease();
        this.dDNSKeySupport = new DDNSKeySupport(this);
        this.serverType = new ServerType(this);
        this.imageServer = new ImageServer(this);
        this.initialize();
        this.commit(configItem);
    }

    private void initialize() {
        this.supportBOOTP = new BooleanKeyword(KEYWORD_SUPPORT_BOOTP, false);
        this.unlistedClient = new UnlistedClient();
        this.broadcastReplies = new BooleanKeyword(KEYWORD_ALL_ROUTES_BROADCAST, false);
        this.userMatchesVendor = new BooleanKeyword(KEYWORD_USER_MATCHES_VENDOR, false);
    }

    public Message setParameter(String string) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
            string2 = stringTokenizer.hasMoreElements() ? string.substring(string3.length() + 1).trim() : "";
        } else {
            throw new IllegalArgumentException();
        }
        Message message = this.isKeyword(string3);
        if (message != null) {
            return message;
        }
        if (string2 == "") {
            Message message2 = new Message();
            message2.addWarning("Keyword without a value, default will be assigned if rule permits !!");
            return message2;
        }
        if (string3.equalsIgnoreCase("updateDNS")) {
            string3 = "updateDNSP";
        }
        if (string3.equalsIgnoreCase("numLogFiles") || string3.equalsIgnoreCase("logFileSize") || string3.equalsIgnoreCase("logFileName") || string3.equalsIgnoreCase("logItem")) {
            return this.getLogFile().setParameter(string3, string2);
        }
        if (string3.equalsIgnoreCase("reservedTime") || string3.equalsIgnoreCase("leaseTimeDefault") || string3.equalsIgnoreCase("leaseExpireInterval") || string3.equalsIgnoreCase("usedIPAddressExpireInterval") || string3.equalsIgnoreCase("statisticSnapshot") || string3.equalsIgnoreCase("pingTime")) {
            return this.getLease().setParameter(string3, string2);
        }
        if (this.keywordTable.containsKey(string3.toUpperCase())) {
            return ((ServerParametersKeyword)this.keywordTable.get(string3.toUpperCase())).process(string2);
        }
        if (string3.equalsIgnoreCase(KEYWORD_SUPPORT_BOOTP)) {
            return this.supportBOOTP.setValue(string2);
        }
        if (string3.equalsIgnoreCase(KEYWORD_SUPPORT_UNLISTED_CLIENTS)) {
            return this.unlistedClient.parseValue(string3, string2);
        }
        if (string3.equalsIgnoreCase(KEYWORD_ALL_ROUTES_BROADCAST)) {
            return this.broadcastReplies.setValue(string2);
        }
        if (string3.equalsIgnoreCase("servertype")) {
            return this.serverType.setValue(string2);
        }
        if (string3.equalsIgnoreCase("imageserver")) {
            return this.imageServer.setValue(string2);
        }
        if (string3.equalsIgnoreCase(KEYWORD_USER_MATCHES_VENDOR)) {
            return this.userMatchesVendor.setValue(string2);
        }
        throw new ShouldNotOccurException();
    }

    public Message isKeyword(String string) {
        if (string.equalsIgnoreCase("updateDNS") || string.equalsIgnoreCase("numLogFiles") || string.equalsIgnoreCase("logFileSize") || string.equalsIgnoreCase("logFileName") || string.equalsIgnoreCase("logItem") || string.equalsIgnoreCase("reservedTime") || string.equalsIgnoreCase("leaseTimeDefault") || string.equalsIgnoreCase("leaseExpireInterval") || string.equalsIgnoreCase("usedIPAddressExpireInterval") || string.equalsIgnoreCase("statisticSnapshot") || string.equalsIgnoreCase("pingTime") || this.keywordTable.containsKey(string.toUpperCase()) || string.equalsIgnoreCase(KEYWORD_SUPPORT_BOOTP) || string.equalsIgnoreCase(KEYWORD_SUPPORT_UNLISTED_CLIENTS) || string.equalsIgnoreCase(KEYWORD_ALL_ROUTES_BROADCAST) || string.equalsIgnoreCase("servertype") || string.equalsIgnoreCase("imageserver") || string.equalsIgnoreCase(KEYWORD_USER_MATCHES_VENDOR)) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        return new Message(MessageFormat.format(ERROR_KEYWORD_NOT_VALID, objectArray));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLogFile().toString());
        stringBuffer.append(this.lease.toString());
        Enumeration enumeration = this.keywordTable.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((ServerParametersKeyword)enumeration.nextElement()).toString();
            if (string == null) continue;
            stringBuffer.append(string);
        }
        stringBuffer.append("\n" + this.supportBOOTP.toString());
        stringBuffer.append("\n" + this.unlistedClient.toString());
        stringBuffer.append("\n" + this.broadcastReplies.toString());
        stringBuffer.append("\n" + this.userMatchesVendor.toString());
        stringBuffer.append("\n" + this.getServerType().toString());
        String string = this.getImageServer().toString();
        if (string != null) {
            stringBuffer.append("\n" + string);
        }
        return stringBuffer.toString();
    }

    public String toStringForView() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Vendor vendor = new Vendor();
        Vendor vendor2 = null;
        Global global = null;
        stringBuffer.append(this.getLogFile().toString());
        stringBuffer.append(this.lease.toString());
        Enumeration enumeration = this.keywordTable.elements();
        while (enumeration.hasMoreElements()) {
            object = ((ServerParametersKeyword)enumeration.nextElement()).toString();
            if (object == null) continue;
            stringBuffer.append((String)object);
        }
        stringBuffer.append("\n" + this.supportBOOTP.toString());
        stringBuffer.append("\n" + this.unlistedClient.toString());
        stringBuffer.append("\n" + this.broadcastReplies.toString());
        stringBuffer.append("\n" + this.userMatchesVendor.toString());
        String string = this.getServerType().toString();
        if (string != null) {
            stringBuffer.append("\n" + string);
        }
        if ((string = this.getImageServer().toString()) != null) {
            stringBuffer.append("\n" + string);
        }
        vendor.setName(VENDOR_PXECLIENT);
        global = Configuration.currentConfiguration.getGlobal();
        vendor2 = vendor.getADuplicateVendor(global);
        if (vendor2 != null && (object = vendor2.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Option", false)).hasMoreElements()) {
            stringBuffer.append("\n" + vendor2.toStringWithScopedItems());
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.getItemType();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public Lease getLease() {
        return this.lease;
    }

    public DDNSKeySupport getDDNSKeySupport() {
        return this.dDNSKeySupport;
    }

    public BooleanKeyword getSupportBOOTP() {
        return this.supportBOOTP;
    }

    public BooleanKeyword getUserMatchesVendor() {
        return this.userMatchesVendor;
    }

    public BooleanKeyword getBroadcastReplies() {
        return this.broadcastReplies;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public ImageServer getImageServer() {
        return this.imageServer;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Configuration;
    }

    String getTypeSpecificScheme() {
        return "DHCP No Icon";
    }

    public Enumeration getOneLineDescription() {
        return new Vector().elements();
    }

    public String getItemType() {
        return TEXT_SERVER_PARAMETERS;
    }

    public void backup() {
        this.backupString = this.toStringForView();
    }

    public void restore() {
        this.lease.initialize();
        this.logFile.initialize();
        this.dDNSKeySupport.initialize();
        this.initialize();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.backupString, "\n");
        String string = "vendor PXEClient";
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(String.valueOf('#') + "vendor" + ' ' + VENDOR_PXECLIENT) > -1) {
                string2 = string2.replace('#', ' ');
                string2 = string2.trim();
            }
            if ((n = string2.indexOf("#")) > 0) {
                string2 = string2.substring(0, n);
                string2 = string2.trim();
            }
            if (string2.substring(0, 1).equals("#")) continue;
            if ((string2 = string2.trim()).equalsIgnoreCase(string)) {
                object = Configuration.currentConfiguration.getGlobal();
                Vendor vendor = new Vendor();
                vendor.setName(VENDOR_PXECLIENT);
                Vendor vendor2 = vendor.getADuplicateVendor((ConfigItem)object);
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                while (!string2.equals("}")) {
                    if (string2.indexOf(String.valueOf('#') + "option") > -1) {
                        string2 = string2.replace('#', ' ');
                        string2 = string2.trim();
                    }
                    Option option = new Option();
                    string2 = string2.trim();
                    int n2 = string2.indexOf(32);
                    int n3 = string2.indexOf(32, n2 + 1);
                    String string3 = string2.substring(n2 + 1, n3);
                    option.setTag(string3, vendor);
                    string3 = string2.substring(n3 + 1);
                    option.setValue(string3, vendor);
                    option.commit(vendor);
                    vendor.commit((ConfigItem)object);
                    vendor2.replaceItem(vendor);
                    string2 = stringTokenizer.nextToken();
                    if (string2.indexOf("#}") <= -1) continue;
                    string2 = "}";
                }
                continue;
            }
            object = this.setParameter(string2);
            if (object == null) continue;
            throw new ShouldNotOccurException("ServerParameters restore():  error found in <" + string2 + ">: " + ((Message)object).getText());
        }
    }

    void addKeyword(String string, ServerParametersKeyword serverParametersKeyword) {
        this.keywordTable.put(string, serverParametersKeyword);
    }

    public int getUnlistedClientSupportType() {
        return this.unlistedClient.getUnlistedClientSupportType();
    }

    public void setUnlistedClientSupportType(int n) {
        this.unlistedClient.setUnlistedClientSupportType(n);
    }
}

