/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SubnetGroup
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_MALFORMED_LABEL = DHCPServerGUI.getResourceString("ERROR_MALFORMED_LABEL");
    private static final String ERROR_BAD_PRIORITY = DHCPServerGUI.getResourceString("ERROR_BAD_PRIORITY");
    private static final String ERROR_INVALID_SUBNETGROUP_NAME = DHCPServerGUI.getResourceString("ERROR_INVALID_SUBNETGROUP_NAME");
    private static final String TEXT_CONTAINS_SUBNETS = DHCPServerGUI.getResourceString("TEXT_CONTAINS_SUBNETS");
    private static final String TEXT_NETWORK_GROUP = DHCPServerGUI.getResourceString("TEXT_NETWORK_GROUP");
    public static final String KEYWORD_BALANCE = "balance:";
    public static final String KEYWORD_INORDER = "inOrder:";
    public static final String KEYWORD_SUBNET = "subnet:";
    private static final String LABEL = "label:";
    private static final int NO_PRIORITY_SPECIFIED = Integer.MAX_VALUE;
    private String groupName = "";
    private boolean enabled = false;
    private String order = "inOrder:";

    public boolean replaceSubnetworks(Vector vector) {
        Vector vector2 = (Vector)this.children.clone();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Comment) continue;
            Subnetwork subnetwork = (Subnetwork)e;
            this.removeSubnet(subnetwork);
        }
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof Subnetwork) {
                this.addSubnet((Subnetwork)vector.elementAt(n));
            }
            ++n;
        }
        return true;
    }

    public void addSubnet(Subnetwork subnetwork) {
        if (!this.children.contains(subnetwork)) {
            if (subnetwork.getParent() != null) {
                subnetwork.getParent().deleteChild(subnetwork);
            }
            subnetwork.commit(this);
        }
    }

    protected void addSubnet(Subnetwork subnetwork, int n) {
        Subnetwork subnetwork2 = null;
        int n2 = 0;
        while (n2 < this.children.size()) {
            if (!(this.children.elementAt(n2) instanceof Comment)) {
                Subnetwork subnetwork3 = (Subnetwork)this.children.elementAt(n2);
                if (n <= subnetwork3.priority) {
                    subnetwork.commitAt(this, subnetwork2);
                    subnetwork.priority = n;
                    return;
                }
                subnetwork2 = subnetwork3;
            }
            ++n2;
        }
        this.addSubnet(subnetwork);
        subnetwork.priority = n;
    }

    private void removeSubnet(Subnetwork subnetwork) {
        if (this.children.contains(subnetwork)) {
            this.deleteChild(subnetwork);
            subnetwork.commit(this.getParent());
        }
    }

    public void setOrder(String string) {
        if (string.equals(KEYWORD_INORDER) || string.equals(KEYWORD_BALANCE)) {
            this.order = string;
            return;
        }
        throw new IllegalArgumentException();
    }

    public String getOrder() {
        return this.order;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Message setGroupName(String string) {
        if ((string = string.trim()) == null || string.length() == 0 || string.length() > 64 || string.indexOf(" ") != -1 || string.indexOf("#") != -1 || string.regionMatches(true, 0, KEYWORD_SUBNET, 0, KEYWORD_SUBNET.length() - 1) || string.regionMatches(true, 0, KEYWORD_INORDER, 0, KEYWORD_INORDER.length() - 1) || string.regionMatches(true, 0, KEYWORD_BALANCE, 0, KEYWORD_BALANCE.length() - 1)) {
            Object[] objectArray = new Object[]{string};
            return new Message(MessageFormat.format(ERROR_INVALID_SUBNETGROUP_NAME, objectArray));
        }
        this.groupName = string;
        return null;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global;
    }

    String getTypeSpecificScheme() {
        if (this.getEnabledState()) {
            return "DHCP MSW";
        }
        return "DHCP MSWD";
    }

    public String getName() {
        return String.valueOf(this.getItemType()) + " " + this.getGroupName();
    }

    public String toString(Subnetwork subnetwork) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" label:" + this.getGroupName());
        String string = Integer.toString(this.children.indexOf(subnetwork) + 1);
        if (string != null) {
            stringBuffer.append("/" + string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "";
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getItemType()) + ":  " + this.getGroupName());
        Object[] objectArray = new Object[]{new Integer(this.children.size())};
        vector.addElement(" " + MessageFormat.format(TEXT_CONTAINS_SUBNETS, objectArray));
        return vector.elements();
    }

    public Vector getSubnets() {
        Vector<ConfigItem> vector = new Vector<ConfigItem>(this.children.size());
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            if (!(configItem instanceof Subnetwork)) continue;
            vector.addElement(configItem);
        }
        return vector;
    }

    public String getItemType() {
        return TEXT_NETWORK_GROUP;
    }

    public Object itemClone() {
        SubnetGroup subnetGroup = (SubnetGroup)super.itemClone();
        subnetGroup.enabled = this.enabled;
        return subnetGroup;
    }

    static Message parse(String string, Subnetwork subnetwork, ConfigItem configItem) {
        String string2;
        int n;
        Message message = null;
        if (!(string = string.trim()).toUpperCase().startsWith(LABEL.toUpperCase())) {
            Object[] objectArray = new Object[]{LABEL};
            return new Message(MessageFormat.format(ERROR_MALFORMED_LABEL, objectArray));
        }
        String string3 = string.substring(LABEL.length());
        int n2 = string3.indexOf(47);
        if (n2 != -1) {
            if (n2 + 1 < string3.length()) {
                try {
                    n = Integer.parseInt(string3.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    return new Message(ERROR_BAD_PRIORITY);
                }
            } else {
                n = Integer.MAX_VALUE;
            }
            string2 = string3.substring(0, n2);
        } else {
            string2 = string3;
            n = Integer.MAX_VALUE;
        }
        message = ((Global)configItem).addSubnetToGroup(string2, subnetwork, n);
        return message;
    }

    public boolean getEnabledState() {
        return this.enabled;
    }

    public void setEnabledState(boolean bl) {
        this.enabled = bl;
        this.updateScheme();
    }
}

