/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class SubnetGroupValidator {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String SUBNET_GROUP_CLASS_NAME = "COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup";
    private static String ERROR_UNLISTED_CLIENT_SUPPORT = DHCPServerGUI.getResourceString("ERROR_UNLISTED_CLIENT_SUPPORT");
    private static String ERROR_LOCATION_SUBNET_GROUP = DHCPServerGUI.getResourceString("ERROR_LOCATION_SUBNET_GROUP");
    private static String ERROR_SUBNET_GROUP_SEPARATOR = DHCPServerGUI.getResourceString("ERROR_SUBNET_GROUP_SEPARATOR");
    private Global global;
    private boolean chooseDumpOrFix;
    private Frame frame;
    private ErrorFrame existingErrorFrame;

    public boolean validateSubnetGroups(Global global, Frame frame) {
        this.chooseDumpOrFix = false;
        this.frame = frame;
        return this.validateSubnetGroups(global);
    }

    public boolean validateSubnetGroups(Global global, ErrorFrame errorFrame) {
        this.chooseDumpOrFix = true;
        this.existingErrorFrame = errorFrame;
        return this.validateSubnetGroups(global);
    }

    private boolean validateSubnetGroups(Global global) {
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        this.global = global;
        Enumeration enumeration = global.getConfigItems(SUBNET_GROUP_CLASS_NAME, true);
        SubnetGroup subnetGroup = null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                subnetGroup = (SubnetGroup)enumeration.nextElement();
                bl2 = this.validateUnlistedClientSupport(subnetGroup);
                if (bl2) continue;
                bl = false;
                stringBuffer.append(subnetGroup.getGroupName());
                stringBuffer.append(String.valueOf(ERROR_SUBNET_GROUP_SEPARATOR) + " ");
            }
        }
        if (!bl) {
            String string = stringBuffer.toString().trim();
            this.showErrorFrame(string.substring(0, string.length() - 1));
        }
        return bl;
    }

    private boolean validateUnlistedClientSupport(SubnetGroup subnetGroup) {
        boolean bl = false;
        Vector vector = null;
        Subnetwork subnetwork = null;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 2;
        int n2 = 2;
        if (subnetGroup != null) {
            vector = subnetGroup.getSubnets();
            bl = true;
            int n3 = 0;
            while (n3 < vector.size() && bl) {
                subnetwork = (Subnetwork)vector.elementAt(n3);
                bl2 = subnetwork.isUnlistedInherited();
                n = subnetwork.getUnlistedClientSupportType();
                if (n3 == 0) {
                    bl3 = bl2;
                    n2 = n;
                } else if (bl2 != bl3) {
                    bl = false;
                } else {
                    bl3 = bl2;
                    if (!bl2) {
                        if (n != n2) {
                            bl = false;
                        } else {
                            n2 = n;
                        }
                    }
                }
                ++n3;
            }
        }
        return bl;
    }

    private void showErrorFrame(String string) {
        Message message = new Message(ERROR_UNLISTED_CLIENT_SUPPORT);
        message.setLocation("\n-- " + ERROR_LOCATION_SUBNET_GROUP + "\n     " + string);
        ErrorFrame errorFrame = null;
        errorFrame = this.chooseDumpOrFix ? this.existingErrorFrame : ErrorFrame.getValidationWarningFrame(this.frame);
        errorFrame.show(message);
    }
}

