/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.AddressRange;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SubnetProfile {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static String ERROR_OVERLAP = DHCPServerGUI.getResourceString("ERROR_OVERLAP");
    private static String ERROR_LOCATION_SUBNET = DHCPServerGUI.getResourceString("ERROR_LOCATION_SUBNET");
    private String address;
    private int intaddress;
    private int mask;
    private Vector ranges = new Vector();
    private Vector subnets = new Vector();

    public SubnetProfile(String string) {
        this.address = string;
        this.intaddress = Address.dottedTo32BitAddress(this.address);
    }

    public void addSubnet(Subnetwork subnetwork, AddressRange addressRange) {
        this.ranges.addElement(addressRange);
        this.subnets.addElement(subnetwork);
        this.mask = Address.dottedTo32BitAddress(subnetwork.getSubnetMask());
    }

    public String getAddress() {
        return this.address;
    }

    public boolean validRanges(boolean bl, Frame frame, ErrorFrame errorFrame) {
        int n = this.ranges.size();
        if (n > 1) {
            int n2 = 0;
            while (n2 < n) {
                AddressRange addressRange = (AddressRange)this.ranges.elementAt(n2);
                int n3 = Address.dottedTo32BitAddress(addressRange.getAddressRangeStart());
                int n4 = Address.dottedTo32BitAddress(addressRange.getAddressRangeEnd());
                int n5 = n3 & ~this.mask;
                int n6 = n4 & ~this.mask;
                int n7 = n2 + 1;
                while (n7 < n) {
                    AddressRange addressRange2 = (AddressRange)this.ranges.elementAt(n7);
                    int n8 = Address.dottedTo32BitAddress(addressRange2.getAddressRangeStart());
                    int n9 = Address.dottedTo32BitAddress(addressRange2.getAddressRangeEnd());
                    int n10 = n8 & ~this.mask;
                    int n11 = n9 & ~this.mask;
                    if (n6 >= n10 && n11 >= n5) {
                        Subnetwork subnetwork = (Subnetwork)this.subnets.elementAt(n2);
                        String string = String.valueOf(subnetwork.getAddress()) + " " + subnetwork.getSubnetMask() + " " + subnetwork.getPoolRange();
                        String string2 = subnetwork.getAlias();
                        if (string2 != null && (string2 = string2.trim()).length() > 0) {
                            string = String.valueOf(string) + " (" + string2 + ")";
                        }
                        Subnetwork subnetwork2 = (Subnetwork)this.subnets.elementAt(n7);
                        String string3 = String.valueOf(subnetwork2.getAddress()) + " " + subnetwork.getSubnetMask() + " " + subnetwork2.getPoolRange();
                        String string4 = subnetwork2.getAlias();
                        if (string4 != null && (string4 = string4.trim()).length() > 0) {
                            string3 = String.valueOf(string3) + " (" + string4 + ")";
                        }
                        Message message = new Message(ERROR_OVERLAP);
                        Object[] objectArray = new Object[]{string};
                        message.setLocation("\n--" + MessageFormat.format(ERROR_LOCATION_SUBNET, objectArray));
                        Object[] objectArray2 = new Object[]{string3};
                        message.setOtherData("--" + MessageFormat.format(ERROR_LOCATION_SUBNET, objectArray2));
                        if (bl) {
                            ErrorFrame errorFrame2 = errorFrame;
                            errorFrame2.show(message);
                        } else {
                            ErrorFrame errorFrame3 = ErrorFrame.getValidationWarningFrame(frame);
                            errorFrame3.show(message);
                        }
                        return false;
                    }
                    ++n7;
                }
                ++n2;
            }
        }
        return true;
    }

    public Enumeration getRanges() {
        return this.ranges.elements();
    }

    public Enumeration getSubnets() {
        return this.subnets.elements();
    }
}

