/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.NameServerList;
import COM.ibm.raleigh.dhcpsgui.biz.NetNode;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetProfile;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SubnetValidator
implements ErrorReporter,
ActionListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static String ERROR_NETWORK_VALUE = DHCPServerGUI.getResourceString("ERROR_NETWORK_VALUE");
    private static String ERROR_LOCATION_SUBNET = DHCPServerGUI.getResourceString("ERROR_LOCATION_SUBNET");
    private static final String TEXT_TITLE_ERROR_FRAME = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME");
    private static final String TEXT_ACCEPT_PREVIOUS = DHCPServerGUI.getResourceString("TEXT_ACCEPT_PREVIOUS");
    private static final String TEXT_KEEP_CURRENT_VALUE = DHCPServerGUI.getResourceString("TEXT_KEEP_CURRENT_VALUE");
    private static final String WARNING_BAD_NAMESERVER = DHCPServerGUI.getResourceString("WARNING_BAD_NAMESERVER");
    private static final String TEXT_TITLE_ERROR_FRAME_BINL = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME_BINL");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private Global global;
    private boolean chooseDumpOrFix;
    private int failedSearches;
    private Frame frame;
    private ErrorFrame existingErrorFrame;
    private NameServerList nsList = new NameServerList();
    private Frame parentFrame;
    private Vector recoveryOptions;
    private Subnetwork currentSN;
    String replaceDNS;
    private ErrorFrame errorBox;

    public static String Copyright() {
        return s;
    }

    public boolean validateSubnets(Global global, Frame frame) {
        this.chooseDumpOrFix = false;
        this.frame = frame;
        return this.validateSubnets(global);
    }

    public boolean validateSubnets(Global global, ErrorFrame errorFrame) {
        this.chooseDumpOrFix = true;
        this.existingErrorFrame = errorFrame;
        return this.validateSubnets(global);
    }

    private boolean validateSubnets(Global global) {
        this.global = global;
        NetNode netNode = this.buildEntireTree();
        if (netNode == null) {
            return true;
        }
        this.failedSearches = 0;
        this.overlapSearch(netNode);
        return this.failedSearches == 0;
    }

    private NetNode buildEntireTree() {
        NetNode netNode = null;
        this.errorBox = this.existingErrorFrame;
        Enumeration enumeration = this.global.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Subnetwork", true);
        while (enumeration.hasMoreElements()) {
            Object object;
            Subnetwork subnetwork = (Subnetwork)enumeration.nextElement();
            int n = this.getNetwork(subnetwork);
            if (n > 223 || n == 0) {
                object = String.valueOf(subnetwork.getAddress()) + " " + subnetwork.getSubnetMask() + " " + subnetwork.getPoolRange();
                if (subnetwork.getAlias().trim().length() > 0) {
                    object = String.valueOf(object) + " (" + subnetwork.getAlias().trim() + ")";
                }
                Message message = new Message(ERROR_NETWORK_VALUE);
                Object[] objectArray = new Object[]{object};
                message.setLocation("\n-- " + MessageFormat.format(ERROR_LOCATION_SUBNET, objectArray));
                this.errorBox = this.chooseDumpOrFix ? this.existingErrorFrame : ErrorFrame.getValidationWarningFrame(this.frame);
                this.errorBox.show(message);
                return null;
            }
            object = this.seekNetwork(n, netNode);
            if (object == null) {
                object = new NetNode(n);
                if (netNode == null) {
                    netNode = object;
                }
                this.addNetwork((NetNode)object, netNode);
            }
            ((NetNode)object).addSubnet(subnetwork);
        }
        return netNode;
    }

    public void validateSubnetsNSList(Global global, Frame frame, int n) {
        this.parentFrame = frame;
        this.errorBox = new ErrorFrame(frame);
        this.recoveryOptions = new Vector();
        this.recoveryOptions.addElement(TEXT_ACCEPT_PREVIOUS);
        this.recoveryOptions.addElement(TEXT_KEEP_CURRENT_VALUE);
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            this.errorBox.initialize(TEXT_TITLE_ERROR_FRAME_BINL, " ", this.recoveryOptions);
        } else {
            this.errorBox.initialize(TEXT_TITLE_ERROR_FRAME, " ", this.recoveryOptions);
        }
        Enumeration enumeration = global.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Subnetwork", true);
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            Subnetwork subnetwork;
            this.currentSN = subnetwork = (Subnetwork)enumeration.nextElement();
            if (this.nsList.check(subnetwork)) {
                this.nsList.add(subnetwork);
                continue;
            }
            objectArray = new String[]{this.nsList.getNSSubnet(subnetwork), this.nsList.getDefaultNS(subnetwork), subnetwork.getDDNSServer(), subnetwork.getPoolRange(), objectArray[1]};
            this.replaceDNS = objectArray[1];
            Message message = new Message(MessageFormat.format(WARNING_BAD_NAMESERVER, objectArray));
            if (n != 3) continue;
            this.errorBox.show(this, message);
        }
    }

    private int getNetwork(Subnetwork subnetwork) {
        String string = subnetwork.getAddress();
        int n = string.indexOf(".");
        return Integer.parseInt(string.substring(0, n));
    }

    private NetNode seekNetwork(int n, NetNode netNode) {
        while (netNode != null) {
            if (this.ToLeftNode(n, netNode)) {
                netNode = this.seekNetwork(n, netNode.getLeftChild());
                continue;
            }
            if (this.ToRightNode(n, netNode)) {
                netNode = this.seekNetwork(n, netNode.getRightChild());
                continue;
            }
            if (netNode.getNetwork() == n) {
                return netNode;
            }
            return null;
        }
        return null;
    }

    private NetNode addNetwork(NetNode netNode, NetNode netNode2) {
        if (netNode2 == null) {
            netNode2 = netNode;
            return netNode2;
        }
        if (this.ToLeftNode(netNode.getNetwork(), netNode2)) {
            netNode2.setLeftChild(this.addNetwork(netNode, netNode2.getLeftChild()));
        } else if (this.ToRightNode(netNode.getNetwork(), netNode2)) {
            netNode2.setRightChild(this.addNetwork(netNode, netNode2.getRightChild()));
        } else {
            netNode = null;
        }
        return netNode2;
    }

    private void overlapSearch(NetNode netNode) {
        if (netNode != null) {
            this.overlapSearch(netNode.getLeftChild());
            this.overlapSearch(netNode.getRightChild());
            if (!this.checkSubnets(netNode)) {
                ++this.failedSearches;
                return;
            }
        }
    }

    private boolean checkSubnets(NetNode netNode) {
        int n = 1;
        while (n < 25) {
            Enumeration enumeration = netNode.getSubnetInfo(n);
            while (enumeration.hasMoreElements()) {
                SubnetProfile subnetProfile = (SubnetProfile)enumeration.nextElement();
                if (subnetProfile.validRanges(this.chooseDumpOrFix, this.frame, this.existingErrorFrame)) continue;
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean ToLeftNode(int n, NetNode netNode) {
        return n < netNode.getNetwork();
    }

    private boolean ToRightNode(int n, NetNode netNode) {
        return n > netNode.getNetwork();
    }

    public void takeErrorAction(String string) {
        ((Component)this.errorBox).setVisible(false);
        if (string.equals(TEXT_ACCEPT_PREVIOUS)) {
            this.currentSN.setDDNSServer(this.replaceDNS);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.errorBox.handleButton((Button)object);
        }
    }
}

