/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Keyword;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.text.MessageFormat;

public class UnlistedClient
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final int DHCP = 0;
    public static final int BOOTP = 1;
    public static final int BOTH = 2;
    public static final int NEITHER = 3;
    private static final String ERROR_KEYWORD_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_KEYWORD_NOT_VALID");
    private static final String TEXT_SERVER_PARAMETERS = DHCPServerGUI.getResourceString("TEXT_SERVER_PARAMETERS");
    private static final String KEYWORD_VALUE_DHCP = "dhcp";
    private static final String KEYWORD_VALUE_BOOTP = "bootp";
    private static final String KEYWORD_VALUE_BOTH = "both";
    private int type = 2;
    private String keyword;
    private boolean inherited = true;

    UnlistedClient() {
        this(2);
    }

    UnlistedClient(int n) {
        this.keyword = new String("supportUnlistedClients");
        this.setUnlistedClientSupportType(n);
        this.setInherited(true);
    }

    UnlistedClient(String string, String string2) {
        this.parseValue(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.keyword);
        stringBuffer.append(" ");
        stringBuffer.append(this.getTypeAsString(this.getUnlistedClientSupportType()));
        return stringBuffer.toString();
    }

    public String getTypeAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                stringBuffer.append(KEYWORD_VALUE_BOOTP);
                break;
            }
            case 0: {
                stringBuffer.append(KEYWORD_VALUE_DHCP);
                break;
            }
            case 3: {
                stringBuffer.append("no");
                break;
            }
            default: {
                stringBuffer.append(KEYWORD_VALUE_BOTH);
            }
        }
        return stringBuffer.toString();
    }

    public int getUnlistedClientSupportType() {
        return this.type;
    }

    public void setUnlistedClientSupportType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.type = n;
                return;
            }
        }
        this.type = 2;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public Message parseValue(String string, String string2) {
        Message message = null;
        this.keyword = string;
        this.setInherited(false);
        string2 = string2.trim();
        if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase(KEYWORD_VALUE_BOTH)) {
            message = this.setType(2);
        } else if (string2.equalsIgnoreCase(KEYWORD_VALUE_BOOTP)) {
            message = this.setType(1);
        } else if (string2.equalsIgnoreCase(KEYWORD_VALUE_DHCP)) {
            message = this.setType(0);
        } else if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("false")) {
            message = this.setType(3);
        } else {
            Object[] objectArray = new Object[]{this.keyword, "{yes, no, dhcp, bootp, both}"};
            message = new Message(MessageFormat.format(Keyword.ERROR_INVALID_VALUE_FOR_KEYWORD, objectArray));
        }
        return message;
    }

    public Message setType(int n) {
        this.setUnlistedClientSupportType(n);
        return null;
    }
}

