/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.dhcpsgui.biz.DDNSKeySupport;
import COM.ibm.raleigh.dhcpsgui.io.DHCPServer;

public class DHCPCommandServer {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String CMDS_tag = "CMDSRVR";
    public static final String ECMDS_tag = "ECMDSRVR";
    public static final String reqtype_tag = "ReqTyp";
    public static final String aString_tag = "sname";
    public static final String aString2_tag = "ssname";
    public static final int MAKE_DIRS = 1;
    public static final int FILE_CREATE = 2;
    public static final int FILE_DELETE = 3;
    public static final int FILE_OPEN = 4;
    public static final int FILE_CLOSE = 5;
    public static final int READ_LINE = 6;
    public static final int WRITE_LINE = 7;
    public static final int GENERATE_AREC_KEYS = 8;
    public static final int GENERATE_PTR_REC_KEYS = 9;
    public static final int RESTART_SERVER = 10;
    private int requestNum;
    String aStringName;
    String anotherStringName;

    public static String handleCommand(ParsedVector parsedVector, ParsedObject parsedObject, String string, DHCPServer dHCPServer) {
        String string2;
        int n = 0;
        boolean bl = false;
        ParsedObject parsedObject2 = parsedVector.getElement(reqtype_tag);
        if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
            Integer n2 = Integer.valueOf(string2);
            n = n2;
        }
        string2 = (parsedObject2 = parsedVector.getElement(aString_tag)) != null && parsedObject2.getValue() != null ? new String((String)parsedObject2.getValue()) : null;
        switch (n) {
            case 1: {
                bl = dHCPServer.makeDirectories(string2);
                break;
            }
            case 2: {
                parsedObject2 = parsedVector.getElement(aString2_tag);
                String string3 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : null;
                bl = dHCPServer.createFile(string2, string3);
                break;
            }
            case 3: {
                bl = dHCPServer.deleteFile(string2);
                break;
            }
            case 4: {
                parsedObject2 = parsedVector.getElement(aString2_tag);
                String string4 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : null;
                bl = dHCPServer.openFile(string2, string4);
                break;
            }
            case 5: {
                bl = dHCPServer.closeFile(string2);
                break;
            }
            case 8: {
                bl = DDNSKeySupport.generateARecKeys(string2);
                break;
            }
            case 9: {
                bl = DDNSKeySupport.generatePtrRecKeys(string2);
                break;
            }
            case 6: {
                Object object = dHCPServer.readALine(string2);
                if (object == null) {
                    string2 = new String("###NULL_STRING");
                    bl = true;
                    break;
                }
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                    break;
                }
                string2 = (String)object;
                bl = true;
                break;
            }
            case 7: {
                String string5;
                parsedObject2 = parsedVector.getElement(aString2_tag);
                if (parsedObject2 != null) {
                    String string6 = (String)parsedObject2.getValue();
                    string5 = new String(string6.substring(0, string6.length()));
                } else {
                    string5 = null;
                }
                bl = dHCPServer.writeALine(string5, string2);
                break;
            }
            case 10: {
                bl = dHCPServer.restartServer();
                break;
            }
        }
        DHCPCommandServer dHCPCommandServer = n != 7 ? new DHCPCommandServer(n, string2) : new DHCPCommandServer(n, "\"" + string2 + "\"");
        StringBuffer stringBuffer = new StringBuffer(dHCPCommandServer.toString());
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public DHCPCommandServer(int n) {
        this.requestNum = n;
        this.aStringName = null;
        this.anotherStringName = null;
    }

    public DHCPCommandServer(int n, String string) {
        this.requestNum = n;
        this.aStringName = string;
        this.anotherStringName = null;
    }

    public DHCPCommandServer(int n, String string, String string2) {
        this.requestNum = n;
        this.aStringName = string;
        this.anotherStringName = string2;
    }

    public DHCPCommandServer(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(CMDS_tag);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",ECMDSRVR,");
        return stringBuffer.toString();
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(",ReqTyp=" + String.valueOf(this.requestNum));
        stringBuffer.append(",sname=" + this.aStringName);
        if (this.requestNum == 2 || this.requestNum == 4 || this.requestNum == 7) {
            stringBuffer.append(",ssname=" + this.anotherStringName);
        }
        return stringBuffer.toString();
    }

    public String fromString(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(aString_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            if (string.equals("###NULL_STRING")) {
                return null;
            }
            return string;
        }
        return "";
    }
}

