/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class DHCPLocalFile
implements DHCPFile {
    public static final String s = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    BufferedReader m_netinput;
    BufferedWriter m_netoutput;
    String fileType;
    String fileName;
    File localFile;
    IOUser user;
    int totalBytesRead;

    public boolean connect() {
        return true;
    }

    public boolean exists(String string) {
        try {
            this.localFile = new File(string);
            return this.localFile.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean create(String string, String string2) {
        try {
            this.localFile = new File(string);
            if (!this.localFile.exists()) {
                return this.mkdirs(string);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean delete(String string) {
        this.localFile = new File(string);
        try {
            return this.localFile.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean open(String string, String string2) {
        try {
            this.fileType = string2;
            if (!string.equals(this.fileName)) {
                this.localFile = new File(string);
                this.fileName = string;
            }
            if (this.fileType.equals("Write")) {
                this.m_netoutput = new BufferedWriter(new FileWriter(this.localFile));
            } else {
                this.m_netinput = new BufferedReader(new FileReader(this.localFile));
                this.totalBytesRead = 0;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean close() {
        try {
            if (this.fileType.equals("Write")) {
                this.m_netoutput.close();
            } else {
                this.m_netinput.close();
            }
            this.localFile = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object readLine() {
        String string = null;
        try {
            if (this.m_netinput == null) {
                return new Boolean(false);
            }
            string = this.m_netinput.readLine();
            if (string == null || string.equals("<EOF>")) {
                return null;
            }
        }
        catch (IOException iOException) {
            System.err.println("DHCPConfigFIleManager readLine() exception: " + iOException);
        }
        if (string != null) {
            this.totalBytesRead += string.length();
        }
        return string;
    }

    public boolean writeLine(String string) {
        try {
            if (string != null && this.m_netoutput != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(String.valueOf(stringTokenizer.nextToken()) + System.getProperty("line.separator"));
                }
                this.m_netoutput.write(stringBuffer.toString());
            }
            return true;
        }
        catch (IOException iOException) {
            System.err.println("DHCPConfigFileManager writeline() exception: " + iOException);
            return false;
        }
    }

    public boolean mkdirs(String string) {
        try {
            File file = new File(string);
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                return file2.mkdirs();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

