/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.NetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;

public class DHCPNetworkStringParser
extends NetworkStringParser {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int NO_OBJECT = -1;
    private static final String validReturnCodeKey = "RC";
    private static final String[] validStartObjectKeys = new String[]{"QUEST", "CMDSRVR"};
    private static final String[] validEndObjectKeys = new String[]{"EQUEST", "ECMDSRVR"};
    private static final String[] validBaseObjectKeys = new String[]{"QUEST", "CMDSRVR"};
    private ParsedVector dhcpVector;
    private ParsedObject dhcpReturnCode;

    public DHCPNetworkStringParser(String string) {
        super(string);
        this.createParsedVector(super.getParsed());
    }

    public ParsedVector getParsed() {
        return this.dhcpVector;
    }

    public ParsedObject getReturnCode() {
        return this.dhcpReturnCode;
    }

    private void createParsedVector(ParsedVector parsedVector) {
        if (!parsedVector.isEmpty()) {
            String[] stringArray = parsedVector.getKeys();
            int n = this.countObjectKeys(stringArray);
            if (n > 0) {
                this.dhcpVector = new ParsedVector();
                this.separateObjects(parsedVector, stringArray, n);
                return;
            }
            this.dhcpVector = null;
            return;
        }
        this.dhcpVector = null;
    }

    private void separateObjects(ParsedVector parsedVector, String[] stringArray, int n) {
        String string;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        ParsedVector[] parsedVectorArray = null;
        String string2 = null;
        if (n > 0) {
            parsedVectorArray = new ParsedVector[n];
            n2 = 0;
            while (n2 < n) {
                parsedVectorArray[n2] = null;
                ++n2;
            }
        }
        this.dhcpReturnCode = null;
        n2 = 0;
        while (n2 < stringArray.length) {
            string = stringArray[n2];
            if (this.isReturnCodeKey(string)) {
                this.dhcpReturnCode = parsedVector.get(n2);
            } else if (this.isStartObjectKey(string)) {
                n4 = ++n3;
                if (this.isBaseObjectKey(string)) {
                    n6 = n5 = n4;
                    parsedVectorArray[n5] = new ParsedVector();
                    parsedVectorArray[n5].append(parsedVector.get(n2));
                } else {
                    parsedVectorArray[n4] = new ParsedVector();
                    parsedVectorArray[n4].append(parsedVector.get(n2));
                    String string3 = null;
                    if (string2 != null) {
                        parsedVectorArray[n6].removeElementAt(parsedVectorArray[n6].lastIndexOf(parsedVectorArray[n6].lastElement()));
                        string3 = new String(string2);
                        string2 = null;
                    } else {
                        string3 = new String(string);
                    }
                    ParsedObject parsedObject = new ParsedObject(string3, (Object)parsedVectorArray[n4]);
                    parsedVectorArray[n6].append(parsedObject);
                    ++n6;
                }
            } else if (this.isEndObjectKey(string)) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                n4 = --n6;
            } else if (n4 != -1) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                string2 = new String(string);
            }
            ++n2;
        }
        this.dhcpVector = parsedVectorArray[n5];
        string = null;
        if (this.dhcpReturnCode != null) {
            string = new String(this.dhcpReturnCode.toString());
        }
    }

    private int countObjectKeys(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.isStartObjectKey(stringArray[n2])) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private boolean isStartObjectKey(String string) {
        boolean bl = false;
        int n = 0;
        while (n < validStartObjectKeys.length && !bl) {
            if (string.equals(validStartObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isEndObjectKey(String string) {
        boolean bl = false;
        int n = 0;
        while (n < validEndObjectKeys.length && !bl) {
            if (string.equals(validEndObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isBaseObjectKey(String string) {
        boolean bl = false;
        int n = 0;
        while (n < validBaseObjectKeys.length && !bl) {
            if (string.equals(validBaseObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isReturnCodeKey(String string) {
        boolean bl = false;
        if (string.equals(validReturnCodeKey)) {
            bl = true;
        }
        return bl;
    }
}

