/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.RemoteFileList;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFile;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FileInfo;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteFileCS;
import java.io.File;
import java.io.FilenameFilter;

class DHCPRemoteFileCS
extends DHCPRemoteFile
implements RemoteFileCS {
    public static final String RFS_tag = "RFS";
    public static final String ERFS_tag = "ERFS";
    public static final String GetDefaultDir_tag = "gDefaultDir";
    public static final String GetLength_tag = "gLength";
    public static final String GetIsDirectory_tag = "gIsDirectory";
    public static final String GetIsAbsolute_tag = "gIsAbsolute";
    public static final String GetIsFile_tag = "gIsFile";
    public static final String GetList_tag = "gList";
    public static final String GetPath_tag = "gPath";
    public static final String GetLastModified_tag = "gLastMod";
    public static final String GetFListInfo_tag = "gFListInfo";
    public static final String PutFullPath_tag = "pFullPath";
    public static final String PutLength_tag = "pLength";
    public static final String PutIsDirectory_tag = "pIsDirectory";
    public static final String PutIsAbsolute_tag = "pIsAbsolute";
    public static final String PutIsFile_tag = "pIsFile";
    public static final String PutList_tag = "pList";
    public static final String PutPath_tag = "pPath";
    public static final String PutLastModified_tag = "pLastMod";
    public static final String PutFListInfo_tag = "pFListInfo";
    public static final String FileList_tag = "FileList";
    public static final String EFileList_tag = "EFileList";
    public static final String FileItem_tag = "FileItem";
    public static final String FListError_tag = "FListError";
    public static final String FileListLen_tag = "FileListLen";
    public static final String FullPath_tag = "FullPath";
    public static final String FilePath_tag = "FilePath";
    public static final String FileName_tab = "FileName";
    public static final String FileAbsolute_tag = "FileAbs";
    public static final String PathSeparator_tag = "FileSep";
    public static final String Length_tag = "Length";
    public static final String LastModified_tag = "LastMod";
    public static final String FileExists_tag = "FileExists";
    public static final String IsDirectory_tag = "IsDirectory";
    public static final String IsAbsolute_tag = "IsAbsolute";
    public static final String IsFile_tag = "IsFile";
    public static String pathSeparator = File.pathSeparator;
    public static String separator = File.separator;
    private boolean FileIsDirectory;
    private boolean FileIsFile;
    private boolean FileIsAbsolute;
    private boolean FileExists;
    private long FileLength = -1L;
    private long FileLastModified = -1L;
    private String FilePath = "";
    private String[] FileList;
    private RemoteFileList theRemoteList;
    private String myFullPath = "";
    private NetworkHandler dataOut;

    public DHCPRemoteFileCS(NetworkHandler networkHandler) {
        super(networkHandler);
        this.dataOut = networkHandler;
        this.getDefaultFilePath();
    }

    public DHCPRemoteFileCS(String string, NetworkHandler networkHandler) {
        super(networkHandler);
        this.dataOut = networkHandler;
        this.myFullPath = new String(string);
        this.CheckForCommas();
    }

    public void setPath(String string) {
        if (string != null) {
            this.myFullPath = new String(string);
            this.CheckForCommas();
            return;
        }
        this.getDefaultFilePath();
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("RFS=" + string);
        if (!string.equals(GetDefaultDir_tag)) {
            stringBuffer.append(",FullPath=" + this.myFullPath);
        }
        stringBuffer.append(",ERFS,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        ParsedVector parsedVector2 = null;
        ParsedObject parsedObject = null;
        String[] stringArray = null;
        Object[] objectArray = null;
        String string = null;
        stringArray = parsedVector.getKeys();
        objectArray = parsedVector.getValues();
        int n = 0;
        while (n < stringArray.length) {
            Long l;
            if (stringArray[n].equals(PathSeparator_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    pathSeparator = string;
                    separator = string;
                }
            } else if (stringArray[n].equals(IsDirectory_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    this.FileIsDirectory = string.equals("t");
                }
            } else if (stringArray[n].equals(IsAbsolute_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    this.FileIsAbsolute = string.equals("t");
                }
            } else if (stringArray[n].equals(IsFile_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    this.FileIsFile = string.equals("t");
                }
            } else if (stringArray[n].equals(Length_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    try {
                        l = Long.valueOf(string);
                        this.FileLength = l;
                    }
                    catch (Exception exception) {}
                }
            } else if (stringArray[n].equals(LastModified_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    try {
                        l = Long.valueOf(string);
                        this.FileLastModified = l;
                    }
                    catch (Exception exception) {}
                }
            } else if (stringArray[n].equals(FilePath_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    this.FilePath = string;
                }
            } else if (stringArray[n].equals(FullPath_tag)) {
                string = (String)objectArray[n];
                if (string != null) {
                    this.myFullPath = string;
                }
            } else if (stringArray[n].equals(FileList_tag)) {
                parsedObject = parsedVector.getElement(FileListLen_tag);
                if (parsedObject != null) {
                    string = (String)parsedObject.getValue();
                    if (string != null) {
                        Integer n2 = Integer.valueOf(string);
                        this.parseFileList(stringArray, objectArray, n2);
                    }
                } else {
                    this.FileList = null;
                }
            } else if (stringArray[n].equals("RFileList")) {
                parsedVector2 = (ParsedVector)objectArray[n];
                this.theRemoteList = parsedVector2 != null ? new RemoteFileList(parsedVector2, this.myFullPath) : null;
            }
            ++n;
        }
    }

    public String getName() {
        return null;
    }

    public String getPath() {
        if (this.myFullPath != "") {
            return this.myFullPath;
        }
        return "";
    }

    public String getAbsolutePath() {
        return String.valueOf(this.getPath()) + separator + this.getName();
    }

    public String getCanonicalPath() {
        return null;
    }

    public String getParent() {
        return null;
    }

    public boolean isDirectory() {
        this.sendtoNetwork(GetIsDirectory_tag);
        return this.FileIsDirectory;
    }

    public boolean isFile() {
        this.sendtoNetwork(GetIsFile_tag);
        return this.FileIsFile;
    }

    public boolean isAbsolute() {
        this.sendtoNetwork(GetIsAbsolute_tag);
        return this.FileIsAbsolute;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public String[] list() {
        this.sendtoNetwork(GetList_tag);
        if (this.FileList != null) {
            return this.FileList;
        }
        return null;
    }

    public String[] list(FilenameFilter filenameFilter) {
        return null;
    }

    public FileInfo[] getFileInfoItems() {
        this.sendtoNetwork(GetFListInfo_tag);
        if (this.theRemoteList != null) {
            return this.theRemoteList.getFileInfo();
        }
        return null;
    }

    private void sendtoNetwork(String string) {
        DDNSNetworkStringParser dDNSNetworkStringParser = null;
        this.dataOut.sendToServer(this.toString(string));
        dDNSNetworkStringParser = new DDNSNetworkStringParser(this.dataOut.receiveFromServer(true), null);
        if (dDNSNetworkStringParser != null) {
            this.fromString(dDNSNetworkStringParser.getParsed());
            return;
        }
        System.out.println("KEA null network string");
    }

    private void getDefaultFilePath() {
        this.sendtoNetwork(GetDefaultDir_tag);
    }

    private void parseFileList(String[] stringArray, Object[] objectArray, int n) {
        int n2 = 0;
        this.FileList = new String[n];
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string;
            if (stringArray[n3].equals(FileItem_tag) && (string = (String)objectArray[n3]) != null) {
                this.FileList[n2] = string;
                ++n2;
            }
            ++n3;
        }
        if (n2 != n) {
            System.out.println("FileList is not Complete");
        }
    }

    private void CheckForCommas() {
        if (this.myFullPath.indexOf(",") != -1) {
            this.myFullPath.replace(',', 'x');
        }
    }
}

