/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.RemoteFileList;
import java.io.File;

public class DHCPRemoteFileSS {
    public static final String RFS_tag = "RFS";
    public static final String ERFS_tag = "ERFS";
    public static final String GetDefaultDir_tag = "gDefaultDir";
    public static final String GetLength_tag = "gLength";
    public static final String GetIsDirectory_tag = "gIsDirectory";
    public static final String GetIsAbsolute_tag = "gIsAbsolute";
    public static final String GetIsFile_tag = "gIsFile";
    public static final String GetList_tag = "gList";
    public static final String GetPath_tag = "gPath";
    public static final String GetLastModified_tag = "gLastMod";
    public static final String GetFListInfo_tag = "gFListInfo";
    public static final String PutFullPath_tag = "pFullPath";
    public static final String PutLength_tag = "pLength";
    public static final String PutIsDirectory_tag = "pIsDirectory";
    public static final String PutIsAbsolute_tag = "pIsAbsolute";
    public static final String PutIsFile_tag = "pIsFile";
    public static final String PutList_tag = "pList";
    public static final String PutPath_tag = "pPath";
    public static final String PutLastModified_tag = "pLastMod";
    public static final String PutFListInfo_tag = "pFListInfo";
    public static final String FileList_tag = "FileList";
    public static final String EFileList_tag = "EFileList";
    public static final String FileItem_tag = "FileItem";
    public static final String FListError_tag = "FListError";
    public static final String FileListLen_tag = "FileListLen";
    public static final String FullPath_tag = "FullPath";
    public static final String FilePath_tag = "FilePath";
    public static final String FileName_tab = "FileName";
    public static final String FileAbsolute_tag = "FileAbs";
    public static final String PathSeparator_tag = "FileSep";
    public static final String Length_tag = "Length";
    public static final String LastModified_tag = "LastMod";
    public static final String FileExists_tag = "FileExists";
    public static final String IsDirectory_tag = "IsDirectory";
    public static final String IsAbsolute_tag = "IsAbsolute";
    public static final String IsFile_tag = "IsFile";
    private File myfile;
    private String myPath = "";
    private boolean isDirectory = false;
    private boolean isFile = false;
    private boolean isAbsolute = false;
    private boolean doesExist = false;
    private String separator = File.separator;

    public static String handleActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        if (parsedObject.getValue().equals(GetDefaultDir_tag)) {
            DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS(DHCPRemoteFileSS.getStartDir(string2));
            stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutFullPath_tag));
            bl = true;
        } else if (parsedObject.getValue().equals(GetLength_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutLength_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetIsDirectory_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutIsDirectory_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetIsAbsolute_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutIsAbsolute_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetIsFile_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutIsFile_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetList_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutList_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetPath_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutPath_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetLastModified_tag)) {
            parsedObject = parsedVector.getElement(FullPath_tag);
            if (parsedObject != null) {
                DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
                stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutLastModified_tag));
                bl = true;
            }
        } else if (parsedObject.getValue().equals(GetFListInfo_tag) && (parsedObject = parsedVector.getElement(FullPath_tag)) != null) {
            DHCPRemoteFileSS dHCPRemoteFileSS = new DHCPRemoteFileSS((String)parsedObject.getValue());
            stringBuffer = new StringBuffer(dHCPRemoteFileSS.toString(PutFListInfo_tag));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public DHCPRemoteFileSS(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public DHCPRemoteFileSS(String string) {
        this.fromString(string);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("RFS=" + string);
        if (string.equals(PutFullPath_tag)) {
            stringBuffer.append(",FullPath=" + this.myPath);
        } else if (string.equals(PutLength_tag)) {
            stringBuffer.append(",Length=" + this.getLength());
        } else if (string.equals(PutIsDirectory_tag)) {
            if (this.isDirectory) {
                stringBuffer.append(",IsDirectory=t");
            } else {
                stringBuffer.append(",IsDirectory=f");
            }
        } else if (string.equals(PutIsAbsolute_tag)) {
            if (this.isAbsolute) {
                stringBuffer.append(",IsAbsolute=t");
            } else {
                stringBuffer.append(",IsAbsolute=f");
            }
        } else if (string.equals(PutIsFile_tag)) {
            if (this.isFile) {
                stringBuffer.append(",IsFile=t");
            } else {
                stringBuffer.append(",IsFile=f");
            }
        } else if (string.equals(PutList_tag)) {
            stringBuffer.append("," + this.getFileList());
        } else if (string.equals(PutPath_tag)) {
            stringBuffer.append(",FilePath=" + this.getPath());
        } else if (string.equals(PutLastModified_tag)) {
            stringBuffer.append(",LastMod=" + this.getLastModified());
        } else if (string.equals(PutFListInfo_tag)) {
            RemoteFileList remoteFileList = new RemoteFileList(this.myfile);
            stringBuffer.append("," + remoteFileList.toString());
        }
        stringBuffer.append(",FileSep=" + this.separator);
        stringBuffer.append(",ERFS,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        ParsedObject parsedObject = null;
        parsedObject = parsedVector.getElement(FullPath_tag);
        if (parsedObject != null) {
            this.fromString((String)parsedObject.getValue());
        }
    }

    public void fromString(String string) {
        this.myfile = new File(string);
        try {
            this.doesExist = this.myfile.exists();
            this.isDirectory = this.myfile.isDirectory();
            this.isFile = this.myfile.isFile();
            this.isAbsolute = this.myfile.isAbsolute();
            this.myPath = string;
            if (!this.doesExist) {
                this.myfile = null;
                this.myPath = "";
                return;
            }
        }
        catch (Exception exception) {
            this.myfile = null;
            this.myPath = "";
            this.doesExist = false;
            this.isDirectory = false;
            this.isFile = false;
            this.isAbsolute = false;
            System.out.println("A file error has occurred in DHCPRemoteFileSS " + exception.getMessage());
        }
    }

    private long getLength() {
        if (this.myfile != null && this.doesExist) {
            try {
                long l = this.myfile.length();
                return l;
            }
            catch (Exception exception) {
                System.out.println("A file error has occurred: " + exception.getMessage());
                return -1L;
            }
        }
        return -1L;
    }

    private String getFileList() {
        StringBuffer stringBuffer = new StringBuffer("FileList=");
        if (this.doesExist && this.isDirectory) {
            try {
                String[] stringArray = this.myfile.list();
                if (stringArray != null) {
                    int n = stringArray.length;
                    stringBuffer.append(",FileListLen=" + n);
                    if (n > 0) {
                        int n2 = 0;
                        while (n2 < n) {
                            stringBuffer.append(",FileItem=" + stringArray[n2]);
                            ++n2;
                        }
                    }
                } else {
                    stringBuffer.append(",FListError");
                }
            }
            catch (Exception exception) {
                stringBuffer.append(",FListError");
            }
        } else {
            stringBuffer.append(",FListError");
        }
        stringBuffer.append(",EFileList=");
        return stringBuffer.toString();
    }

    private String getPath() {
        if (this.myfile != null) {
            try {
                String string = this.myfile.getPath();
                if (string != null) {
                    return string;
                }
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    private long getLastModified() {
        if (this.doesExist) {
            try {
                long l = this.myfile.lastModified();
                return l;
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        return -1L;
    }

    private static String getStartDir(String string) {
        return string;
    }
}

