/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.dhcpsgui.io.DHCPCommandServer;
import COM.ibm.raleigh.dhcpsgui.io.DHCPLocalFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPNetworkStringParser;
import COM.ibm.raleigh.dhcpsgui.io.DHCPQuestion;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFileSS;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class DHCPServer {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    String lastAction;
    DHCPLocalFile theFileItself;
    Hashtable allTheFiles;
    private static String theETCdir;

    public DHCPServer(String string) {
        theETCdir = string;
        this.initSelf();
    }

    public static String getETCdir() {
        return theETCdir;
    }

    public void initSelf() {
        this.allTheFiles = new Hashtable();
    }

    public String recFromNetwork(String string) {
        ParsedObject parsedObject;
        DHCPNetworkStringParser dHCPNetworkStringParser = new DHCPNetworkStringParser(string);
        ParsedVector parsedVector = dHCPNetworkStringParser.getParsed();
        if (parsedVector == null) {
            parsedObject = new DDNSNetworkStringParser(string, null);
            parsedVector = parsedObject.getParsed();
        }
        if ((parsedObject = parsedVector.getFirstElement()).getKey().equals("QUEST")) {
            this.lastAction = DHCPQuestion.getResponse(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("CMDSRVR")) {
            this.lastAction = DHCPCommandServer.handleCommand(parsedVector, parsedObject, string, this);
        } else if (parsedObject.getKey().equals("RFS")) {
            this.lastAction = DHCPRemoteFileSS.handleActions(parsedVector, parsedObject, string, theETCdir);
        }
        return this.lastAction;
    }

    public boolean doesFileExist(String string) {
        this.theFileItself = new DHCPLocalFile();
        return this.theFileItself.exists(string);
    }

    public boolean makeDirectories(String string) {
        this.theFileItself = new DHCPLocalFile();
        return this.theFileItself.mkdirs(string);
    }

    public boolean createFile(String string, String string2) {
        this.theFileItself = new DHCPLocalFile();
        return this.theFileItself.create(string, string2);
    }

    public boolean deleteFile(String string) {
        this.theFileItself = new DHCPLocalFile();
        return this.theFileItself.delete(string);
    }

    public boolean openFile(String string, String string2) {
        this.theFileItself = new DHCPLocalFile();
        boolean bl = this.theFileItself.open(string, string2);
        if (bl) {
            this.allTheFiles.put(string, this.theFileItself);
        }
        return bl;
    }

    public boolean closeFile(String string) {
        DHCPLocalFile dHCPLocalFile = (DHCPLocalFile)this.allTheFiles.get(string);
        if (dHCPLocalFile != null) {
            this.allTheFiles.remove(string);
            return dHCPLocalFile.close();
        }
        return false;
    }

    public Object readALine(String string) {
        DHCPLocalFile dHCPLocalFile = (DHCPLocalFile)this.allTheFiles.get(string);
        if (dHCPLocalFile != null) {
            return dHCPLocalFile.readLine();
        }
        return new Boolean(false);
    }

    public boolean writeALine(String string, String string2) {
        DHCPLocalFile dHCPLocalFile = (DHCPLocalFile)this.allTheFiles.get(string);
        if (dHCPLocalFile != null) {
            return dHCPLocalFile.writeLine(string2);
        }
        return false;
    }

    public boolean connect() {
        return this.theFileItself.connect();
    }

    public boolean restartServer() {
        File file = new File(String.valueOf(DHCPServer.getETCdir()) + File.separatorChar + ".." + File.separatorChar + "bin" + File.separatorChar + "dadmin.exe");
        int n = -1;
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{new String(String.valueOf(file.getAbsolutePath()) + " "), new String("-i ")};
        try {
            Process process = runtime.exec(stringArray);
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        return true;
    }
}

