/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.awtExt.MultiLineLabel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.HelpFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class ErrorFrame
extends Dialog
implements WindowListener,
ActionListener,
KeyListener {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_TITLE_ERROR_FRAME = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME");
    private static final String TEXT_TITLE_ERROR_FRAME_BINL = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME_BINL");
    private static final String TEXT_FILE_WARNING_BOILERPLATE = DHCPServerGUI.getResourceString("TEXT_FILE_WARNING_BOILERPLATE");
    private static final String TEXT_NOTEBOOK_ERROR_BOILERPLATE = DHCPServerGUI.getResourceString("TEXT_NOTEBOOK_ERROR_BOILERPLATE");
    private static final String TEXT_EXIT_VALIDATION_BOILERPLATE = DHCPServerGUI.getResourceString("TEXT_EXIT_VALIDATION_BOILERPLATE");
    private static final String TEXT_TITLE_DESCRIPTION_BOX = DHCPServerGUI.getResourceString("TEXT_TITLE_DESCRIPTION_BOX");
    private static final String TEXT_TITLE_RECOVERY_BOX = DHCPServerGUI.getResourceString("TEXT_TITLE_RECOVERY_BOX");
    private static final String TEXT_DESCRIPTION = DHCPServerGUI.getResourceString("TEXT_DESCRIPTION");
    private static final String TEXT_CONTEXT_FIELD = DHCPServerGUI.getResourceString("TEXT_CONTEXT_FIELD");
    private static final String TEXT_CONTEXT_LINE = DHCPServerGUI.getResourceString("TEXT_CONTEXT_LINE");
    private static final String TEXT_CONTEXT_WARNING = DHCPServerGUI.getResourceString("TEXT_CONTEXT_WARNING");
    private static final String TEXT_LABEL_WARNING_DESCRIPTION = DHCPServerGUI.getResourceString("TEXT_LABEL_WARNING_DESCRIPTION");
    private static final String TEXT_DEFAULT_CONTEXT = DHCPServerGUI.getResourceString("TEXT_DEFAULT_CONTEXT");
    private static final String TEXT_BUTTON_OK = DHCPServerGUI.getResourceString("TEXT_BUTTON_OK");
    private static final String TEXT_BUTTON_HELP = DHCPServerGUI.getResourceString("TEXT_BUTTON_HELP");
    private static final String TEXT_LABEL_SELECT_WAY = DHCPServerGUI.getResourceString("TEXT_LABEL_SELECT_WAY");
    private static final String TEXT_ACCEPT_PREVIOUS = DHCPServerGUI.getResourceString("TEXT_ACCEPT_PREVIOUS");
    private static final String TEXT_KEEP_CURRENT_VALUE = DHCPServerGUI.getResourceString("TEXT_KEEP_CURRENT_VALUE");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TAG_OK_HIT = "OK hit";
    private static Font textFont = new Font("sansserif", 0, DDNSUtility.getCountryFontSize());
    private static Font titleFont = new Font("sansserif", 1, DDNSUtility.getCountryFontSize());
    ErrorReporter parent;
    String boilerPlate;
    MultiLineLabel errorBoilerPlate;
    MultiLineLabel otherDataLabel;
    MultiLineLabel contextLabel;
    MultiLineLabel errorLabel;
    Button buttonOK;
    Button buttonHelp;
    Button buttonCancel;
    CheckboxGroup recoveryOptions;
    Vector recoveryOptionVector = new Vector();
    String chosenRecoveryOption;
    private String contextHeader;
    private String informationType;
    private HelpFrame helpFrame = HelpFrame.getHelpFrame();

    public ErrorFrame(Frame frame) {
        super(frame, true);
        this.contextHeader = TEXT_DEFAULT_CONTEXT;
        this.informationType = TEXT_DESCRIPTION;
        this.addWindowListener(this);
    }

    public ErrorFrame(Frame frame, boolean bl) {
        super(frame, false);
        this.contextHeader = TEXT_DEFAULT_CONTEXT;
        this.informationType = TEXT_DESCRIPTION;
        this.addWindowListener(this);
    }

    public static ErrorFrame getNotebookErrorFrame(Frame frame) {
        ErrorFrame errorFrame = new ErrorFrame(frame);
        errorFrame.contextHeader = TEXT_CONTEXT_FIELD;
        return errorFrame;
    }

    public static ErrorFrame getFileWarningFrame(Frame frame) {
        ErrorFrame errorFrame = new ErrorFrame(frame);
        errorFrame.contextHeader = TEXT_CONTEXT_WARNING;
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME_BINL, TEXT_FILE_WARNING_BOILERPLATE, new Vector());
        } else {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME, TEXT_FILE_WARNING_BOILERPLATE, new Vector());
        }
        errorFrame.informationType = TEXT_LABEL_WARNING_DESCRIPTION;
        return errorFrame;
    }

    public static ErrorFrame getValidationErrorFrame(Frame frame) {
        return new ErrorFrame(frame);
    }

    public static ErrorFrame getValidationWarningFrame(Frame frame) {
        ErrorFrame errorFrame = new ErrorFrame(frame);
        errorFrame.contextHeader = TEXT_CONTEXT_WARNING;
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME_BINL, TEXT_FILE_WARNING_BOILERPLATE, new Vector());
        } else {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME, TEXT_FILE_WARNING_BOILERPLATE, new Vector());
        }
        errorFrame.informationType = TEXT_LABEL_WARNING_DESCRIPTION;
        return errorFrame;
    }

    public static ErrorFrame getNotebookWarningFrame(Frame frame) {
        ErrorFrame errorFrame = new ErrorFrame(frame);
        errorFrame.contextHeader = TEXT_CONTEXT_WARNING;
        return errorFrame;
    }

    public void initialize(String string, String string2, Vector vector) {
        this.setTitle(string);
        this.boilerPlate = string2;
        this.recoveryOptions = new CheckboxGroup();
        Enumeration enumeration = vector.elements();
        boolean bl = true;
        this.recoveryOptionVector.removeAllElements();
        while (enumeration.hasMoreElements()) {
            Checkbox checkbox = new Checkbox((String)enumeration.nextElement(), this.recoveryOptions, bl);
            checkbox.addKeyListener(this);
            this.recoveryOptionVector.addElement(checkbox);
            bl = false;
        }
    }

    public void initialize(String string, String string2, Vector vector, ErrorReporter errorReporter) {
        this.initialize(string, string2, vector);
        this.parent = errorReporter;
    }

    public void setType(String string) {
        this.informationType = string;
    }

    public void show(ErrorReporter errorReporter, Message message) {
        String string = message.getLocation();
        String string2 = message.getOtherData();
        this.parent = errorReporter;
        if (string != null) {
            string = String.valueOf(this.contextHeader) + string;
        }
        this.layoutFrame(string, string2, String.valueOf(this.informationType) + message.getText());
        ((Component)this).setSize(450, 400);
        super.setVisible(true);
    }

    public void show(Message message) {
        this.show(this.parent, message);
    }

    private void layoutFrame(String string, String string2, String string3) {
        Panel panel;
        this.removeAll();
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.errorBoilerPlate = new MultiLineLabel(this.boilerPlate);
        int n = this.recoveryOptionVector.size() > 0 ? 2 : 1;
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(n, 1));
        BorderPanel borderPanel = new BorderPanel(TEXT_TITLE_DESCRIPTION_BOX);
        int n2 = 3;
        if (string == null) {
            --n2;
        }
        if (string2 == null) {
            --n2;
        }
        if (string3 == null) {
            --n2;
        }
        if (n2 > 0) {
            borderPanel.setLayout(new GridLayout(n2, 1));
            ((Component)borderPanel).setFont(textFont);
            borderPanel.setTextFont(titleFont);
            if (string != null && !string.trim().equals("")) {
                this.contextLabel = new MultiLineLabel(string);
                borderPanel.add(this.contextLabel);
            }
            if (string2 != null && !string2.trim().equals("")) {
                this.otherDataLabel = new MultiLineLabel(string2);
                borderPanel.add(this.otherDataLabel);
            }
            if (string3 != null && !string3.trim().equals("")) {
                this.errorLabel = new MultiLineLabel(string3);
                borderPanel.add(this.errorLabel);
            }
            panel2.add(borderPanel);
        }
        if (n == 2) {
            panel = new BorderPanel(TEXT_TITLE_RECOVERY_BOX);
            ((BorderPanel)panel).setTextFont(titleFont);
            ((Component)panel).setFont(textFont);
            int n3 = this.recoveryOptionVector.size();
            Panel panel3 = new Panel();
            panel3.setLayout(new GridLayout(n3, 1));
            Enumeration enumeration = this.recoveryOptionVector.elements();
            while (enumeration.hasMoreElements()) {
                panel3.add((Checkbox)enumeration.nextElement());
            }
            panel.add(panel3);
            panel2.add(panel);
        }
        panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.buttonOK = new Button(TEXT_BUTTON_OK);
        this.buttonOK.addActionListener(this);
        this.buttonOK.addKeyListener(this);
        this.buttonOK.setBackground(Color.lightGray);
        this.buttonHelp = new Button(TEXT_BUTTON_HELP);
        this.buttonHelp.addActionListener(this);
        this.buttonHelp.addKeyListener(this);
        this.buttonHelp.setBackground(Color.lightGray);
        panel.add(this.buttonOK);
        panel.add(this.buttonHelp);
        this.add("North", this.errorBoilerPlate);
        this.add("Center", panel2);
        this.add("South", panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.parent != null) {
            this.chosenRecoveryOption = this.recoveryOptions.getSelectedCheckbox().getLabel();
            this.parent.takeErrorAction(this.chosenRecoveryOption);
            return;
        }
        ((Component)this).setVisible(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void handleButton(Button button) {
        if (button == this.buttonOK) {
            if (this.parent != null) {
                this.chosenRecoveryOption = this.recoveryOptions.getSelectedCheckbox().getLabel();
                this.parent.takeErrorAction(this.chosenRecoveryOption);
                return;
            }
            this.windowClosing(new WindowEvent(this, 201));
            return;
        }
        if (button == this.buttonHelp) {
            if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                this.helpFrame.showHelp("DHBCWER.HTM#HDRWER");
                return;
            }
            this.helpFrame.showHelp("DHSCWNE.HTM#HDRPAGERR");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

