/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFileCS;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.io.FileDialogResults;
import COM.ibm.raleigh.dhcpsgui.view.BINLServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.HelpFrame;
import COM.ibm.raleigh.dhcpsgui.view.InfoFrame;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteFileCS;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.RemoteSessionMgr;
import com.ibm.eNetwork.onDemand.common.remoteFile.mgr.usesRemoteFileMgr;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.Vector;

class FileOpenDialog
extends Dialog
implements WindowListener,
KeyListener,
ActionListener,
usesRemoteFileMgr,
ErrorReporter {
    public static final String s = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String NAME_REQUIRED = DHCPServerGUI.getResourceString("ERROR_NAME_REQUIRED");
    private static final String BUTTON_OK = DHCPServerGUI.getResourceString("TEXT_BUTTON_OK");
    private static final String BUTTON_CANCEL = DHCPServerGUI.getResourceString("TEXT_BUTTON_CANCEL");
    private static final String BUTTON_HELP = DHCPServerGUI.getResourceString("TEXT_BUTTON_HELP");
    private static final String FILE_NAME_EXPLANATION_LABEL = DHCPServerGUI.getResourceString("TEXT_FILE_NAME_EXPLANATION_LABEL");
    private static final String FILE_NAME_EXPLANATION_LABEL_BINL = DHCPServerGUI.getResourceString("TEXT_FILE_NAME_EXPLANATION_LABEL_BINL");
    private static final String FILE_NAME_MISSING = DHCPServerGUI.getResourceString("ERROR_FILE_NAME_MISSING");
    private static final String FILE_NAME_MISSING_BINL = DHCPServerGUI.getResourceString("ERROR_FILE_NAME_MISSING_BINL");
    private static final String FILE_SAVE_NAME_EXPLANATION_LABEL = DHCPServerGUI.getResourceString("TEXT_FILE_SAVE_NAME_EXPLANATION_LABEL");
    private static final String FILE_SAVE_NAME_EXPLANATION_LABEL_BINL = DHCPServerGUI.getResourceString("TEXT_FILE_SAVE_NAME_EXPLANATION_LABEL_BINL");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TEXT_INFO_TITLE = DHCPServerGUI.getResourceString("TEXT_INFO_TITLE");
    private static final String TEXT_INFO_TITLE_BINL = DHCPServerGUI.getResourceString("TEXT_INFO_TITLE_BINL");
    public static final int SAVE = 0;
    private static final int FIRST_FIELD = 0;
    private static final int FILE_NAME_FIELD = 0;
    private static final int NUM_TEXT_FIELD_COLUMNS = 40;
    private static String fileName = null;
    private Frame parent;
    private TextField theFileName;
    private Panel fileNamePanel;
    private Label instructionLabel = new Label("");
    private Panel buttonPanel;
    private Button buttonOK;
    private Button buttonHelp;
    private Button buttonCancel;
    private static Font textFont = new Font("sansserif", 0, DDNSUtility.getCountryFontSize());
    private static Font titleFont = new Font("sansserif", 1, DDNSUtility.getCountryFontSize());
    private WrappedTextPanel fileExplanation;
    private ErrorFrame fileExistFrame;
    private Button cmdBrowse;
    private RemoteSessionMgr filemgr;
    private boolean weAreSaving;
    private DHCPFile aFileToUse;
    private InfoFrame doesntExist;
    private InfoFrame invalidFile;
    private FileDialogResults theCaller;

    public FileOpenDialog(Frame frame, String string, DHCPFile dHCPFile, FileDialogResults fileDialogResults) {
        super(frame, false);
        this.setResizable(false);
        this.setTitle(string);
        this.parent = frame;
        ((Component)this).setFont(textFont);
        this.theCaller = fileDialogResults;
        ((Component)this).setBackground(Color.white);
        this.initComponents();
        this.aFileToUse = dHCPFile;
        this.addComponentsToGrid();
        this.weAreSaving = false;
    }

    public FileOpenDialog(Frame frame, String string, int n, FileDialogResults fileDialogResults) {
        super(frame, false);
        this.setResizable(false);
        this.setTitle(string);
        this.parent = frame;
        ((Component)this).setFont(textFont);
        this.theCaller = fileDialogResults;
        ((Component)this).setBackground(Color.white);
        this.initComponentsForSave();
        this.addComponentsToGrid();
        this.weAreSaving = true;
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.theFileName.requestFocus();
                return;
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setSize(Integer.parseInt(DHCPServerGUI.getResourceString("FOD_FRAME_WIDTH")), Integer.parseInt(DHCPServerGUI.getResourceString("FOD_FRAME_HEIGHT")));
            ((Component)this).setLocation(1, 20);
        }
        super.setVisible(bl);
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.theFileName.selectAll();
                return;
            }
        }
    }

    public static String getFileName() {
        return fileName;
    }

    public void setFileName(String string) {
        fileName = string;
        if (string != null) {
            ((TextComponent)this.theFileName).setText(string);
        }
    }

    private void initComponents() {
        this.fileNamePanel = new Panel();
        this.fileExplanation = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new WrappedTextPanel(FILE_NAME_EXPLANATION_LABEL_BINL) : new WrappedTextPanel(FILE_NAME_EXPLANATION_LABEL);
        this.theFileName = new TextField("", 40);
        this.cmdBrowse = new Button(DHCPServerGUI.getResourceString("TEXT_BROWSE"));
        this.cmdBrowse.addActionListener(this);
        this.cmdBrowse.addKeyListener(this);
        this.initButtonPanel();
        this.addWindowListener(this);
    }

    private void initComponentsForSave() {
        this.fileNamePanel = new Panel();
        this.fileExplanation = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new WrappedTextPanel(FILE_SAVE_NAME_EXPLANATION_LABEL_BINL) : new WrappedTextPanel(FILE_SAVE_NAME_EXPLANATION_LABEL);
        this.theFileName = new TextField("", 40);
        this.cmdBrowse = new Button(DHCPServerGUI.getResourceString("TEXT_BROWSE"));
        this.cmdBrowse.addActionListener(this);
        this.cmdBrowse.addKeyListener(this);
        this.initButtonPanel();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.fileNamePanel.setLayout(gridBagLayout2);
        this.constrain((Component)this.fileExplanation, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 1);
        this.fileNamePanel.add((Component)this.fileExplanation);
        this.constrain(this.theFileName, gridBagLayout2, gridBagConstraints2, 0, 1, 1, 1);
        this.fileNamePanel.add(this.theFileName);
        this.constrain(this.cmdBrowse, gridBagLayout2, gridBagConstraints2, 1, 1, 0, 0);
        this.fileNamePanel.add(this.cmdBrowse);
        this.add(this.fileNamePanel, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initButtonPanel() {
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonOK = new Button(BUTTON_OK);
        this.buttonOK.addActionListener(this);
        this.buttonOK.addKeyListener(this);
        this.buttonPanel.add(this.buttonOK);
        this.buttonCancel = new Button(BUTTON_CANCEL);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.addKeyListener(this);
        this.buttonPanel.add(this.buttonCancel);
        this.buttonHelp = new Button(BUTTON_HELP);
        this.buttonHelp.addActionListener(this);
        this.buttonHelp.addKeyListener(this);
        this.buttonPanel.add(this.buttonHelp);
    }

    private boolean checkRequiredFields() {
        String string = new String(this.theFileName.getText().trim());
        if (string == null || string.length() <= 0) {
            if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                this.instructionLabel.setText(FILE_NAME_MISSING_BINL);
            } else {
                this.instructionLabel.setText(FILE_NAME_MISSING);
            }
            return false;
        }
        fileName = string;
        if (this.weAreSaving) {
            if (!this.checkForValidName(fileName)) {
                return false;
            }
            DHCPRemoteFile dHCPRemoteFile = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new DHCPRemoteFile(BINLServerGUI.getConnectionToServer()) : new DHCPRemoteFile(DHCPServerGUI.getConnectionToServer());
            if (dHCPRemoteFile.connect() && dHCPRemoteFile.exists(fileName)) {
                Object[] objectArray = new Object[]{fileName};
                Message message = new Message(MessageFormat.format(DHCPServerGUI.getResourceString("WARN_FILE_EXISTS"), objectArray));
                Vector<String> vector = new Vector<String>();
                vector.addElement(DHCPServerGUI.getResourceString("TEXT_CONTINUE_FILE_SAVE"));
                vector.addElement(DHCPServerGUI.getResourceString("TEXT_CHANGE_NAME_FILE_SAVE"));
                this.fileExistFrame = new ErrorFrame(this.parent, false);
                this.fileExistFrame.initialize(this.getTitle(), "", vector, this);
                this.fileExistFrame.show(message);
                return false;
            }
        }
        return true;
    }

    private boolean checkForFileExist(String string) {
        this.aFileToUse.connect();
        if (!this.aFileToUse.exists(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? TEXT_INFO_TITLE_BINL : TEXT_INFO_TITLE;
            this.doesntExist = new InfoFrame(true, this, string2);
            this.doesntExist.setText(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_MESSAGE_FILE_NOT_THERE"), objectArray));
            this.doesntExist.setVisible(true);
            this.doesntExist = null;
            return false;
        }
        return true;
    }

    private boolean checkForValidName(String string) {
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            if (string.toUpperCase().indexOf("DHCPSD.CFG") != -1) {
                String string2 = TEXT_INFO_TITLE_BINL;
                this.invalidFile = new InfoFrame(true, this, string2);
                this.invalidFile.setText(DHCPServerGUI.getResourceString("TEXT_INVALID_BINL_CFGFILE"));
                this.invalidFile.setVisible(true);
                this.invalidFile = null;
                return false;
            }
            return true;
        }
        if (string.toUpperCase().indexOf("BINLSD.CFG") != -1) {
            String string3 = TEXT_INFO_TITLE;
            this.invalidFile = new InfoFrame(true, this, string3);
            this.invalidFile.setText(DHCPServerGUI.getResourceString("TEXT_INVALID_DHCP_CFGFILE"));
            this.invalidFile.setVisible(true);
            this.invalidFile = null;
            return false;
        }
        return true;
    }

    private void handleButton(Button button) {
        if (button == this.buttonOK) {
            this.disableButtons();
            if (this.checkRequiredFields()) {
                if (this.weAreSaving) {
                    this.setVisible(false);
                    this.theCaller.fileSaveDialogOutputFileName(FileOpenDialog.getFileName());
                } else if (this.checkForFileExist(FileOpenDialog.getFileName()) && this.checkForValidName(FileOpenDialog.getFileName())) {
                    this.setVisible(false);
                    this.theCaller.fileOpenDialogOutputFileName(FileOpenDialog.getFileName());
                }
            }
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (button == this.buttonCancel) {
            fileName = null;
            if (this.weAreSaving) {
                this.theCaller.fileSaveDialogCanceled();
            } else {
                this.theCaller.fileOpenDialogCanceled();
            }
            this.setVisible(false);
            return;
        }
        if (button == this.buttonHelp) {
            HelpFrame helpFrame = HelpFrame.getHelpFrame();
            if (this.weAreSaving) {
                if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                    helpFrame.showHelp("DHBCWSA.HTM#HDRWSA");
                    return;
                }
                helpFrame.showHelp("DHSCWNS#HDRSAVE");
                return;
            }
            if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                helpFrame.showHelp("DHBCWOP.HTM#HDRWOP");
                return;
            }
            helpFrame.showHelp("DHSCWNO#HDROPEN");
            return;
        }
        if (button == this.cmdBrowse) {
            this.cmdBrowse.setEnabled(false);
            this.filemgr = this.weAreSaving ? (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new RemoteSessionMgr((RemoteFileCS)new DHCPRemoteFileCS(BINLServerGUI.getConnectionToServer()), (usesRemoteFileMgr)this, 1, TcpipLocale.getLocale(), RemoteSessionMgr.RF_FILEONLY) : new RemoteSessionMgr((RemoteFileCS)new DHCPRemoteFileCS(DHCPServerGUI.getConnectionToServer()), (usesRemoteFileMgr)this, 1, TcpipLocale.getLocale(), RemoteSessionMgr.RF_FILEONLY)) : (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new RemoteSessionMgr((RemoteFileCS)new DHCPRemoteFileCS(BINLServerGUI.getConnectionToServer()), (usesRemoteFileMgr)this, 1, TcpipLocale.getLocale(), RemoteSessionMgr.RF_MUSTEXIST + RemoteSessionMgr.RF_FILEONLY) : new RemoteSessionMgr((RemoteFileCS)new DHCPRemoteFileCS(DHCPServerGUI.getConnectionToServer()), (usesRemoteFileMgr)this, 1, TcpipLocale.getLocale(), RemoteSessionMgr.RF_MUSTEXIST + RemoteSessionMgr.RF_FILEONLY));
            this.filemgr.start();
        }
    }

    private void disableButtons() {
        this.buttonOK.setEnabled(false);
        this.buttonHelp.setEnabled(false);
        this.buttonCancel.setEnabled(false);
        this.cmdBrowse.setEnabled(false);
    }

    private void enableButtons() {
        this.buttonOK.setEnabled(true);
        this.buttonHelp.setEnabled(true);
        this.buttonCancel.setEnabled(true);
        this.cmdBrowse.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        fileName = null;
        if (this.weAreSaving) {
            this.theCaller.fileSaveDialogCanceled();
        } else {
            this.theCaller.fileOpenDialogCanceled();
        }
        this.setVisible(false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void RemoteSessionFinished(String string, int n) {
        ((TextComponent)this.theFileName).setText(string);
        this.cmdBrowse.setEnabled(true);
        this.filemgr.stop();
        this.filemgr = null;
    }

    public void RemoteSessionCanceled(int n) {
        this.cmdBrowse.setEnabled(true);
        this.filemgr.stop();
        this.filemgr = null;
    }

    public void takeErrorAction(String string) {
        if (this.fileExistFrame != null) {
            this.fileExistFrame.dispose();
            this.fileExistFrame = null;
        }
        if (this.doesntExist != null) {
            this.doesntExist.dispose();
            this.doesntExist = null;
        }
        if (string.equals(DHCPServerGUI.getResourceString("TEXT_CONTINUE_FILE_SAVE"))) {
            this.setVisible(false);
            this.theCaller.fileSaveDialogOutputFileName(FileOpenDialog.getFileName());
        }
        if (string.equals(DHCPServerGUI.getResourceString("TEXT_CHANGE_NAME_FILE_SAVE"))) {
            this.enableButtons();
        }
        if (string.equals(DHCPServerGUI.getResourceString("TEXT_BUTTON_OK"))) {
            this.enableButtons();
        }
    }
}

