/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.io.DHCPConfigFileManager;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import COM.ibm.raleigh.dhcpsgui.io.ShowAllErrors;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Frame;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeBuilder
implements ErrorReporter {
    public static final String s = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String ERROR_CFG_FILE_ERRORS = DHCPServerGUI.getResourceString("ERROR_CFG_FILE_ERRORS");
    private static final String ERROR_BOILERPLATE = DHCPServerGUI.getResourceString("ERROR_BOILERPLATE");
    private static final String ERROR_RECOVERY_QUIT = DHCPServerGUI.getResourceString("ERROR_RECOVERY_QUIT");
    private static final String ERROR_RECOVERY_DELETE_LINE = DHCPServerGUI.getResourceString("ERROR_RECOVERY_DELETE_LINE");
    private static final String ERROR_NOT_SCOPE = DHCPServerGUI.getResourceString("ERROR_NOT_SCOPE");
    private static TreeBuilder currentTreeBuilder = null;
    private static DHCPFile remoteFile = null;
    private Vector recoveryActions = new Vector();
    private IOUser user;
    private boolean resume = false;
    private boolean wildCard = false;
    private int lineNumber;
    private int linesDeleted;
    private String line;
    private String lastLine;
    Vector allTheErrors;
    Vector allTheWarnings;
    private Stack parentChain = new Stack();
    private ConfigItem lastObject;
    private ServerParameters serverParent;
    private ConfigItem globalParent;
    private ConfigItem commentParent;
    private ConfigItem commentHome = this.globalParent;
    private boolean keywordComment = false;
    private Comment tempComment;
    private ErrorReporter caller;

    public TreeBuilder(DHCPFile dHCPFile) {
        remoteFile = dHCPFile;
        this.user = DHCPConfigFileManager.getManagerInstance();
    }

    public static TreeBuilder getTreeBuilder(DHCPFile dHCPFile) {
        if (dHCPFile == null || dHCPFile != remoteFile) {
            currentTreeBuilder = new TreeBuilder(dHCPFile);
        }
        TreeBuilder.currentTreeBuilder.resume = false;
        return currentTreeBuilder;
    }

    public boolean resumeConfigTreeBuild() {
        this.resume = true;
        return this.doTreeBuild(this.serverParent, this.globalParent);
    }

    public boolean wereErrorsInFile() {
        return this.linesDeleted > 0;
    }

    public boolean buildConfigTree(ServerParameters serverParameters, ConfigItem configItem) {
        this.allTheErrors = new Vector();
        this.allTheWarnings = new Vector();
        boolean bl = this.doTreeBuild(serverParameters, configItem);
        while (!bl) {
            bl = this.resumeConfigTreeBuild();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doTreeBuild(ServerParameters serverParameters, ConfigItem configItem) {
        String string;
        Object object;
        String string2 = null;
        String string3 = null;
        int n = -1;
        this.globalParent = configItem;
        this.serverParent = serverParameters;
        if (!this.resume) {
            this.lineNumber = 0;
            this.linesDeleted = 0;
            this.tempComment = null;
            this.parentChain = new Stack();
            this.parentChain.push(configItem);
        }
        while ((this.line = this.getNextLine(remoteFile)) != null) {
            block49: {
                String string4;
                block61: {
                    ConfigItem configItem2;
                    boolean bl;
                    block62: {
                        block60: {
                            Object object2;
                            block59: {
                                block58: {
                                    block57: {
                                        block56: {
                                            block55: {
                                                block54: {
                                                    block53: {
                                                        block52: {
                                                            block51: {
                                                                block50: {
                                                                    boolean bl2;
                                                                    this.line = this.line.trim();
                                                                    while (this.line.length() > 0 && (n = this.line.lastIndexOf(92)) == this.line.length() - 1 && (string3 = this.getNextLine(remoteFile)) != null) {
                                                                        this.line = String.valueOf(this.line.substring(0, n)) + string3;
                                                                    }
                                                                    if (this.line.length() == 0) {
                                                                        if (this.tempComment == null) continue;
                                                                        if (this.commentParent != null) {
                                                                            if (this.commentParent.getParent() != null) {
                                                                                this.tempComment.commit(this.commentParent.getParent());
                                                                            }
                                                                        } else {
                                                                            object = (ConfigItem)this.parentChain.peek();
                                                                            ((ConfigItem)object).setComment(this.tempComment);
                                                                        }
                                                                        this.tempComment = null;
                                                                        continue;
                                                                    }
                                                                    if (this.line.indexOf("##") == 0) continue;
                                                                    if (this.line.indexOf("#vendor" + ' ' + "PXEClient") > -1) {
                                                                        this.line = this.line.replace('#', ' ');
                                                                        this.line = this.line.trim();
                                                                    } else if (this.line.indexOf("#option") > -1) {
                                                                        if ((ConfigItem)this.parentChain.peek() != null && (ConfigItem)this.parentChain.peek() instanceof Vendor && ((Vendor)this.parentChain.peek()).getVendorName().equalsIgnoreCase("PXEClient")) {
                                                                            this.line = this.line.replace('#', ' ');
                                                                            this.line = this.line.trim();
                                                                        }
                                                                    } else if (this.line.indexOf("#}") > -1) {
                                                                        if ((ConfigItem)this.parentChain.peek() != null && (ConfigItem)this.parentChain.peek() instanceof Vendor && ((Vendor)this.parentChain.peek()).getVendorName().equalsIgnoreCase("PXEClient")) {
                                                                            this.line = this.line.replace('#', ' ');
                                                                            this.line = this.line.trim();
                                                                        }
                                                                    } else if (this.line.indexOf("#{") > -1 && string2 != null && string2.equalsIgnoreCase("vendor" + ' ' + "PXEClient")) {
                                                                        this.line = this.line.replace('#', ' ');
                                                                        this.line = this.line.trim();
                                                                    }
                                                                    if (this.line.indexOf("#") >= 0 && (bl2 = this.comment())) continue;
                                                                    StringTokenizer stringTokenizer = new StringTokenizer(this.line, "\n \r\t");
                                                                    string = stringTokenizer.nextToken();
                                                                    string4 = this.line.substring(string.length());
                                                                    if (this.resume) {
                                                                        this.resume = false;
                                                                        if (string.equals("{")) {
                                                                            if (this.eatScopedLines(string)) continue;
                                                                            break;
                                                                        }
                                                                    }
                                                                    if (!string.equalsIgnoreCase("subnet")) break block50;
                                                                    object2 = Subnetwork.parse((ConfigItem)this.parentChain.peek(), string4);
                                                                    bl = this.processObjectCreation(object2, this.line);
                                                                    if (!bl) {
                                                                        return false;
                                                                    }
                                                                    break block49;
                                                                }
                                                                if (string.equals("{")) {
                                                                    if (this.lastObject != null && (this.lastObject instanceof Subnetwork || this.lastObject instanceof DHCPClass || this.lastObject instanceof Client || this.lastObject instanceof Vendor && ((Vendor)this.lastObject).isEncapsulatedFormat())) {
                                                                        this.parentChain.push(this.lastObject);
                                                                        if (this.tempComment != null) {
                                                                            this.lastObject.setComment(this.tempComment);
                                                                            this.tempComment = null;
                                                                        }
                                                                        this.lastObject = null;
                                                                        break block49;
                                                                    } else {
                                                                        this.postError(new Message(String.valueOf(ERROR_NOT_SCOPE) + this.lastLine), this.line);
                                                                        if (!this.eatScopedLines(string)) break;
                                                                        return false;
                                                                    }
                                                                }
                                                                if (!string.equals("}")) break block51;
                                                                if (!this.parentChain.empty()) {
                                                                    if (this.tempComment != null) {
                                                                        ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                                                                        this.tempComment = null;
                                                                    }
                                                                    this.commentParent = (ConfigItem)this.parentChain.pop();
                                                                    if (this.parentChain.empty()) {
                                                                        this.postError(new Message("A closing brace (\"}\") without an earlier open brace (\"{\") caused the remainder of the file to be ignored"), this.line);
                                                                        break;
                                                                    }
                                                                }
                                                                this.lastObject = null;
                                                                break block49;
                                                            }
                                                            if (!string.equalsIgnoreCase("class")) break block52;
                                                            object2 = DHCPClass.parse((ConfigItem)this.parentChain.peek(), string4, this.wildCard);
                                                            bl = this.processObjectCreation(object2, this.line);
                                                            this.wildCard = false;
                                                            if (!bl) {
                                                                return false;
                                                            }
                                                            break block49;
                                                        }
                                                        if (!string.equalsIgnoreCase("client")) break block53;
                                                        object2 = CommonClient.parse((ConfigItem)this.parentChain.peek(), string4);
                                                        bl = this.processObjectCreation(object2, this.line);
                                                        if (!bl) {
                                                            return false;
                                                        }
                                                        break block49;
                                                    }
                                                    if (!string.equalsIgnoreCase("option")) break block54;
                                                    object2 = this.option(this.line.substring(string.length()));
                                                    bl = this.processObjectCreation(object2, this.line);
                                                    if (!bl) {
                                                        return false;
                                                    }
                                                    break block49;
                                                }
                                                if (!string.equalsIgnoreCase("vendor") || string4.equalsIgnoreCase("PXEClient")) break block55;
                                                object2 = Vendor.parse((ConfigItem)this.parentChain.peek(), string4);
                                                bl = this.processObjectCreation(object2, this.line);
                                                if (!bl) {
                                                    return false;
                                                }
                                                break block49;
                                            }
                                            if (!string.equalsIgnoreCase("balance:") && !string.equalsIgnoreCase("inOrder:")) break block56;
                                            if (!(this.parentChain.peek() instanceof Global)) {
                                                this.postError(new Message(ConfigItem.ERROR_WRONG_SCOPE), this.line);
                                                return false;
                                            }
                                            object2 = ((Global)this.parentChain.peek()).addSubnetGroups(string, string4);
                                            bl = this.processObjectCreation(object2, this.line);
                                            if (!bl) {
                                                return false;
                                            }
                                            break block49;
                                        }
                                        if (!string.equalsIgnoreCase("proxyARec")) break block57;
                                        object2 = ((ConfigItem)this.parentChain.peek()).setARecordSupport(string4);
                                        bl = this.processObjectCreation(object2, this.line);
                                        if (!bl) {
                                            return false;
                                        }
                                        break block49;
                                    }
                                    if (!string.equalsIgnoreCase("bootstrapServer")) break block58;
                                    object2 = ((ConfigItem)this.parentChain.peek()).setBootstrapServer(string4);
                                    bl = this.processObjectCreation(object2, this.line);
                                    if (!bl) {
                                        return false;
                                    }
                                    break block49;
                                }
                                if (!string.equalsIgnoreCase("canonical")) break block59;
                                object2 = ((ConfigItem)this.parentChain.peek()).setBooleanKeyword("canonical", string4);
                                bl = this.processObjectCreation(object2, this.line);
                                if (!bl) {
                                    return false;
                                }
                                break block49;
                            }
                            if (!string.equalsIgnoreCase("appendDomainName")) break block60;
                            object2 = ((ConfigItem)this.parentChain.peek()).setBooleanKeyword("appendDomainName", string4);
                            bl = this.processObjectCreation(object2, this.line);
                            if (!bl) {
                                return false;
                            }
                            break block49;
                        }
                        if (!string.equalsIgnoreCase("supportUnlistedClients")) break block61;
                        configItem2 = (ConfigItem)this.parentChain.peek();
                        if (!(configItem2 instanceof Subnetwork)) break block62;
                        ((Subnetwork)configItem2).parseUnlistedClientSupport(string, string4);
                        bl = this.processObjectCreation(null, this.line);
                        if (!bl) {
                            return false;
                        }
                        break block49;
                    }
                    if (configItem2 instanceof DHCPClass) {
                        ((DHCPClass)configItem2).parseUnlistedClientSupport(string, string4);
                        bl = this.processObjectCreation(null, this.line);
                        if (!bl) {
                            return false;
                        }
                        break block49;
                    } else if (string.equalsIgnoreCase("vendor") && string4.equalsIgnoreCase("PXEClient")) {
                        this.processServerParameters(string);
                        break block49;
                    } else {
                        this.processServerParameters(string);
                    }
                    break block49;
                }
                if (string.equalsIgnoreCase("vendor") && string4.equalsIgnoreCase("PXEClient")) {
                    this.processServerParameters(string);
                } else {
                    this.processServerParameters(string);
                }
            }
            if (this.tempComment != null) {
                if (this.parentChain.peek() != null) {
                    ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                }
                this.tempComment = null;
            }
            string2 = this.line;
        }
        if (!this.parentChain.empty() && this.parentChain.peek() != configItem) {
            this.postError(new Message("End of file reached without closing brace (\"}\") being found"), "");
        }
        if (this.tempComment != null) {
            ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
            this.tempComment = null;
        }
        if (this.allTheErrors.isEmpty() && this.allTheWarnings.isEmpty()) {
            if (this.user == null) return true;
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_READY, 5);
            return true;
        }
        object = new ShowAllErrors(new Frame(), this.allTheErrors, this.allTheWarnings);
        string = ((ShowAllErrors)object).askUserWhatToDo();
        ((Window)object).dispose();
        this.takeErrorAction(string);
        this.allTheErrors = new Vector();
        this.allTheWarnings = new Vector();
        return true;
    }

    private boolean processServerParameters(String string) {
        boolean bl = false;
        Message message = this.serverParent.isKeyword(string);
        if (message != null) {
            this.postError(message, this.line);
            bl = false;
        } else if (!(this.parentChain.peek() instanceof Global)) {
            this.postError(new Message(ConfigItem.ERROR_WRONG_SCOPE), this.line);
            bl = false;
        } else {
            Message message2 = this.serverParent.setParameter(this.line);
            boolean bl2 = this.processObjectCreation(message2, this.line);
            if (!bl2) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean eatScopedLines(String string) {
        Stack<String> stack = new Stack<String>();
        stack.push(string);
        while ((this.line = this.getNextLine(remoteFile)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.line, "\n \r\t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            string = stringTokenizer.nextToken();
            if (string.equals("{")) {
                stack.push(string);
                continue;
            }
            if (!string.equals("}")) continue;
            stack.pop();
            if (!stack.empty()) continue;
            return true;
        }
        return false;
    }

    private boolean comment() {
        int n = this.line.trim().indexOf(35);
        if (n == 0) {
            if (this.line.equals("#@@@WILD@@@")) {
                this.wildCard = true;
                return true;
            }
            if (this.tempComment != null) {
                this.tempComment.addLine(this.line);
            } else {
                this.tempComment = new Comment(this.line);
            }
            return true;
        }
        if (n > 0) {
            if (this.tempComment != null) {
                this.tempComment.addLine(this.line);
            } else {
                this.tempComment = new Comment(this.line);
            }
            this.line = this.line.substring(0, n);
            return false;
        }
        return false;
    }

    private Object option(String string) {
        if (this.parentChain.empty()) {
            throw new ShouldNotOccurException("TreeBuilder parsing error -- no scope for adding an option.  Stack empty");
        }
        if (this.parentChain.peek() instanceof Vendor) {
            Vendor vendor = (Vendor)((ConfigItem)this.parentChain.peek());
            if (vendor.getVendorName().equalsIgnoreCase("PXEClient")) {
                return Option.parse((ConfigItem)this.parentChain.peek(), string);
            }
            return VendorOption.parse((ConfigItem)this.parentChain.peek(), string);
        }
        return Option.parse((ConfigItem)this.parentChain.peek(), string);
    }

    public void takeErrorAction(String string) {
        if (string.equals(ERROR_RECOVERY_QUIT)) {
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_QUIT, 7);
            remoteFile.close();
            return;
        }
        ++this.linesDeleted;
        Object[] objectArray = new Object[]{new Integer(this.linesDeleted)};
        this.user.updateIOStatus(null, MessageFormat.format(IOUser.TEXT_MESSAGE_DELETE_LINE, objectArray), 6);
    }

    private boolean processObjectCreation(Object object, String string) {
        this.lastObject = null;
        if (object == null) {
            if (this.tempComment != null) {
                ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                this.tempComment = null;
            }
            return true;
        }
        if (object instanceof ConfigItem) {
            this.lastObject = (ConfigItem)object;
            this.commentParent = null;
            if (this.lastObject.hasMessages()) {
                Enumeration enumeration = this.lastObject.getMessages();
                while (enumeration.hasMoreElements()) {
                    this.postWarning((Message)enumeration.nextElement(), string);
                }
                this.lastObject.clearMessages();
            }
            if (this.tempComment != null) {
                this.lastObject.setComment(this.tempComment);
                this.tempComment = null;
            }
            return true;
        }
        if (object instanceof Message) {
            if (((Message)object).checkErrors()) {
                this.postError((Message)object, string);
            }
            if (((Message)object).checkWarnings()) {
                Enumeration enumeration = ((Message)object).extractWarnings();
                while (enumeration.hasMoreElements()) {
                    this.postWarning((String)enumeration.nextElement(), string);
                }
                ((Message)object).clearWarnings();
            }
            if (this.tempComment != null) {
                this.tempComment = null;
            }
            return false;
        }
        return false;
    }

    private void postError(Message message, String string) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string, message.getText()};
        this.allTheErrors.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_ERROR"), objectArray));
    }

    private void postWarning(Message message, String string) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string, message.getText()};
        this.allTheWarnings.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_WARNING"), objectArray));
    }

    private void postWarning(String string, String string2) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string2, string};
        this.allTheWarnings.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_WARNING"), objectArray));
    }

    private String getNextLine(DHCPFile dHCPFile) {
        this.lastLine = this.line;
        Object object = dHCPFile.readLine();
        if (object instanceof Boolean) {
            return null;
        }
        ++this.lineNumber;
        return (String)object;
    }
}

