/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.DDNSKeySupport;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;

class ARecordDomainsPanel
extends NotebookPanel
implements ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_ENTER_AREC_DOMAINS = DHCPServerGUI.getResourceString("TEXT_ENTER_AREC_DOMAINS");
    private static final String TEXT_DOMAIN_NAME = DHCPServerGUI.getResourceString("TEXT_DOMAIN_NAME");
    private static final String TEXT_DDNS_SERVER = DHCPServerGUI.getResourceString("TEXT_DDNS_SERVER");
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private static final String LOCATION_CREATE_KEYS = DHCPServerGUI.getResourceString("TEXT_CREATE_KEYS");
    private static final String ERROR_MISSING_FIELD = DHCPServerGUI.getResourceString("ERROR_MISSING_FIELD");
    private DDNSKeySupport ddnsInfo;
    private TextField tfDomain;
    private TextField tfServer;
    private Button butAdd;
    private Button butDel;
    private List listDomains;

    ARecordDomainsPanel() {
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        super.initializePanel(configItem, notebookFrame);
        this.ddnsInfo = ((ServerParameters)configItem).getDDNSKeySupport();
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 4, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        this.add(new Label(TEXT_ENTER_AREC_DOMAINS), gridBagLayout, gridBagConstraints, 0, 0, 3, 1);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        this.add(new Label(TEXT_DOMAIN_NAME), gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.anchor = 18;
        this.tfDomain = new TextField(20);
        this.add(this.tfDomain, gridBagLayout, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.anchor = 12;
        this.add(new Label(TEXT_DDNS_SERVER), gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.anchor = 18;
        this.tfServer = new TextField(20);
        this.add(this.tfServer, gridBagLayout, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.butAdd = new Button(TEXT_BUTTON_ADD);
        this.butAdd.setBackground(Color.lightGray);
        this.add(this.butAdd, gridBagLayout, gridBagConstraints, 4, 2, 1, 1);
        this.butAdd.addActionListener(this);
        this.butAdd.addKeyListener(this);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        this.listDomains = new List(6, false);
        this.add(this.listDomains, gridBagLayout, gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.butDel = new Button(TEXT_BUTTON_REMOVE);
        this.butDel.setBackground(Color.lightGray);
        this.add(this.butDel, gridBagLayout, gridBagConstraints, 4, 3, 1, 1);
        this.butDel.addActionListener(this);
        this.butDel.addKeyListener(this);
    }

    public void populatePanel() {
        this.populateDomainList();
    }

    private void populateDomainList() {
        ((TextComponent)this.tfDomain).setText("");
        ((TextComponent)this.tfServer).setText("");
        this.listDomains.removeAll();
        Enumeration enumeration = this.ddnsInfo.getDomains();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.listDomains.addItem(string);
        }
    }

    public boolean saveState() {
        return true;
    }

    private void handleButton(Button button) {
        int n;
        Message message = null;
        if (button == this.butAdd) {
            String string = this.tfDomain.getText().trim();
            String string2 = this.tfServer.getText().trim();
            if (!string.equals("") && !string2.equals("")) {
                message = this.ddnsInfo.addDomain(string, string2);
                if (message == null) {
                    this.listDomains.addItem(String.valueOf(string) + "  " + string2);
                    ((TextComponent)this.tfDomain).setText("");
                    ((TextComponent)this.tfServer).setText("");
                }
            } else {
                Object[] objectArray = new String[]{string.equals("") ? TEXT_DOMAIN_NAME : TEXT_DDNS_SERVER};
                message = new Message(MessageFormat.format(ERROR_MISSING_FIELD, objectArray));
            }
        } else if (button == this.butDel && (n = this.listDomains.getSelectedIndex()) != -1) {
            String string = this.listDomains.getSelectedItem();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.listDomains.delItem(n);
            this.ddnsInfo.removeDomain(stringTokenizer.nextToken());
        }
        if (message != null) {
            message.setLocation(LOCATION_CREATE_KEYS);
            this.callingNotebook.displayError(message);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

