/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.notebook.IPAddressField;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class AddrPairListPanel
extends Panel
implements OptionInputPanel,
ActionListener,
KeyListener,
ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_LABEL_ADD_ADDRESS_PAIR = DHCPServerGUI.getResourceString("TEXT_LABEL_ADD_ADDRESS_PAIR");
    private static final String TEXT_LABEL_IP_ADDRESS_PAIRS = DHCPServerGUI.getResourceString("TEXT_LABEL_IP_ADDRESS_PAIRS");
    private static final String ERROR_REQUIRED_FIELDS = DHCPServerGUI.getResourceString("ERROR_REQUIRED_FIELDS");
    private static final String TEXT_LOCATION_FIRST_ADDRESS = DHCPServerGUI.getResourceString("TEXT_LOCATION_FIRST_ADDRESS");
    private static final String TEXT_LOCATION_SECOND_ADDRESS = DHCPServerGUI.getResourceString("TEXT_LOCATION_SECOND_ADDRESS");
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private OptionSkeleton skeleton;
    Label addrPairListLabel;
    Label addAddrPair;
    Label addAddrPairMate;
    Button buttonAdd;
    Button buttonRemove;
    List addrPairList;
    int selectedIndex = -1;
    IPAddressField newAddr;
    IPAddressField newAddrMate;
    String dataType;
    NotebookFrame callingNotebook;

    public AddrPairListPanel() {
        this.layoutPanel();
    }

    public void populate(String string) {
        this.resetFields();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            this.addrPairList.addItem((String)stringTokenizer.nextElement());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.addrPairList) {
            this.selectedIndex = this.addrPairList.getSelectedIndex();
        }
    }

    public String getUserInput() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.addrPairList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(String.valueOf(this.addrPairList.getItem(n2)) + " ");
            ++n2;
        }
        if (this.newAddr.getText().length() > 0 && this.newAddrMate.getText().length() > 0) {
            stringBuffer.append(String.valueOf(this.newAddr.getText()) + ":" + this.newAddrMate.getText());
        }
        return stringBuffer.toString();
    }

    public void resetFields() {
        this.addrPairList.removeAll();
        this.newAddr.setText("");
        this.newAddrMate.setText("");
    }

    public void setFormat(OptionSkeleton optionSkeleton, Font font) {
        this.skeleton = optionSkeleton;
        this.dataType = optionSkeleton.getDatatype();
        Enumeration enumeration = optionSkeleton.getLabelSet();
        if (enumeration.hasMoreElements()) {
            this.addAddrPair.setText("(" + (String)enumeration.nextElement() + ")");
        }
        if (enumeration.hasMoreElements()) {
            this.addAddrPairMate.setText("(" + (String)enumeration.nextElement() + ")");
        }
    }

    public void setCaller(NotebookFrame notebookFrame) {
        this.callingNotebook = notebookFrame;
    }

    private void layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addAddrPair = new Label(TEXT_LABEL_ADD_ADDRESS_PAIR);
        this.add(this.addAddrPair, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.addAddrPairMate = new Label(TEXT_LABEL_ADD_ADDRESS_PAIR);
        this.add(this.addAddrPairMate, gridBagLayout, gridBagConstraints, 1, 0, 0, 1);
        this.newAddr = new IPAddressField();
        this.add(this.newAddr, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.newAddrMate = new IPAddressField();
        this.add(this.newAddrMate, gridBagLayout, gridBagConstraints, 1, 1, 0, 1);
        this.buttonAdd = new Button(TEXT_BUTTON_ADD);
        this.buttonAdd.setBackground(Color.lightGray);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        gridBagConstraints.anchor = 15;
        this.add(this.buttonAdd, gridBagLayout, gridBagConstraints, 0, 2, 0, 1);
        gridBagConstraints.anchor = 17;
        this.addrPairListLabel = new Label(TEXT_LABEL_IP_ADDRESS_PAIRS);
        gridBagConstraints.anchor = 17;
        this.add(this.addrPairListLabel, gridBagLayout, gridBagConstraints, 0, 3, 0, 1);
        this.addrPairList = new List(3, false);
        this.addrPairList.addItemListener(this);
        gridBagConstraints.fill = 2;
        this.add(this.addrPairList, gridBagLayout, gridBagConstraints, 0, 4, 0, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.buttonRemove = new Button(TEXT_BUTTON_REMOVE);
        this.buttonRemove.setBackground(Color.lightGray);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        this.add(this.buttonRemove, gridBagLayout, gridBagConstraints, 0, 6, 0, 0);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void handleButton(Button button) {
        if (button == this.buttonAdd) {
            Message message;
            String string = this.newAddr.getText();
            String string2 = this.newAddrMate.getText();
            int n = string.trim().length();
            int n2 = string2.trim().length();
            if (n == 0 && n2 == 0) {
                return;
            }
            if (n == 0 || n2 == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = this.skeleton.getLabelSet();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append((String)enumeration.nextElement());
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(", ");
                }
                Object[] objectArray = new Object[]{stringBuffer.toString()};
                message = new Message(MessageFormat.format(ERROR_REQUIRED_FIELDS, objectArray));
            } else {
                message = IPAddress.validateAddress(string);
                if (message != null) {
                    message.setLocation(TEXT_LOCATION_FIRST_ADDRESS);
                } else {
                    message = this.dataType.equals("IP address pairs with mask") ? IPSubnetMask.validateAddress(string2) : IPAddress.validateAddress(string2);
                    if (message != null) {
                        message.setLocation(TEXT_LOCATION_SECOND_ADDRESS);
                    }
                }
            }
            if (message != null) {
                this.callingNotebook.displayError(message);
                return;
            }
            this.addrPairList.addItem(String.valueOf(string) + ":" + string2);
            this.newAddr.setText("");
            this.newAddrMate.setText("");
            return;
        }
        if (button == this.buttonRemove && this.addrPairList != null && this.selectedIndex >= 0) {
            this.addrPairList.delItem(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

