/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class BINLClientInfoPanel
extends NotebookPanel
implements KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_CLIENTNAME = DHCPServerGUI.getResourceString("TEXT_CLIENTNAME");
    private static final String TEXT_ID = DHCPServerGUI.getResourceString("TEXT_ID");
    private static final String TEXT_TYPE = DHCPServerGUI.getResourceString("TEXT_TYPE");
    private static final String TEXT_ID_AND_TYPE = DHCPServerGUI.getResourceString("TEXT_ID_AND_TYPE");
    private static final String TEXT_SCOPE = DHCPServerGUI.getResourceString("TEXT_SCOPE");
    private static final String TEXT_COMMENT = DHCPServerGUI.getResourceString("TEXT_COMMENT");
    private static final String TEXT_CLIENT_INFO_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_CLIENT_INFO_BOX_LABEL");
    private TextFieldWithTab name;
    private TextFieldWithTab clientID;
    private Choice hwtype;
    private Choice scope;
    private Label nameLabel;
    private Label idLabel;
    private Label typeLabel;
    private Label scopeLabel;
    private WrappedTextPanel infoLabel;
    private Panel clientPanel;
    private Font theTextFont;
    private Font theTitleFont;
    private TextArea comment;
    private Label commentLabel;
    private ConfigItem parent = null;
    private Client client = null;
    private NotebookFrame parentFrame = null;
    private Vector scopeObjects = new Vector();
    private boolean existingClient;
    private BINLGlobal global;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.client = (Client)configItem;
        this.parentFrame = notebookFrame;
        this.parent = this.parentFrame.getItemParent();
        this.global = this.parentFrame.getBINLGlobal();
        this.remove(this.scope);
        this.scope = null;
        this.comment.setText("");
        if (this.parentFrame.isNewItem()) {
            this.existingClient = false;
            return;
        }
        this.existingClient = true;
    }

    public void populatePanel() {
        String string;
        if (this.client.getAlias() != null) {
            ((TextComponent)this.name).setText(this.client.getAlias());
        } else {
            ((TextComponent)this.name).setText("");
        }
        if (this.client.getIdValue() != null) {
            ((TextComponent)this.clientID).setText(this.client.getIdValue());
        } else {
            ((TextComponent)this.clientID).setText("");
        }
        this.hwtype.select(this.client.getIdType());
        this.scope = new Choice();
        if (this.populateScopeChoice(this.scope, this.global, this.client, this.parent, this.existingClient)) {
            this.parentFrame.setItemParent(this.parent);
        }
        if ((string = this.client.getComment()) != null) {
            this.comment.setText(string);
        }
    }

    public boolean saveState() {
        if (this.existingClient) {
            this.parentFrame.setItemParent(this.parent);
        } else {
            this.parentFrame.setItemParent(this.getScopeParent());
        }
        this.parent = this.parentFrame.getItemParent();
        Message message = this.client.setAlias(this.name.getText());
        if (message != null) {
            message.setLocation(TEXT_CLIENTNAME);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdValue(this.clientID.getText());
        if (message != null) {
            message.setLocation(TEXT_ID);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdTypeUsingIndex(this.hwtype.getSelectedIndex());
        if (message != null) {
            message.setLocation(TEXT_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.validateIDAndType(this.parent);
        if (message != null) {
            message.setLocation(TEXT_ID_AND_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        this.client.setComment(this.comment.getText());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void initComponents() {
        this.infoLabel = new WrappedTextPanel(TEXT_CLIENT_INFO_BOX_LABEL, 110);
        this.nameLabel = new Label(TEXT_CLIENTNAME);
        this.idLabel = new Label(TEXT_ID);
        this.typeLabel = new Label(TEXT_TYPE);
        this.scopeLabel = new Label(TEXT_SCOPE);
        this.name = new TextFieldWithTab(17);
        this.clientID = new TextFieldWithTab(17);
        this.hwtype = new Choice();
        this.scope = new Choice();
        this.clientPanel = new Panel();
        this.comment = new TextArea("", 5, 60);
        this.comment.addKeyListener(this);
        this.commentLabel = new Label(TEXT_COMMENT);
    }

    public void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.infoLabel.getNumDividedTextLines();
        ((Component)this).setFont(this.theTextFont);
        this.setLayout(gridBagLayout);
        String[] stringArray = CommonClient.getTypeList();
        int n = 0;
        while (n < stringArray.length) {
            this.hwtype.addItem(stringArray[n]);
            ++n;
        }
        this.clientPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.constrain(this.nameLabel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.clientPanel.add(this.nameLabel);
        this.constrain(this.name, gridBagLayout, gridBagConstraints, 1, 0, 1, 1);
        this.clientPanel.add(this.name);
        this.constrain(this.typeLabel, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.clientPanel.add(this.typeLabel);
        this.constrain(this.hwtype, gridBagLayout, gridBagConstraints, 1, 1, 1, 1);
        this.clientPanel.add(this.hwtype);
        this.constrain(this.idLabel, gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        this.clientPanel.add(this.idLabel);
        this.constrain(this.clientID, gridBagLayout, gridBagConstraints, 1, 2, 1, 1);
        this.clientPanel.add(this.clientID);
        this.constrain(this.commentLabel, gridBagLayout, gridBagConstraints, 0, 3, 1, 1);
        this.clientPanel.add(this.commentLabel);
        gridBagConstraints.fill = 2;
        this.constrain(this.comment, gridBagLayout, gridBagConstraints, -1, 3, 0, 1);
        this.clientPanel.add(this.comment);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.clientPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
        this.add(this.clientPanel);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

