/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.ComputerDomain;
import COM.ibm.raleigh.dhcpsgui.biz.ComputerName;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class BINLParametersPanel
extends NotebookPanel
implements ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_BINL_SERVERNAME_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_SERVERNAME_LABEL");
    private static final String TEXT_BINL_SERVERNAME_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_SERVERNAME_BOX_LABEL");
    private static final String TEXT_BINL_DOMAINNAME_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_DOMAINNAME_LABEL");
    private static final String TEXT_BINL_WORKGROUP_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_WORKGROUP_LABEL");
    private static final String TEXT_BINL_DOMAINNAME_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_DOMAINNAME_BOX_LABEL");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private WrappedTextPanel infoLabel;
    private TextField serverField;
    private Label serverLabel;
    private Panel serverPanel;
    private TextField domainField;
    private Label domainLabel;
    private TextField workGroupField;
    private Label workGroupLabel;
    private Checkbox chooseDomain;
    private Checkbox chooseWorkgroup;
    private CheckboxGroup chooseGroup;
    private BorderPanel domainPanel;
    private Font theTextFont;
    private Font theTitleFont;
    private ConfigItem cfgItem;
    private String computerName;
    private String domainName;
    private String domainType;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
        this.cfgItem = configItem;
    }

    public void populatePanel() {
        ComputerName computerName = (ComputerName)this.cfgItem.getKeyword("servername");
        ComputerName computerName2 = (ComputerName)this.cfgItem.getApplicableKeyword("servername");
        this.computerName = computerName != null ? computerName.getValue() : (computerName2 != null ? computerName2.getValue() : "");
        ((TextComponent)this.serverField).setText(this.computerName);
        ComputerDomain computerDomain = (ComputerDomain)this.cfgItem.getKeyword("serverdomainname");
        ComputerDomain computerDomain2 = (ComputerDomain)this.cfgItem.getApplicableKeyword("serverdomainname");
        if (computerDomain != null) {
            this.domainName = computerDomain.getValue();
            this.domainType = computerDomain.getType();
        } else if (computerDomain2 != null) {
            this.domainName = computerDomain2.getValue();
            this.domainType = computerDomain2.getType();
        } else {
            this.domainName = "";
            this.domainType = "domain";
        }
        if (this.domainType.equalsIgnoreCase("domain")) {
            ((TextComponent)this.domainField).setText(this.domainName);
            ((TextComponent)this.workGroupField).setText("");
        } else {
            ((TextComponent)this.workGroupField).setText(this.domainName);
            ((TextComponent)this.domainField).setText("");
        }
        this.setStates(this.domainType);
    }

    private void setStates(String string) {
        if (string.equalsIgnoreCase("domain")) {
            this.chooseDomain.setState(true);
            this.workGroupField.setEnabled(false);
            this.domainField.setEnabled(true);
            return;
        }
        if (string.equalsIgnoreCase("workgroup")) {
            this.chooseWorkgroup.setState(true);
            this.domainField.setEnabled(false);
            this.workGroupField.setEnabled(true);
        }
    }

    private String getStates(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.chooseDomain) {
            return "domain";
        }
        return "workgroup";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setDomainType(this.getStates(itemEvent));
        this.setStates(this.getDomainType());
    }

    public String getComputerName() {
        return this.computerName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainType() {
        return this.domainType;
    }

    public void setComputerName(String string) {
        this.computerName = string;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setDomainType(String string) {
        this.domainType = string;
    }

    public boolean saveState() {
        String string = null;
        string = this.serverField.getText();
        Message message = this.cfgItem.setComputerName(string);
        if (message != null) {
            message.setLocation(TEXT_BINL_SERVERNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        String string2 = this.getDomainType();
        string = string2.equalsIgnoreCase("domain") ? this.domainField.getText() : this.workGroupField.getText();
        message = this.cfgItem.setComputerDomain(String.valueOf(string) + " " + this.domainType);
        if (message != null) {
            message.setLocation(TEXT_BINL_DOMAINNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    private void initComponents() {
        this.infoLabel = new WrappedTextPanel(TEXT_BINL_SERVERNAME_BOX_LABEL, 110);
        this.serverField = new TextField(25);
        this.serverLabel = new Label(TEXT_BINL_SERVERNAME_LABEL);
        this.serverPanel = new Panel();
        this.chooseGroup = new CheckboxGroup();
        this.chooseDomain = new Checkbox(TEXT_BINL_DOMAINNAME_LABEL, false, this.chooseGroup);
        this.domainField = new TextField(40);
        this.chooseWorkgroup = new Checkbox(TEXT_BINL_WORKGROUP_LABEL, false, this.chooseGroup);
        this.workGroupField = new TextField(40);
        this.domainPanel = new BorderPanel(TEXT_BINL_DOMAINNAME_BOX_LABEL);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.infoLabel.getNumDividedTextLines();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.serverPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.constrain((Component)this.infoLabel, gridBagLayout, gridBagConstraints, 0, 0, 0, n);
        this.serverPanel.add((Component)this.infoLabel);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.constrain(this.serverLabel, gridBagLayout, gridBagConstraints, 0, 1 + n, 1, 1);
        this.serverPanel.add(this.serverLabel);
        gridBagConstraints.insets = new Insets(0, -105, 0, 0);
        this.constrain(this.serverField, gridBagLayout, gridBagConstraints, 1, 1 + n, 1, 1);
        this.serverPanel.add(this.serverField);
        this.domainPanel.setLayout(gridBagLayout);
        ((Component)this.domainPanel).setFont(this.theTextFont);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.chooseDomain, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.chooseDomain.addItemListener(this);
        this.domainPanel.add(this.chooseDomain);
        this.constrain(this.domainField, gridBagLayout, gridBagConstraints, 1, 0, 1, 1);
        this.domainPanel.add(this.domainField);
        this.constrain(this.chooseWorkgroup, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.chooseWorkgroup.addItemListener(this);
        this.domainPanel.add(this.chooseWorkgroup);
        this.constrain(this.workGroupField, gridBagLayout, gridBagConstraints, 1, 1, 1, 1);
        this.domainPanel.add(this.workGroupField);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        this.constrain(this.domainPanel, gridBagLayout, gridBagConstraints, 0, 2 + n, 0, 0);
        this.serverPanel.add(this.domainPanel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.serverPanel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.add(this.serverPanel);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

