/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.IPAddressField;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.util.Vector;

public class ClassInfoPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INVALID_ENCLOSING_SUBNET = DHCPServerGUI.getResourceString("ERROR_INVALID_ENCLOSING_SUBNET");
    private static final String TEXT_SCOPE = DHCPServerGUI.getResourceString("TEXT_SCOPE");
    private static final String TEXT_RANGE = DHCPServerGUI.getResourceString("TEXT_RANGE");
    private static final String TEXT_FROM = DHCPServerGUI.getResourceString("TEXT_FROM");
    private static final String TEXT_WILDCARD = DHCPServerGUI.getResourceString("TEXT_WILDCARD");
    private static final String TEXT_TO = DHCPServerGUI.getResourceString("TEXT_TO");
    private static final String TEXT_CLASSNAME = DHCPServerGUI.getResourceString("TEXT_CLASSNAME");
    private TextFieldWithTab name;
    private Checkbox wildCardCb;
    private IPAddressField rangeFrom;
    private IPAddressField rangeTo;
    private ConfigItem parent = null;
    private DHCPClass cl = null;
    private NotebookFrame parentFrame = null;
    private Global global;
    private Label rangeLabel;
    private Label fromLabel;
    private Label toLabel;
    private Vector scopeObjects = new Vector();
    private Choice scope;
    private boolean parentissubnet;
    private String address;
    private String mask;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.cl = (DHCPClass)configItem;
        this.parentFrame = notebookFrame;
        this.parent = this.parentFrame.getItemParent();
        this.global = this.parentFrame.getGlobal();
        if (this.parent instanceof Global) {
            this.rangeLabel.setVisible(false);
            this.fromLabel.setVisible(false);
            this.rangeFrom.setVisible(false);
            this.toLabel.setVisible(false);
            this.rangeTo.setVisible(false);
            return;
        }
        this.rangeLabel.setVisible(true);
        this.fromLabel.setVisible(true);
        this.rangeFrom.setVisible(true);
        this.toLabel.setVisible(true);
        this.rangeTo.setVisible(true);
    }

    public void populatePanel() {
        if (this.cl.getClassName() != null) {
            ((TextComponent)this.name).setText(this.cl.getClassName());
        } else {
            ((TextComponent)this.name).setText("");
        }
        this.wildCardCb.setState(this.cl.getWildCardSupported());
        if (this.parent instanceof Subnetwork) {
            this.parentissubnet = true;
            this.parentFrame.somethingChanged();
            this.cl.setSubnetDefinition((Subnetwork)this.parent);
            if (((Subnetwork)this.parent).isValidSubnet()) {
                this.rangeFrom.setEditable(true);
                this.rangeTo.setEditable(true);
                if (this.cl.getRangeStart() != null) {
                    this.rangeFrom.setText(this.cl.getRangeStart());
                } else {
                    this.rangeFrom.setText("");
                }
                if (this.cl.getRangeEnd() != null) {
                    this.rangeTo.setText(this.cl.getRangeEnd());
                    return;
                }
                this.rangeTo.setText("");
                return;
            }
            this.rangeFrom.setEditable(false);
            this.rangeTo.setEditable(false);
            Message message = new Message(ERROR_INVALID_ENCLOSING_SUBNET);
            message.setLocation(TEXT_RANGE);
            this.parentFrame.displayError(message);
            return;
        }
        this.parentissubnet = false;
        this.rangeFrom.setText("");
        this.rangeFrom.setEditable(false);
        this.rangeTo.setText("");
        this.rangeTo.setEditable(false);
    }

    public boolean saveState() {
        Message message;
        boolean bl = false;
        if (this.wildCardCb.getState()) {
            bl = true;
        }
        if ((message = this.cl.setClassName(this.name.getText(), bl)) != null) {
            message.setLocation(TEXT_CLASSNAME);
            this.parentFrame.displayError(message);
            return false;
        }
        if (this.parentissubnet) {
            String string = this.rangeFrom.getText().trim();
            String string2 = this.rangeTo.getText().trim();
            String string3 = string.length() == 0 && string2.length() == 0 ? null : String.valueOf(string) + "-" + string2;
            message = this.cl.setRange(string3, (Subnetwork)this.parent);
            if (message != null) {
                message.setLocation(TEXT_RANGE);
                this.parentFrame.displayError(message);
                return false;
            }
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Component)this).setFont(font);
        this.setLayout(gridBagLayout);
        Label label = new Label(TEXT_CLASSNAME);
        this.rangeLabel = new Label(TEXT_RANGE);
        this.fromLabel = new Label(TEXT_FROM);
        this.toLabel = new Label(TEXT_TO);
        this.name = new TextFieldWithTab(16);
        this.rangeFrom = new IPAddressField();
        this.rangeTo = new IPAddressField();
        this.wildCardCb = new Checkbox(TEXT_WILDCARD);
        this.wildCardCb.setBackground(Color.lightGray);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        this.add(this.name);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.wildCardCb, gridBagConstraints);
        this.add(this.wildCardCb);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.rangeLabel, gridBagConstraints);
        this.add(this.rangeLabel);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.fromLabel, gridBagConstraints);
        this.add(this.fromLabel);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.rangeFrom, gridBagConstraints);
        this.add(this.rangeFrom);
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.toLabel, gridBagConstraints);
        this.add(this.toLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.rangeTo, gridBagConstraints);
        this.add(this.rangeTo);
    }
}

