/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.ClientInfoPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.LeaseAndCommentPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class ClientDefinitionPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_NAME = DHCPServerGUI.getResourceString("TEXT_NAME");
    private static final String TEXT_TITLE_LEASE_AND_COMMENT = DHCPServerGUI.getResourceString("TEXT_TITLE_LEASE_AND_COMMENT");
    private Font myTextFont;
    private Font myTitleFont;
    private boolean layoutCalled = false;
    private boolean firstTime = true;
    private BorderPanel clinfoBox;
    private BorderPanel leaseBox;
    private ClientInfoPanel clinfo = new ClientInfoPanel();
    private LeaseAndCommentPanel lease = new LeaseAndCommentPanel();
    private Client client = null;
    private NotebookFrame parentFrame = null;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.client = (Client)configItem;
        this.parentFrame = notebookFrame;
        this.clinfo.initializePanel(configItem, this.parentFrame);
        this.lease.initializePanel(configItem, this.parentFrame);
        this.myTextFont = this.parentFrame.getTextFont();
        this.myTitleFont = this.parentFrame.getTitleFont();
    }

    public void populatePanel() {
        if (!this.firstTime) {
            this.removeAndRebuildPanels();
        }
        this.clinfo.populatePanel();
        this.lease.populatePanel();
        if (!this.firstTime) {
            this.layoutPanel(this.myTextFont, this.myTitleFont);
        }
        this.firstTime = false;
    }

    private void removeAndRebuildPanels() {
        this.remove(this.clinfoBox);
        this.remove(this.leaseBox);
        this.clinfoBox = null;
        this.leaseBox = null;
        this.remove(this.clinfo);
        this.remove(this.lease);
        this.clinfo = null;
        this.lease = null;
        this.clinfo = new ClientInfoPanel();
        this.lease = new LeaseAndCommentPanel();
        this.clinfo.layoutPanel(this.myTextFont, this.myTitleFont);
        this.lease.layoutPanel(this.myTextFont, this.myTitleFont);
        this.clinfo.initializePanel(this.client, this.parentFrame);
        this.lease.initializePanel(this.client, this.parentFrame);
    }

    public boolean saveState() {
        return this.clinfo.saveState() && this.lease.saveState();
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Component)this).setFont(font);
        this.setLayout(gridBagLayout);
        int n = 0;
        if (!this.layoutCalled) {
            this.clinfo.layoutPanel(font, font2);
        }
        this.clinfoBox = new BorderPanel(TEXT_NAME);
        this.clinfoBox.setTextFont(font2);
        this.clinfoBox.setGap(n);
        this.clinfoBox.add(this.clinfo);
        if (!this.layoutCalled) {
            this.lease.layoutPanel(font, font2);
        }
        this.leaseBox = new BorderPanel(TEXT_TITLE_LEASE_AND_COMMENT);
        this.leaseBox.setTextFont(font2);
        this.leaseBox.setGap(n);
        this.leaseBox.add(this.lease);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.clinfoBox, gridBagConstraints);
        this.add(this.clinfoBox);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.leaseBox, gridBagConstraints);
        this.add(this.leaseBox);
        this.layoutCalled = true;
    }
}

