/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class CommentEntryPanel
extends NotebookPanel
implements ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_INSTRUCTIONS = DHCPServerGUI.getResourceString("TEXT_INSTRUCTIONS");
    private static final String TEXT_BUTTON_DELETE = DHCPServerGUI.getResourceString("TEXT_BUTTON_DELETE");
    private static final String TEXT_COMMENT_TITLE = DHCPServerGUI.getResourceString("TEXT_COMMENT_TITLE");
    private static final String TEXT_ENTER_DATA = DHCPServerGUI.getResourceString("TEXT_ENTER_DATA");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String LABEL_BLANK = "";
    private TextFieldWithTab commentTitle;
    private TextArea commentEntryField;
    private Button deleteButton;
    private String savedComment;
    private String savedTitle;
    private Comment curComment = null;
    private NotebookFrame parentFrame = null;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.curComment = (Comment)configItem;
        this.parentFrame = notebookFrame;
        this.commentEntryField.setText(this.curComment.getCommentText());
        ((TextComponent)this.commentTitle).setText(this.curComment.getTitle());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void populatePanel() {
        if (this.curComment != null) {
            String string = this.curComment.getCommentText();
            if (string != null) {
                this.commentEntryField.setText(string);
            }
            if ((string = this.curComment.getTitle()) != null) {
                ((TextComponent)this.commentTitle).setText(string);
            }
        }
    }

    public boolean saveState() {
        if (this.curComment == null) {
            throw new ShouldNotOccurException("CommentEntryPanel saveState(): no comment to save info in");
        }
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            this.parentFrame.setItemParent(this.parentFrame.getBINLGlobal());
        } else {
            this.parentFrame.setItemParent(this.parentFrame.getGlobal());
        }
        this.savedComment = this.commentEntryField.getText().trim();
        this.savedTitle = this.commentTitle.getText().trim();
        this.curComment.setCommentText(this.savedComment);
        this.curComment.setTitle(this.savedTitle);
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        ((Component)panel).setFont(font);
        panel.setLayout(new GridLayout(3, 1));
        panel.add(new Label(LABEL_BLANK));
        panel.add(new Label(TEXT_INSTRUCTIONS));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel(TEXT_COMMENT_TITLE);
        borderPanel.setTextFont(font2);
        borderPanel.setLayout(new GridLayout(1, 1));
        this.commentTitle = new TextFieldWithTab(25);
        borderPanel.add(this.commentTitle);
        BorderPanel borderPanel2 = new BorderPanel(TEXT_ENTER_DATA);
        borderPanel2.setLayout(new BorderLayout());
        borderPanel2.setTextFont(font2);
        this.commentEntryField = new TextArea(" ", 8, 80);
        this.commentEntryField.addKeyListener(this);
        borderPanel2.add("Center", this.commentEntryField);
        panel2.add("North", borderPanel);
        panel2.add("Center", borderPanel2);
        this.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout());
        this.deleteButton = new Button(TEXT_BUTTON_DELETE);
        this.deleteButton.setBackground(Color.lightGray);
        this.deleteButton.addActionListener(this);
        this.deleteButton.addKeyListener(this);
        panel3.add(this.deleteButton);
        this.add("South", panel3);
    }

    private void handleButton(Button button) {
        if (button == this.deleteButton) {
            this.savedComment = LABEL_BLANK;
            this.commentEntryField.setText(" ");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
        } else if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            TextArea textArea = (TextArea)object;
            textArea.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

