/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class IPAddressField
extends TextField
implements KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private boolean valid;
    private String fieldname;

    public IPAddressField() {
        super(16);
        super.setEditable(true);
        this.valid = false;
        this.addKeyListener(this);
    }

    public void setFieldName(String string) {
        if (string != null) {
            this.fieldname = string.trim();
            return;
        }
        this.fieldname = "";
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setText(String string) {
        if (string == null) {
            this.valid = false;
            super.setText("");
            return;
        }
        Message message = IPAddress.validateAddress(string.trim());
        if (message != null) {
            this.valid = false;
            super.setText("");
            return;
        }
        this.valid = true;
        super.setText(string.trim());
    }

    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\t') && this.validateField(this.getText().trim())) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private boolean validateField(String string) {
        if (!string.equals("")) {
            Message message = IPAddress.validateAddress(string);
            if (message != null) {
                message.setLocation(this.fieldname);
                this.valid = false;
                NotebookFrame notebookFrame = NotebookFrame.getNotebookFrame(this);
                notebookFrame.displayError(message);
                return false;
            }
            return true;
        }
        return true;
    }
}

