/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ImageServer;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class ImageServerPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_IMAGE_SERVER_LABEL = DHCPServerGUI.getResourceString("TEXT_IMAGE_SERVER_LABEL");
    private static final String TEXT_IMAGE_SERVER_GROUP_LABEL = DHCPServerGUI.getResourceString("TEXT_IMAGE_SERVER_GROUP_LABEL");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private ServerParameters cfgItem;
    private String imageServer;
    private TextField imageServerField;
    private Label imageServerLabel;
    private BorderPanel groupPanel;
    private Font theTextFont;
    private Font theTitleFont;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.setCfgItem((ServerParameters)configItem);
        this.setParentFrame(notebookFrame);
    }

    public void setCfgItem(ServerParameters serverParameters) {
        this.cfgItem = serverParameters;
    }

    public ConfigItem getCfgItem() {
        return this.cfgItem;
    }

    public void setParentFrame(NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
    }

    public NotebookFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setImageServer(String string) {
        this.imageServer = string;
    }

    public String getImageServer() {
        return this.imageServer;
    }

    public void populatePanel() {
        this.imageServer = this.cfgItem.getImageServer().getValue();
        ((TextComponent)this.imageServerField).setText(this.imageServer);
    }

    public boolean saveState() {
        ImageServer imageServer = this.cfgItem.getImageServer();
        this.setImageServer(this.imageServerField.getText());
        Message message = imageServer.setValue(this.getImageServer());
        if (message != null) {
            message.setLocation(TEXT_IMAGE_SERVER_GROUP_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    private void initComponents() {
        this.groupPanel = new BorderPanel(TEXT_IMAGE_SERVER_GROUP_LABEL);
        this.imageServerLabel = new Label(TEXT_IMAGE_SERVER_LABEL);
        this.imageServerField = new TextField(50);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.constrain(this.imageServerLabel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.add(this.imageServerLabel);
        this.constrain(this.imageServerField, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.add(this.imageServerField);
    }

    public void setEnabled(boolean bl) {
        this.imageServerLabel.setEnabled(bl);
        this.imageServerField.setEnabled(bl);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

