/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.NetworkInterfaceType2;
import COM.ibm.raleigh.dhcpsgui.biz.SystemArchitectureType;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class LSA2GroupDefinitionPanel
extends NotebookPanel
implements KeyListener,
ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_LSA2_GROUPNAME_LABEL = DHCPServerGUI.getResourceString("TEXT_LSA2_GROUPNAME_LABEL");
    private static final String TEXT_LSA2_GROUPNAME_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_LSA2_GROUPNAME_BOX_LABEL");
    private static final String TEXT_NETWORK_INTERFACE_LABEL = DHCPServerGUI.getResourceString("TEXT_NETWORK_INTERFACE_LABEL");
    private static final String TEXT_SYSTEM_ARCHITECTURE_LABEL = DHCPServerGUI.getResourceString("TEXT_SYSTEM_ARCHITECTURE_LABEL");
    private static final String TEXT_COMMENT = DHCPServerGUI.getResourceString("TEXT_COMMENT");
    private static final String TEXT_LSA2_GROUPTYPE_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_LSA2_GROUPTYPE_BOX_LABEL");
    private static final String TEXT_DUPLICATE_LSA2GROUP = DHCPServerGUI.getResourceString("TEXT_DUPLICATE_LSA2GROUP");
    private static final String TEXT_NOVALUES_LSA2GROUP = DHCPServerGUI.getResourceString("TEXT_NOVALUES_LSA2GROUP");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private WrappedTextPanel infoLabel;
    private TextField LSA2GroupNameField;
    private Label LSA2GroupNameLabel;
    private Panel LSA2GroupNamePanel;
    private Choice SAChoice;
    private Label SALabel;
    private Choice NITChoice;
    private Label NITLabel;
    private Font theTextFont;
    private Font theTitleFont;
    private TextArea comment;
    private Label commentLabel;
    private BorderPanel LSA2GroupTypePanel;
    private NetworkInterfaceType2 nitType = new NetworkInterfaceType2();
    private SystemArchitectureType saType = new SystemArchitectureType();
    private LSA2Group lsa2Group = null;
    private String nit = String.valueOf(-1);
    private String sa = String.valueOf(-1);
    private BINLGlobal glob;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
        this.lsa2Group = (LSA2Group)configItem;
        this.comment.setText("");
        this.nit = this.lsa2Group.getNit();
        this.sa = this.lsa2Group.getSa();
        this.glob = this.parentFrame.getBINLGlobal();
    }

    public void populatePanel() {
        if (this.lsa2Group.getAlias() != null) {
            ((TextComponent)this.LSA2GroupNameField).setText(this.lsa2Group.getAlias());
        } else {
            ((TextComponent)this.LSA2GroupNameField).setText("");
        }
        if (!this.lsa2Group.getNit().equals("-1")) {
            this.NITChoice.select(this.lsa2Group.getNitAsInt());
        } else {
            this.NITChoice.select(0);
        }
        if (!this.lsa2Group.getSa().equals("-1")) {
            this.SAChoice.select(this.lsa2Group.getSaAsInt() + 1);
        } else {
            this.SAChoice.select(0);
        }
        String string = this.lsa2Group.getComment();
        if (string != null) {
            this.comment.setText(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if ((Choice)itemEvent.getItemSelectable() == this.SAChoice) {
            int n = ((Choice)itemEvent.getItemSelectable()).getSelectedIndex();
            this.sa = String.valueOf(n - 1);
            return;
        }
        if ((Choice)itemEvent.getItemSelectable() == this.NITChoice) {
            int n = ((Choice)itemEvent.getItemSelectable()).getSelectedIndex();
            this.nit = String.valueOf(n);
        }
    }

    public boolean saveState() {
        LSA2Group lSA2Group;
        Message message = this.lsa2Group.setAlias(this.LSA2GroupNameField.getText());
        if (message != null) {
            message.setLocation(TEXT_LSA2_GROUPNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        if (this.nit.equals("-1") && this.sa.equals("-1") || this.nit.equals("0") && this.sa.equals("-1")) {
            message = new Message(TEXT_NOVALUES_LSA2GROUP);
            message.setLocation(String.valueOf(TEXT_NETWORK_INTERFACE_LABEL) + "/" + TEXT_SYSTEM_ARCHITECTURE_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        if (this.nit.equals("0")) {
            this.nit = "-1";
        }
        if ((lSA2Group = this.lsa2Group.getADuplicateLSA2Group(this.glob, this.nit, this.sa)) != null) {
            message = new Message(TEXT_DUPLICATE_LSA2GROUP);
            message.setLocation(String.valueOf(TEXT_NETWORK_INTERFACE_LABEL) + "/" + TEXT_SYSTEM_ARCHITECTURE_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.lsa2Group.setNit(this.nit);
        if (message != null) {
            message.setLocation(TEXT_LSA2_GROUPNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.lsa2Group.setSa(this.sa);
        if (message != null) {
            message.setLocation(TEXT_LSA2_GROUPNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        this.lsa2Group.setComment(this.comment.getText());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    private void initComponents() {
        this.infoLabel = new WrappedTextPanel(TEXT_LSA2_GROUPNAME_BOX_LABEL, 110);
        this.LSA2GroupNameField = new TextField(20);
        this.LSA2GroupNameLabel = new Label(TEXT_LSA2_GROUPNAME_LABEL);
        this.LSA2GroupNamePanel = new Panel();
        this.SAChoice = new Choice();
        this.SALabel = new Label(TEXT_SYSTEM_ARCHITECTURE_LABEL);
        this.NITChoice = new Choice();
        this.NITLabel = new Label(TEXT_NETWORK_INTERFACE_LABEL);
        this.comment = new TextArea("", 6, 50);
        this.commentLabel = new Label(TEXT_COMMENT);
        this.LSA2GroupTypePanel = new BorderPanel(TEXT_LSA2_GROUPTYPE_BOX_LABEL);
        this.comment.addKeyListener(this);
        this.NITChoice.addItemListener(this);
        this.SAChoice.addItemListener(this);
    }

    private void addComponentsToGrid() {
        String string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.infoLabel.getNumDividedTextLines();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.LSA2GroupNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.constrain(this.LSA2GroupNameLabel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.LSA2GroupNamePanel.add(this.LSA2GroupNameLabel);
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.constrain(this.LSA2GroupNameField, gridBagLayout, gridBagConstraints, 1, 0, 1, 1);
        this.LSA2GroupNamePanel.add(this.LSA2GroupNameField);
        this.LSA2GroupTypePanel.setLayout(gridBagLayout);
        ((Component)this.LSA2GroupTypePanel).setFont(this.theTextFont);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.constrain((Component)this.infoLabel, gridBagLayout, gridBagConstraints, 0, 0, 0, n);
        this.LSA2GroupTypePanel.add((Component)this.infoLabel);
        this.constrain(this.SALabel, gridBagLayout, gridBagConstraints, 0, 1 + n, 1, 1);
        this.LSA2GroupTypePanel.add(this.SALabel);
        this.constrain(this.SAChoice, gridBagLayout, gridBagConstraints, 1, 1 + n, 1, 1);
        this.LSA2GroupTypePanel.add(this.SAChoice);
        this.constrain(this.NITLabel, gridBagLayout, gridBagConstraints, 0, 2 + n, 1, 1);
        this.LSA2GroupTypePanel.add(this.NITLabel);
        this.constrain(this.NITChoice, gridBagLayout, gridBagConstraints, 1, 2 + n, 1, 1);
        this.LSA2GroupTypePanel.add(this.NITChoice);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        this.constrain(this.LSA2GroupTypePanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 1);
        this.LSA2GroupNamePanel.add(this.LSA2GroupTypePanel);
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.constrain(this.commentLabel, gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        this.LSA2GroupNamePanel.add(this.commentLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.constrain(this.comment, gridBagLayout, gridBagConstraints, -1, 2, 0, 1);
        this.LSA2GroupNamePanel.add(this.comment);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.LSA2GroupNamePanel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.add(this.LSA2GroupNamePanel);
        this.SAChoice.addItem("ANY");
        Vector vector = this.saType.getAllSATypes();
        int n2 = 0;
        while (n2 < SystemArchitectureType.numberOfSATypes) {
            string = "(" + n2 + ")  ";
            this.SAChoice.addItem(String.valueOf(string) + (String)vector.elementAt(n2));
            ++n2;
        }
        this.NITChoice.addItem("ANY");
        Vector vector2 = this.nitType.getAllNITTypes();
        n2 = 0;
        while (n2 < NetworkInterfaceType2.numberOfNITTypes) {
            string = "(" + (n2 + 1) + ")  ";
            this.NITChoice.addItem(String.valueOf(string) + (String)vector2.elementAt(n2));
            ++n2;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

