/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.awtExt.SpinButton;
import COM.ibm.raleigh.dhcpsgui.biz.TimeInterval;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class LeaseEntryPanel
extends Panel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_YEARS = DHCPServerGUI.getResourceString("TEXT_YEARS");
    private static final String TEXT_MONTHS = DHCPServerGUI.getResourceString("TEXT_MONTHS");
    private static final String TEXT_DAYS = DHCPServerGUI.getResourceString("TEXT_DAYS");
    private static final String TEXT_HOURS = DHCPServerGUI.getResourceString("TEXT_HOURS");
    private static final String TEXT_MINUTES = DHCPServerGUI.getResourceString("TEXT_MINUTES");
    private static final String TEXT_SECONDS = DHCPServerGUI.getResourceString("TEXT_SECONDS");
    private SpinButton inputYears;
    private SpinButton inputMonths;
    private SpinButton inputDays;
    private SpinButton inputHours;
    private SpinButton inputMinutes;
    private SpinButton inputSeconds;
    private TimeInterval timeValue = new TimeInterval();

    public LeaseEntryPanel() {
        this.layoutPanel();
    }

    public void populate(String string) {
        int[] nArray = new int[6];
        if (string.length() > 0) {
            String string2 = "(Y, M, D, H, MI, S = )";
            this.timeValue = new TimeInterval();
            this.timeValue.setTimeInterval(string);
            nArray = this.timeValue.getTimeInterval();
            int n = 0;
            while (n < 6) {
                string2 = String.valueOf(string2) + nArray[n] + " ";
                ++n;
            }
        }
        this.inputHours.setValue(nArray[3]);
        this.inputMinutes.setValue(nArray[4]);
        this.inputSeconds.setValue(nArray[5]);
        this.inputYears.setValue(nArray[0]);
        this.inputMonths.setValue(nArray[1]);
        this.inputDays.setValue(nArray[2]);
        this.validate();
    }

    public String getUserInput() {
        int[] nArray = new int[6];
        nArray[3] = this.inputHours.intValue();
        nArray[4] = this.inputMinutes.intValue();
        nArray[5] = this.inputSeconds.intValue();
        nArray[0] = this.inputYears.intValue();
        nArray[1] = this.inputMonths.intValue();
        nArray[2] = this.inputDays.intValue();
        this.timeValue.setTimeInterval(nArray);
        String string = Integer.toString(this.timeValue.getTotalSeconds());
        return string;
    }

    public void disableFields() {
        this.inputHours.setEnabled(false);
        this.inputMinutes.setEnabled(false);
        this.inputSeconds.setEnabled(false);
        this.inputDays.setEnabled(false);
        this.inputMonths.setEnabled(false);
        this.inputYears.setEnabled(false);
    }

    public void enableFields() {
        this.inputHours.setEnabled(true);
        this.inputMinutes.setEnabled(true);
        this.inputSeconds.setEnabled(true);
        this.inputDays.setEnabled(true);
        this.inputMonths.setEnabled(true);
        this.inputYears.setEnabled(true);
    }

    public void resetFields() {
        this.inputHours.setValue(0);
        this.inputMinutes.setValue(0);
        this.inputSeconds.setValue(0);
        this.inputYears.setValue(0);
        this.inputMonths.setValue(0);
        this.inputDays.setValue(0);
    }

    private void layoutPanel() {
        this.setLayout(new GridLayout(2, 6));
        this.add(new Label(TEXT_YEARS));
        this.add(new Label(TEXT_MONTHS));
        this.add(new Label(TEXT_DAYS));
        this.add(new Label(TEXT_HOURS));
        this.add(new Label(TEXT_MINUTES));
        this.add(new Label(TEXT_SECONDS));
        this.inputYears = new SpinButton(2, false);
        this.inputYears.setRange(0, 10);
        this.add(this.inputYears);
        this.inputMonths = new SpinButton(2, false);
        this.inputMonths.setRange(0, 11);
        this.add(this.inputMonths);
        this.inputDays = new SpinButton(2, false);
        this.inputDays.setRange(0, 30);
        this.add(this.inputDays);
        this.inputHours = new SpinButton(2, false);
        this.inputHours.setRange(0, 23);
        this.add(this.inputHours);
        this.inputMinutes = new SpinButton(2, false);
        this.inputMinutes.setRange(0, 59);
        this.add(this.inputMinutes);
        this.inputSeconds = new SpinButton(2, false);
        this.inputSeconds.setRange(0, 59);
        this.add(this.inputSeconds);
    }
}

