/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class NotebookButtonPanel
extends Panel
implements ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    String okLabel = DHCPServerGUI.getResourceString("TEXT_BUTTON_OK");
    String cancelLabel = DHCPServerGUI.getResourceString("TEXT_BUTTON_CANCEL");
    String helpLabel = DHCPServerGUI.getResourceString("TEXT_BUTTON_HELP");
    String blank;
    Button buttonOK;
    Button buttonCancel;
    Button buttonHelp;
    NotebookFrame parent;
    Panel rightside;
    Panel leftside;

    public NotebookButtonPanel(NotebookFrame notebookFrame, Font font) {
        this.parent = notebookFrame;
        this.layoutPanel(font);
    }

    public void setEnabled(boolean bl) {
        this.buttonOK.setEnabled(bl);
        this.buttonCancel.setEnabled(bl);
        this.buttonHelp.setEnabled(bl);
    }

    private void handleButton(Button button) {
        this.setEnabled(false);
        if (button == this.buttonOK) {
            this.parent.handleOK();
        } else if (button == this.buttonCancel) {
            this.parent.handleCancel();
        } else if (button == this.buttonHelp) {
            this.parent.handleHelp();
        }
        if (this.parent.isVisible()) {
            this.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void refresh(String string) {
        this.leftside.removeAll();
        this.leftside.add(new Label(string));
        this.leftside.validate();
    }

    public void refresh() {
        this.leftside.removeAll();
        this.leftside.add(new Label(this.blank));
        this.leftside.validate();
    }

    private void layoutPanel(Font font) {
        this.setLayout(new GridLayout(1, 2));
        ((Component)this).setFont(font);
        this.leftside = new Panel();
        this.leftside.setLayout(new FlowLayout(0));
        this.leftside.setBackground(Color.lightGray);
        this.leftside.add(new Label(this.blank));
        this.rightside = new Panel();
        this.rightside.setLayout(new FlowLayout(2));
        this.rightside.setBackground(Color.lightGray);
        this.buttonOK = new Button(this.okLabel);
        this.buttonOK.setBackground(Color.lightGray);
        this.buttonOK.addActionListener(this);
        this.buttonOK.addKeyListener(this);
        this.buttonCancel = new Button(this.cancelLabel);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.addKeyListener(this);
        this.buttonCancel.setBackground(Color.lightGray);
        this.buttonHelp = new Button(this.helpLabel);
        this.buttonHelp.addActionListener(this);
        this.buttonHelp.addKeyListener(this);
        this.buttonHelp.setBackground(Color.lightGray);
        this.rightside.add(this.buttonOK);
        this.rightside.add(this.buttonCancel);
        this.rightside.add(this.buttonHelp);
        this.add(this.leftside);
        this.add(this.rightside);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

