/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Validatable;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookButtonPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.HelpFrame;
import COM.ibm.raleigh.dhcpsgui.view.NotebookUser;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class NotebookFrame
extends Frame
implements TabViewEventListener {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_TITLE_ERROR_FRAME = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME");
    private static final String TEXT_NOTEBOOK_WARNING_BOILERPLATE = DHCPServerGUI.getResourceString("TEXT_NOTEBOOK_WARNING_BOILERPLATE");
    private static final String TEXT_NOTEBOOK_WARNING_BOILERPLATE_BINL = DHCPServerGUI.getResourceString("TEXT_NOTEBOOK_WARNING_BOILERPLATE_BINL");
    private static final String TEXT_NOTEBOOK_ERROR_BOILERPLATE = DHCPServerGUI.getResourceString("TEXT_NOTEBOOK_ERROR_BOILERPLATE");
    private static final String TEXT_TITLE_ERROR_FRAME_BINL = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME_BINL");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private NotebookButtonPanel notebookButtons;
    private FontsForCanvas ffcFont = new FontsForCanvas(textFont, titleFont);
    private ColorsForCanvas cfcColor = new ColorsForCanvas(Color.lightGray, Color.black, Color.black);
    protected ConfigItem item;
    protected ConfigItem originalItem;
    protected ConfigItem backupObject;
    protected ConfigItem parent;
    protected Configuration root;
    protected Global global;
    protected BINLGlobal binlGlobal;
    protected NotebookUser caller;
    protected TabView tabView;
    protected TabViewNode[] tabNodes;
    private int TAB_WIDTH;
    private int TAB_HEIGHT;
    private int BORDER_WIDTH;
    private int BORDER_HEIGHT;
    private static Font textFont = new Font("sansserif", 0, DDNSUtility.getCountryFontSize());
    private static Font titleFont = new Font("sansserif", 1, DDNSUtility.getCountryFontSize());
    private int nextPage;
    private int numberOfPages;
    private boolean somethingSaved = false;
    private boolean newItem;
    protected HelpFrame helpFrame = HelpFrame.getHelpFrame();
    protected String currentTabName;
    protected String helpInstructions;
    protected NotebookFrame frame = this;

    protected NotebookFrame(int n, int n2, int n3, int n4, int n5) {
        this.numberOfPages = n;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (n2 == 640 && n3 == 430 && dimension.width > 640 && dimension.height > 480) {
            this.TAB_HEIGHT = n3 + 100;
            this.TAB_WIDTH = n2 + 100;
        } else {
            this.TAB_HEIGHT = n3;
            this.TAB_WIDTH = n2;
        }
        this.BORDER_HEIGHT = 0;
        this.BORDER_WIDTH = 0;
        this.tabNodes = new TabViewNode[n];
        this.helpInstructions = this.helpFrame.getInstructions();
        this.notebookButtons = new NotebookButtonPanel(this, titleFont);
        this.addWindowListener(new 1());
    }

    public boolean initializeNotebook(ConfigItem configItem, ConfigItem configItem2, Configuration configuration, Global global, NotebookUser notebookUser, boolean bl) {
        this.parent = configItem;
        this.item = configItem2;
        this.originalItem = configItem2;
        this.root = configuration;
        this.global = global;
        this.caller = notebookUser;
        this.somethingSaved = false;
        this.newItem = bl;
        if (!bl) {
            this.backupItem();
        }
        int n = 0;
        while (n < this.numberOfPages) {
            ((NotebookPanel)this.tabNodes[n].getPanel()).initializePanel(this.item, this);
            ((NotebookPanel)this.tabNodes[n].getPanel()).populatePanel();
            ++n;
        }
        this.tabView.committ();
        this.currentTabName = this.tabNodes[0].getText();
        ((Component)this).setLocation(25, 1);
        this.pack();
        this.notebookButtons.setEnabled(true);
        return true;
    }

    public boolean initializeNotebook(ConfigItem configItem, ConfigItem configItem2, Configuration configuration, BINLGlobal bINLGlobal, NotebookUser notebookUser, boolean bl) {
        this.parent = configItem;
        this.item = configItem2;
        this.originalItem = configItem2;
        this.root = configuration;
        this.binlGlobal = bINLGlobal;
        this.caller = notebookUser;
        this.somethingSaved = false;
        this.newItem = bl;
        if (!bl) {
            this.backupItem();
        }
        int n = 0;
        while (n < this.numberOfPages) {
            ((NotebookPanel)this.tabNodes[n].getPanel()).initializePanel(this.item, this);
            ((NotebookPanel)this.tabNodes[n].getPanel()).populatePanel();
            ++n;
        }
        this.tabView.committ();
        this.currentTabName = this.tabNodes[0].getText();
        ((Component)this).setLocation(25, 1);
        this.pack();
        this.notebookButtons.setEnabled(true);
        return true;
    }

    public void backupItem() {
        this.backupObject = (ConfigItem)this.originalItem.replacementClone();
    }

    public void restoreItem() {
    }

    protected TabViewNode createTabNode(NotebookPanel notebookPanel, String string) {
        TabViewNode tabViewNode = new TabViewNode();
        tabViewNode.setColors(this.cfcColor);
        tabViewNode.setFonts(this.ffcFont);
        tabViewNode.setImage(null);
        tabViewNode.setText(string);
        tabViewNode.setPanel((Panel)notebookPanel);
        return tabViewNode;
    }

    protected void addPage(NotebookPanel notebookPanel, String string) {
        this.tabNodes[this.nextPage] = this.createTabNode(notebookPanel, string);
        ++this.nextPage;
    }

    protected void addPage(NotebookPanel notebookPanel, String string, int n) {
        this.tabView.removeAllTabs();
        this.tabNodes[n - 1] = this.createTabNode(notebookPanel, string);
        int n2 = 0;
        while (n2 < this.numberOfPages) {
            this.tabView.addTab(this.tabNodes[n2]);
            ++n2;
        }
    }

    protected void removePage(int n) {
        if (this.tabNodes[n - 1] != null) {
            this.tabView.removeTab(this.tabNodes[n - 1]);
            this.tabNodes[n - 1] = null;
        }
    }

    protected TabViewNode getPage(int n) {
        return this.tabNodes[n - 1];
    }

    public boolean handleOK() {
        Object object;
        boolean bl = true;
        int n = 0;
        while (n < this.tabNodes.length) {
            this.somethingSaved = true;
            if (!((NotebookPanel)this.tabNodes[n].getPanel()).saveState()) {
                this.tabView.selectTab(this.tabNodes[n]);
                return false;
            }
            ++n;
        }
        if (this.item instanceof Validatable && (object = ((Validatable)((Object)this.item)).validate()) != null) {
            ErrorFrame.getValidationWarningFrame(this).show((Message)object);
        }
        object = this.originalItem.getParent() != null ? this.item.getParent() : this.parent;
        if (this.item instanceof DHCPClass) {
            ((DHCPClass)this.item).getClassName();
            if (((DHCPClass)this.item).isThisDuplicate((ConfigItem)object)) {
                ErrorFrame.getValidationWarningFrame(this).show(new Message("Duplicate class Name under the same scope!!"));
                return false;
            }
        }
        if (bl = this.originalItem.getParent() != null ? this.item.commit(this.item.getParent()) : this.item.commit(this.parent)) {
            this.caller.closeNotebook((Frame)this, true);
        }
        return true;
    }

    public void handleCancel() {
        this.restoreItem();
        if (this.somethingSaved && !this.newItem && this.backupObject != null) {
            if (this.backupObject instanceof ConfigItemWithExcludedAddresses) {
                Enumeration enumeration = this.backupObject.getChildren();
                while (enumeration.hasMoreElements()) {
                    ConfigItem configItem = (ConfigItem)enumeration.nextElement();
                    configItem.commit(this.backupObject);
                }
            }
            this.caller.closeNotebook((Frame)this, this.backupObject);
            return;
        }
        this.caller.closeNotebook((Frame)this, false);
    }

    public abstract void handleHelp();

    void processTabSwitch(Object object) {
        this.currentTabName = this.getCurrentTabName();
        this.clearBanner();
    }

    public void setupNotebook(String string) {
        this.setTitle(string);
        this.tabView = new TabView(new Point(50, 50), new Dimension(this.TAB_WIDTH, this.TAB_HEIGHT), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.add("South", this.notebookButtons);
        this.add("Center", (Component)this.tabView);
        int n = 0;
        while (n < this.numberOfPages) {
            ((NotebookPanel)this.tabNodes[n].getPanel()).layoutPanel(textFont, titleFont);
            this.tabView.addTab(this.tabNodes[n]);
            this.tabNodes[n].getPanel().setBackground(Color.lightGray);
            ++n;
        }
        this.tabView.committ();
        ((Component)this).setLocation(25, 1);
        this.pack();
        ((Component)this).setBackground(Color.lightGray);
        this.notebookButtons.setBackground(Color.lightGray);
    }

    public void setBanner(String string) {
        this.notebookButtons.refresh(string);
    }

    public void clearBanner() {
        this.notebookButtons.refresh();
    }

    public Global getGlobal() {
        return this.global;
    }

    public BINLGlobal getBINLGlobal() {
        return this.binlGlobal;
    }

    public Configuration getRoot() {
        return this.root;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public void setItemParent(ConfigItem configItem) {
        this.parent = configItem;
    }

    public ConfigItem getItemParent() {
        return this.parent;
    }

    public String getCurrentTabName() {
        return this.tabView.getSelectedTab().getText();
    }

    protected void somethingChanged() {
        this.somethingSaved = true;
    }

    public void displayError(Message message) {
        ErrorFrame errorFrame = ErrorFrame.getNotebookErrorFrame(this);
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME_BINL, TEXT_NOTEBOOK_ERROR_BOILERPLATE, new Vector());
        } else {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME, TEXT_NOTEBOOK_ERROR_BOILERPLATE, new Vector());
        }
        errorFrame.show(null, message);
    }

    public void displayWarning(Message message) {
        ErrorFrame errorFrame = ErrorFrame.getNotebookWarningFrame(this);
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME_BINL, TEXT_NOTEBOOK_WARNING_BOILERPLATE_BINL, new Vector());
        } else {
            errorFrame.initialize(TEXT_TITLE_ERROR_FRAME, TEXT_NOTEBOOK_WARNING_BOILERPLATE, new Vector());
        }
        errorFrame.show(null, message);
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        ((NotebookPanel)tabViewNode.getPanel()).postTabSelected();
        this.processTabSwitch(tabView);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.handleCancel();
    }

    public void open() {
        this.addWindowListener(new 2());
    }

    public static NotebookFrame getNotebookFrame(Component component) {
        while (!(component instanceof NotebookFrame)) {
            component = component.getParent();
        }
        try {
            return (NotebookFrame)component;
        }
        catch (Exception exception) {
            System.out.println(exception);
            throw new ShouldNotOccurException("NotebookFrame not in the container hierarchy");
        }
    }

    public Font getTextFont() {
        return textFont;
    }

    public Font getTitleFont() {
        return titleFont;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            NotebookFrame.this.handleCancel();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            NotebookFrame.this.tabView.selectTab(NotebookFrame.this.tabNodes[0]);
            NotebookFrame.this.frame.removeWindowListener(this);
        }

        /* synthetic */ 2() {
        }
    }
}

