/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.SelectedList;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class OrderPanel
extends NotebookPanel
implements ActionListener,
ItemListener,
KeyListener {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_SUBNET_GROUP_CHOOSE_POOL_ORDER = DHCPServerGUI.getResourceString("TEXT_SUBNET_GROUP_CHOOSE_POOL_ORDER");
    private static final String TEXT_MOVE_UP = DHCPServerGUI.getResourceString("TEXT_MOVE_UP");
    private static final String TEXT_MOVE_DOWN = DHCPServerGUI.getResourceString("TEXT_MOVE_DOWN");
    private SubnetGroup subnetGroup;
    SelectedList orderList;
    Button buttonMoveUp;
    Button buttonMoveDown;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();

    OrderPanel(SelectedList selectedList) {
        this.orderList = selectedList;
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        super.initializePanel(configItem, notebookFrame);
        this.subnetGroup = (SubnetGroup)configItem;
    }

    public void populatePanel() {
        this.buttonMoveUp.setEnabled(false);
        this.buttonMoveDown.setEnabled(false);
    }

    public boolean saveState() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.orderList) {
            this.buttonMoveUp.setEnabled(true);
            this.buttonMoveDown.setEnabled(true);
        }
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        this.setLayout(this.gbl);
        this.buttonMoveUp = new Button(TEXT_MOVE_UP);
        this.buttonMoveUp.addActionListener(this);
        this.buttonMoveUp.addKeyListener(this);
        this.buttonMoveUp.setBackground(Color.lightGray);
        this.buttonMoveDown = new Button(TEXT_MOVE_DOWN);
        this.buttonMoveDown.addActionListener(this);
        this.buttonMoveDown.addKeyListener(this);
        this.buttonMoveDown.setBackground(Color.lightGray);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.add(new Label(TEXT_SUBNET_GROUP_CHOOSE_POOL_ORDER), this.gbl, this.gbc, 0, 0, 0, 1);
        this.gbc.fill = 0;
        this.gbc.anchor = 15;
        this.add(this.buttonMoveUp, this.gbl, this.gbc, 3, 1, 0, 1);
        this.gbc.anchor = 11;
        this.add(this.buttonMoveDown, this.gbl, this.gbc, 3, 2, 0, 1);
    }

    void tabSelected() {
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.add(this.orderList, this.gbl, this.gbc, 0, 1, 3, 2);
        this.orderList.addItemListener(this);
    }

    void tabDeselected() {
        if (this.isAncestorOf(this.orderList)) {
            this.remove(this.orderList);
            this.orderList.removeItemListener(this);
        }
    }

    private void handleButton(Button button) {
        if (button == this.buttonMoveUp) {
            this.orderList.moveUp();
            return;
        }
        if (button == this.buttonMoveDown) {
            this.orderList.moveDown();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

