/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.AvailableList;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.SelectedList;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

class SelectPanel
extends NotebookPanel
implements ItemListener,
KeyListener,
ActionListener {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_SUBNET_GROUP_AVAIL_POOLS = DHCPServerGUI.getResourceString("TEXT_SUBNET_GROUP_AVAIL_POOLS");
    private static final String TEXT_SUBNET_GROUP_SELECTED_POOLS = DHCPServerGUI.getResourceString("TEXT_SUBNET_GROUP_SELECTED_POOLS");
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    AvailableList availableList;
    SelectedList selectedList;
    Vector available;
    Button buttonAdd;
    Button buttonRemove;
    SubnetGroup subnetGroup;

    public SelectPanel(SelectedList selectedList) {
        this.selectedList = selectedList;
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        this.setLayout(this.gbl);
        String string = TEXT_SUBNET_GROUP_AVAIL_POOLS;
        String string2 = TEXT_SUBNET_GROUP_SELECTED_POOLS;
        Label label = new Label(string);
        Label label2 = new Label(string2);
        this.availableList = new AvailableList(5);
        this.availableList.addItemListener(this);
        String string3 = String.valueOf(TEXT_BUTTON_ADD) + " >>>";
        String string4 = "<<< " + TEXT_BUTTON_REMOVE;
        this.buttonAdd = new Button(string3);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        this.buttonAdd.setBackground(Color.lightGray);
        this.buttonRemove = new Button(string4);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        this.buttonRemove.setBackground(Color.lightGray);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.add(label, this.gbl, this.gbc, 0, 0, 1, 1);
        this.gbc.anchor = 12;
        this.add(label2, this.gbl, this.gbc, 3, 0, 2, 1);
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.add(this.availableList, this.gbl, this.gbc, 0, 1, 2, 2);
        this.gbc.fill = 0;
        this.gbc.anchor = 15;
        this.add(this.buttonAdd, this.gbl, this.gbc, -1, 1, 1, 1);
        this.gbc.fill = 0;
        this.gbc.anchor = 11;
        this.add(this.buttonRemove, this.gbl, this.gbc, 2, 2, 1, 1);
    }

    protected void tabSelected() {
        this.gbc.anchor = 12;
        this.gbc.fill = 1;
        this.add(this.selectedList, this.gbl, this.gbc, 3, 1, 2, 2);
        this.selectedList.addItemListener(this);
    }

    protected void tabDeselected() {
        this.remove(this.selectedList);
        this.selectedList.removeItemListener(this);
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        super.initializePanel(configItem, notebookFrame);
        this.subnetGroup = (SubnetGroup)configItem;
    }

    public void populatePanel() {
        this.availableList.populate(this.callingNotebook.getRoot(), this.subnetGroup);
        this.buttonAdd.setEnabled(false);
        this.buttonRemove.setEnabled(false);
    }

    public boolean saveState() {
        return this.selectedList.saveState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    private void handleButton(Button button) {
        Subnetwork subnetwork;
        if (button == this.buttonAdd) {
            Subnetwork subnetwork2 = this.availableList.remove();
            if (subnetwork2 != null) {
                this.selectedList.add(subnetwork2);
                return;
            }
        } else if (button == this.buttonRemove && (subnetwork = this.selectedList.remove()) != null) {
            this.availableList.add(subnetwork);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.availableList) {
            this.buttonAdd.setEnabled(true);
            return;
        }
        if (itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.selectedList) {
            this.buttonRemove.setEnabled(true);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

