/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import java.awt.List;
import java.util.Vector;

public class SelectedList
extends List {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    Vector selected;
    Configuration conf;
    SubnetGroup group;

    SelectedList(int n) {
        super(n, false);
    }

    void populate(Configuration configuration, SubnetGroup subnetGroup) {
        this.group = subnetGroup;
        this.conf = configuration;
        this.removeAll();
        this.selected = subnetGroup.getSubnets();
        int n = 0;
        while (n < this.selected.size()) {
            this.addItem(((Subnetwork)this.selected.elementAt(n)).getName());
            ++n;
        }
    }

    boolean saveState() {
        return this.group.replaceSubnetworks(this.selected);
    }

    Subnetwork remove() {
        int n = this.getSelectedIndex();
        if (n != -1) {
            Subnetwork subnetwork = (Subnetwork)this.selected.elementAt(n);
            this.delItem(n);
            this.selected.removeElementAt(n);
            return subnetwork;
        }
        return null;
    }

    void add(Subnetwork subnetwork) {
        int n = this.getItemCount();
        this.insertAt(subnetwork, n);
    }

    void insertAt(Subnetwork subnetwork, int n) {
        this.addItem(subnetwork.getName(), n);
        this.selected.insertElementAt(subnetwork, n);
    }

    void moveUp() {
        Subnetwork subnetwork;
        int n = this.getSelectedIndex();
        if (n >= 1 && (subnetwork = this.remove()) != null) {
            this.insertAt(subnetwork, n - 1);
            this.select(n - 1);
        }
    }

    void moveDown() {
        Subnetwork subnetwork;
        int n = this.getSelectedIndex();
        if (n != -1 && n < this.getItemCount() - 1 && (subnetwork = this.remove()) != null) {
            this.insertAt(subnetwork, n + 1);
            this.select(n + 1);
        }
    }
}

