/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.BootImage;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.TFTPServer;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class TFTPParametersPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_TFTP_SERVER_LABEL = DHCPServerGUI.getResourceString("TEXT_TFTP_SERVER_LABEL");
    private static final String TEXT_TFTP_SERVER_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_TFTP_SERVER_BOX_LABEL");
    private static final String TEXT_BOOT_IMAGE_LABEL = DHCPServerGUI.getResourceString("TEXT_BOOT_IMAGE_LABEL");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private TextField tftpServerField;
    private Label tftpServerLabel;
    private Panel tftpServerPanel;
    private TextField bootImageField;
    private Label bootImageLabel;
    private WrappedTextPanel infoLabel;
    private Font theTextFont;
    private Font theTitleFont;
    private ConfigItem cfgItem;
    private ConfigItem parentItem;
    private String tftpServer;
    private String bootImage;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
        this.cfgItem = configItem;
        this.parentItem = this.cfgItem.getParent();
        if (this.parentItem == null) {
            this.parentItem = this.parentFrame.getItemParent();
        }
    }

    public void populatePanel() {
        TFTPServer tFTPServer = (TFTPServer)this.cfgItem.getKeyword("tftp");
        TFTPServer tFTPServer2 = (TFTPServer)this.parentItem.getApplicableKeyword("tftp");
        this.tftpServer = tFTPServer != null ? tFTPServer.getValue() : (tFTPServer2 != null ? tFTPServer2.getValue() : "");
        ((TextComponent)this.tftpServerField).setText(this.tftpServer);
        BootImage bootImage = (BootImage)this.cfgItem.getKeyword("bpname");
        BootImage bootImage2 = (BootImage)this.parentItem.getApplicableKeyword("bpname");
        this.bootImage = bootImage != null ? bootImage.getValue() : (bootImage2 != null ? bootImage2.getValue() : "");
        ((TextComponent)this.bootImageField).setText(this.bootImage);
    }

    public void setTFTPServer(String string) {
        this.tftpServer = string;
    }

    public String getTFTPServer() {
        return this.tftpServer;
    }

    public void setBootImage(String string) {
        this.bootImage = string;
    }

    public String getBootImage() {
        return this.bootImage;
    }

    public boolean saveState() {
        String string = this.tftpServerField.getText();
        Message message = this.cfgItem.setTFTPServer(string);
        if (message != null) {
            message.setLocation(TEXT_TFTP_SERVER_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        string = this.bootImageField.getText();
        message = this.cfgItem.setBootImage(string);
        if (message != null) {
            message.setLocation(TEXT_BOOT_IMAGE_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    private void initComponents() {
        this.tftpServerField = new TextField(50);
        this.tftpServerLabel = new Label(TEXT_TFTP_SERVER_LABEL);
        this.tftpServerPanel = new Panel();
        this.bootImageField = new TextField(50);
        this.bootImageLabel = new Label(TEXT_BOOT_IMAGE_LABEL);
        this.infoLabel = new WrappedTextPanel(TEXT_TFTP_SERVER_BOX_LABEL, 110);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.infoLabel.getNumDividedTextLines();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tftpServerPanel.setLayout(gridBagLayout);
        this.constrain((Component)this.infoLabel, gridBagLayout, gridBagConstraints, 0, 0, 0, n);
        this.tftpServerPanel.add((Component)this.infoLabel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.constrain(this.tftpServerLabel, gridBagLayout, gridBagConstraints, 0, 1 + n, 1, 1);
        this.tftpServerPanel.add(this.tftpServerLabel);
        this.constrain(this.tftpServerField, gridBagLayout, gridBagConstraints, 1, 1 + n, 1, 1);
        this.tftpServerPanel.add(this.tftpServerField);
        this.constrain(this.bootImageLabel, gridBagLayout, gridBagConstraints, 0, 2 + n, 1, 1);
        this.tftpServerPanel.add(this.bootImageLabel);
        this.constrain(this.bootImageField, gridBagLayout, gridBagConstraints, 1, 2 + n, 1, 1);
        this.tftpServerPanel.add(this.bootImageField);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.tftpServerPanel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.add(this.tftpServerPanel);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

