/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.awtExt.MultiLineLabel;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.ServerParametersNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.VendorInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import COM.ibm.raleigh.utilExt.SortedHashtable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class VendorOptionsPanel
extends NotebookPanel
implements ErrorReporter,
ItemListener,
ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_VENDOR_INSTRUCTIONS1 = DHCPServerGUI.getResourceString("TEXT_VENDOR_INSTRUCTIONS1");
    private static final String TEXT_VENDOR_INSTRUCTIONS2 = DHCPServerGUI.getResourceString("TEXT_VENDOR_INSTRUCTIONS2");
    private static final String TEXT_VENDOR_ALTERNATE_INSTRUCTIONS1 = DHCPServerGUI.getResourceString("TEXT_VENDOR_ALTERNATE_INSTRUCTIONS1");
    private static final String TEXT_VENDOR_ALTERNATE_INSTRUCTIONS2 = DHCPServerGUI.getResourceString("TEXT_VENDOR_ALTERNATE_INSTRUCTIONS2");
    private static final String TEXT_VENDOR_LABEL_OPTIONS_FOR = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_OPTIONS_FOR");
    private static final String TEXT_VENDOR_LABEL_OPTIONS_FOR_NULL = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_OPTIONS_FOR_NULL");
    private static final String TEXT_VENDOR_LABEL_AVAILABLE_OPTIONS = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_AVAILABLE_OPTIONS");
    private static final String TEXT_VENDOR_BOX_ENTER_VENDOR_NAME = DHCPServerGUI.getResourceString("TEXT_VENDOR_BOX_ENTER_VENDOR_NAME");
    private static final String TEXT_VENDOR_LABEL_ENTER_VENDOR_NAME = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_ENTER_VENDOR_NAME");
    private static final String TEXT_VENDOR_BOX_LABEL_ENTER_DATA = DHCPServerGUI.getResourceString("TEXT_VENDOR_BOX_LABEL_ENTER_DATA");
    private static final String TEXT_VENDOR_LABEL_ADD_OPTIONS = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_ADD_OPTIONS");
    private static final String TEXT_VENDOR_LABEL_START_NEW = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_START_NEW");
    private static final String TEXT_VENDOR_LABEL_CANCEL = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_CANCEL");
    private static final String TEXT_VENDOR_LOCATION_VENDOR_ENTRY = DHCPServerGUI.getResourceString("TEXT_VENDOR_LOCATION_VENDOR_ENTRY");
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private static final String TEXT_VENDOR_VENDOR_NAME_FIELD = DHCPServerGUI.getResourceString("TEXT_VENDOR_VENDOR_NAME_FIELD");
    private static final String TEXT_VENDOR_UNENCAPSULATED = DHCPServerGUI.getResourceString("TEXT_VENDOR_UNENCAPSULATED");
    private static final String TEXT_VENDOR_ENCAPSULATED = DHCPServerGUI.getResourceString("TEXT_VENDOR_ENCAPSULATED");
    private static final String TEXT_VENDOR_HEX_INSTRUCTIONS1 = DHCPServerGUI.getResourceString("TEXT_VENDOR_HEX_INSTRUCTIONS1");
    private static final String TEXT_VENDOR_HEX_INSTRUCTIONS2 = DHCPServerGUI.getResourceString("TEXT_VENDOR_HEX_INSTRUCTIONS2");
    private static final String ERROR_DUPLICATE_NAME = DHCPServerGUI.getResourceString("ERROR_DUPLICATE_NAME");
    private static final String ERROR_DUPLICATE_NAME_ACTION = DHCPServerGUI.getResourceString("ERROR_DUPLICATE_NAME_ACTION");
    private static final String TEXT_TITLE_ERROR_FRAME = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME");
    private static final String TEXT_BUTTON_LABEL_HEX = DHCPServerGUI.getResourceString("TEXT_BUTTON_LABEL_HEX");
    private static final String TEXT_BUTTON_LABEL_TEXT = DHCPServerGUI.getResourceString("TEXT_BUTTON_LABEL_TEXT");
    private static final String TEXT_ERROR_VENDOR_PXECLIENT = DHCPServerGUI.getResourceString("TEXT_ERROR_VENDOR_PXECLIENT");
    private static final String LABEL_BLANK = "";
    Checkbox hexbutton;
    Checkbox asciibutton;
    CheckboxGroup format;
    String hexlabel = String.valueOf(TEXT_VENDOR_HEX_INSTRUCTIONS1) + "  " + TEXT_VENDOR_HEX_INSTRUCTIONS2;
    String asciilabel;
    MultiLineLabel instructions;
    private Vendor curVendor;
    private Vendor duplicateVendor;
    private VendorOption curOption;
    private Global glob;
    private SortedHashtable currentOptionSet;
    private int listIndex;
    private Message dupMsg;
    private TextField vendorName;
    private List availableOptions;
    private Label availableOptionsLabel;
    private Button buttonAdd;
    private Button buttonRemove;
    private VendorInputPanel valueSpecs;
    private BorderPanel rightTopPanel;
    private BorderPanel valueBox;
    private BorderPanel nameBox;
    private OptionInputPanel currentInputPanel;
    private NotebookFrame parentFrame;
    private Vector recoveryOptions = new Vector();
    private ErrorFrame dupVendorErrorFrame;
    private boolean resetList = true;

    public VendorOptionsPanel(NotebookFrame notebookFrame) {
        this.recoveryOptions.addElement(TEXT_VENDOR_LABEL_ADD_OPTIONS);
        this.recoveryOptions.addElement(TEXT_VENDOR_LABEL_START_NEW);
        this.recoveryOptions.addElement(TEXT_VENDOR_LABEL_CANCEL);
        Object[] objectArray = new Object[]{"vendor"};
        this.dupMsg = new Message(MessageFormat.format(ERROR_DUPLICATE_NAME, objectArray));
        this.dupMsg.setLocation(TEXT_VENDOR_VENDOR_NAME_FIELD);
        this.parentFrame = notebookFrame;
        this.dupVendorErrorFrame = new ErrorFrame(notebookFrame);
        this.dupVendorErrorFrame.initialize(TEXT_TITLE_ERROR_FRAME, " ", this.recoveryOptions);
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.currentOptionSet = new SortedHashtable();
        this.resetList = true;
        this.curVendor = (Vendor)configItem;
        this.glob = this.parentFrame.getGlobal();
        this.duplicateVendor = null;
    }

    public void populatePanel() {
        Enumeration enumeration;
        String string;
        if (this.resetList) {
            this.valueSpecs.resetFields();
        }
        if (this.curVendor == null) {
            throw new ShouldNotOccurException("Vendor Options Panel: populatePanel() failed -- no curVendor");
        }
        String string2 = this.curVendor.getName();
        if (string2 != null && string2.length() > 0) {
            string = this.curVendor.getItemType();
            int n = string2.indexOf(string);
            if (n >= 0) {
                string2 = string2.substring(n + string.length());
            }
            ((TextComponent)this.vendorName).setText(string2);
        }
        if (this.resetList) {
            this.currentOptionSet.clear();
            enumeration = this.curVendor.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.VendorOption", false);
        } else {
            enumeration = this.duplicateVendor.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.VendorOption", false);
        }
        while (enumeration.hasMoreElements()) {
            VendorOption vendorOption = (VendorOption)enumeration.nextElement();
            string = vendorOption.getTag();
            if (this.currentOptionSet.containsKey(string)) continue;
            this.currentOptionSet.put(string, vendorOption);
        }
        if (this.resetList) {
            if (!this.curVendor.isEncapsulatedFormat()) {
                this.setupUnencapsulatedFormat();
                this.format.setSelectedCheckbox(this.hexbutton);
                this.valueSpecs.format.select(TEXT_BUTTON_LABEL_HEX);
            } else {
                this.setupEncapsulatedFormat();
                this.format.setSelectedCheckbox(this.asciibutton);
                this.valueSpecs.format.select(TEXT_BUTTON_LABEL_TEXT);
            }
        }
        this.updateList();
    }

    public boolean saveState() {
        Message message = null;
        if (this.curVendor == null) {
            throw new ShouldNotOccurException("Vendor Options Panel: saveState() failed -- no biz object to save state into.");
        }
        String string = this.vendorName.getText().trim();
        if (string.equalsIgnoreCase("PXEClient")) {
            message = new Message(TEXT_ERROR_VENDOR_PXECLIENT);
            message.setLocation(TEXT_VENDOR_VENDOR_NAME_FIELD);
            this.parentFrame.displayError(message);
            return false;
        }
        this.curVendor.getItemType();
        message = this.curVendor.setName(string);
        if (message != null) {
            message.setLocation(TEXT_VENDOR_VENDOR_NAME_FIELD);
            this.parentFrame.displayError(message);
            return false;
        }
        this.duplicateVendor = this.curVendor.getADuplicateVendor(this.glob);
        if (this.duplicateVendor != null) {
            if (this.curVendor.isEncapsulatedFormat() && this.duplicateVendor.isEncapsulatedFormat()) {
                this.dupVendorErrorFrame.show(this, this.dupMsg);
                return false;
            }
            Object[] objectArray = new Object[]{"vendor"};
            message = new Message(String.valueOf(MessageFormat.format(ERROR_DUPLICATE_NAME, objectArray)) + MessageFormat.format(ERROR_DUPLICATE_NAME_ACTION, objectArray));
            message.setLocation(TEXT_VENDOR_VENDOR_NAME_FIELD);
            this.parentFrame.displayError(message);
            return false;
        }
        if (!this.curVendor.isEncapsulatedFormat()) {
            message = this.curVendor.setHexStringAndValidate(this.valueSpecs.inputValue.getText(), false);
            if (message != null) {
                message.setLocation(TEXT_VENDOR_LOCATION_VENDOR_ENTRY);
                this.parentFrame.displayError(message);
                return false;
            }
        } else {
            if (!this.saveEnteredData()) {
                return false;
            }
            Enumeration enumeration = this.currentOptionSet.elements();
            while (enumeration.hasMoreElements()) {
                VendorOption vendorOption = (VendorOption)enumeration.nextElement();
                if (vendorOption.commit(this.curVendor)) continue;
                message = new Message(ConfigItem.ERROR_WRONG_SCOPE);
                message.setLocation(TEXT_VENDOR_LOCATION_VENDOR_ENTRY);
                this.parentFrame.displayError(message);
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            this.handleButton((Button)actionEvent.getSource());
        }
    }

    private void handleButton(Button button) {
        if (button == this.buttonRemove) {
            if (this.curOption == null) {
                return;
            }
            String string = this.curOption.getTag();
            if (this.curOption.getParent() != null) {
                this.curOption.getParent().deleteChild(this.curOption);
            }
            this.currentOptionSet.remove(string);
            this.valueSpecs.resetFields();
            this.updateList();
            this.parentFrame.somethingChanged();
            return;
        }
        if (button == this.buttonAdd) {
            this.saveEnteredData();
            this.updateList();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.availableOptions) {
            if (itemEvent.getStateChange() == 1) {
                this.populateInputFields();
                return;
            }
        } else {
            this.handleCheckbox((Checkbox)itemEvent.getSource());
        }
    }

    private void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.asciibutton) {
            if (!this.curVendor.isEncapsulatedFormat()) {
                this.setupEncapsulatedFormat();
                this.parentFrame.somethingChanged();
                return;
            }
        } else if (checkbox == this.hexbutton && this.curVendor.isEncapsulatedFormat()) {
            this.setupUnencapsulatedFormat();
            this.parentFrame.somethingChanged();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
            }
            if (object instanceof Checkbox) {
                ((Checkbox)object).setState(!((Checkbox)object).getState());
                this.handleCheckbox((Checkbox)object);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void takeErrorAction(String string) {
        ((Component)this.dupVendorErrorFrame).setVisible(false);
        if (string.equals(TEXT_VENDOR_LABEL_ADD_OPTIONS)) {
            this.resetList = false;
            this.populatePanel();
            ((TextComponent)this.vendorName).setText(this.duplicateVendor.getVendorName());
            this.duplicateVendor.replaceItem(this.curVendor);
            return;
        }
        if (string.equals(TEXT_VENDOR_LABEL_START_NEW)) {
            this.duplicateVendor.replaceItem(this.curVendor);
            this.parentFrame.handleOK();
            return;
        }
        if (string.equals(TEXT_VENDOR_LABEL_CANCEL)) {
            this.parentFrame.handleCancel();
        }
    }

    private String formatVendorOption(VendorOption vendorOption) {
        String string = " ";
        String string2 = vendorOption.getTag();
        if (string2.length() == 1) {
            string = "     ";
        } else if (string2.length() == 2) {
            string = "   ";
        }
        String string3 = String.valueOf(string) + string2 + "  ";
        String string4 = vendorOption.getValue();
        if (string4.length() > 31) {
            string4 = string4.substring(0, 30);
        }
        string3 = String.valueOf(string3) + string4;
        return string3;
    }

    private void setupEncapsulatedFormat() {
        this.curVendor.setEncapsulatedFormat(true);
        this.instructions.setLabel(this.asciilabel);
        this.availableOptions.setEnabled(true);
        this.availableOptionsLabel.setEnabled(true);
        this.buttonRemove.setEnabled(true);
        this.buttonAdd.setEnabled(true);
        this.valueSpecs.addTagLabel.setEnabled(true);
        this.valueSpecs.inputTag.setEditable(true);
        this.valueSpecs.format.select(TEXT_BUTTON_LABEL_TEXT);
        this.valueSpecs.format.setEnabled(true);
        this.setVisible(false);
        if (!(this.parentFrame instanceof ServerParametersNotebookFrame)) {
            this.setVisible(true);
        }
        this.valueSpecs.resetFields();
        this.updateList();
    }

    private void setupUnencapsulatedFormat() {
        this.curVendor.setEncapsulatedFormat(false);
        this.instructions.setLabel(this.hexlabel);
        this.availableOptions.setEnabled(false);
        this.availableOptionsLabel.setEnabled(false);
        this.buttonRemove.setEnabled(false);
        this.buttonAdd.setEnabled(false);
        this.valueSpecs.addTagLabel.setEnabled(false);
        this.valueSpecs.inputTag.setEditable(false);
        this.valueSpecs.format.select(TEXT_BUTTON_LABEL_HEX);
        this.valueSpecs.format.setEnabled(false);
        this.setVisible(false);
        this.setVisible(true);
        this.valueSpecs.resetFields();
        String string = this.curVendor.getHexString();
        if (string != null) {
            this.valueSpecs.inputValue.setText(string);
        }
        this.updateList();
    }

    private void populateInputFields() {
        String string = null;
        String string2 = this.availableOptions.getSelectedItem().trim();
        int n = string2.indexOf(" ");
        if (n > 0) {
            string = string2.substring(0, n);
            string.trim();
            this.curOption = (VendorOption)this.currentOptionSet.get(string);
            if (this.curOption != null) {
                this.valueSpecs.populate(this.curOption);
                if (this.curOption.isHexFormat()) {
                    this.valueSpecs.format.select(TEXT_BUTTON_LABEL_HEX);
                    return;
                }
                this.valueSpecs.format.select(TEXT_BUTTON_LABEL_TEXT);
            }
        }
    }

    private boolean saveEnteredData() {
        Object object = this.valueSpecs.getUserInput(this.curVendor);
        if (object == null) {
            return true;
        }
        if (object instanceof VendorOption) {
            VendorOption vendorOption = (VendorOption)object;
            VendorOption vendorOption2 = (VendorOption)this.currentOptionSet.get(vendorOption.getTag());
            if (vendorOption2 != null) {
                vendorOption2.setValue(vendorOption.getValue(), vendorOption.isHexFormat(), vendorOption.getParent());
            } else {
                this.currentOptionSet.put(vendorOption.getTag(), vendorOption);
            }
        }
        return true;
    }

    private void updateList() {
        this.availableOptions.removeItemListener(this);
        this.availableOptions.removeAll();
        if (!this.curVendor.isEncapsulatedFormat()) {
            this.availableOptions.setVisible(true);
            return;
        }
        Enumeration enumeration = this.currentOptionSet.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            VendorOption vendorOption = (VendorOption)enumeration.nextElement();
            if (vendorOption == null) continue;
            String string = this.formatVendorOption(vendorOption);
            this.availableOptions.addItem(string, n);
            ++n;
        }
        this.availableOptions.addItemListener(this);
    }

    public void layoutPanel(Font font, Font font2) {
        this.setLayout(new BorderLayout());
        ((Component)this).setFont(font);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.format = new CheckboxGroup();
        this.asciibutton = new Checkbox(TEXT_VENDOR_ENCAPSULATED, this.format, true);
        this.asciibutton.addItemListener(this);
        this.asciibutton.addKeyListener(this);
        this.hexbutton = new Checkbox(TEXT_VENDOR_UNENCAPSULATED, this.format, false);
        this.hexbutton.addItemListener(this);
        this.hexbutton.addKeyListener(this);
        panel2.add(this.asciibutton);
        panel2.add(this.hexbutton);
        if (this.curVendor == null || this.curVendor.getName().equals(Vendor.TEXT_VENDOR)) {
            this.asciilabel = String.valueOf(TEXT_VENDOR_INSTRUCTIONS1) + "  " + TEXT_VENDOR_INSTRUCTIONS2;
        } else {
            this.curVendor.getName();
            this.asciilabel = String.valueOf(TEXT_VENDOR_ALTERNATE_INSTRUCTIONS1) + "  " + TEXT_VENDOR_ALTERNATE_INSTRUCTIONS2;
        }
        this.instructions = new MultiLineLabel(this.asciilabel);
        panel.add(panel2);
        panel.add(this.instructions);
        this.add("North", panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(2, 1));
        this.availableOptionsLabel = new Label(TEXT_VENDOR_LABEL_AVAILABLE_OPTIONS, 1);
        this.availableOptionsLabel.setFont(font2);
        panel5.add(this.availableOptionsLabel);
        panel5.add(new Label(LABEL_BLANK));
        panel4.add("North", panel5);
        this.availableOptions = new List(15, false);
        panel4.add("Center", this.availableOptions);
        this.availableOptions.addItemListener(this);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout());
        this.buttonRemove = new Button(TEXT_BUTTON_REMOVE);
        panel6.add(this.buttonRemove);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        panel4.add("South", panel6);
        panel3.add(panel4);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout());
        this.rightTopPanel = new BorderPanel(TEXT_VENDOR_BOX_ENTER_VENDOR_NAME);
        this.rightTopPanel.setTextFont(font2);
        this.rightTopPanel.setLayout(new GridLayout(2, 1));
        Label label = new Label(TEXT_VENDOR_LABEL_ENTER_VENDOR_NAME);
        this.rightTopPanel.add(label);
        this.vendorName = new TextField(30);
        this.rightTopPanel.add(this.vendorName);
        panel7.add("North", this.rightTopPanel);
        this.valueBox = new BorderPanel(TEXT_VENDOR_BOX_LABEL_ENTER_DATA);
        this.valueBox.setTextFont(font2);
        this.valueBox.setLayout(new BorderLayout());
        this.valueSpecs = new VendorInputPanel(this.parentFrame);
        this.valueBox.add("Center", this.valueSpecs);
        panel7.add("Center", this.valueBox);
        Panel panel8 = new Panel();
        panel8.setLayout(new FlowLayout());
        this.buttonAdd = new Button(TEXT_BUTTON_ADD);
        panel8.add(this.buttonAdd);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        panel7.add("South", panel8);
        panel3.add(panel7);
        this.add("Center", panel3);
    }
}

