/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.view;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.ListCriteria;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.view.View;
import COM.ibm.raleigh.dhcpsgui.view.ViewIcons;
import COM.ibm.raleigh.dhcpsgui.view.ViewSchemes;
import COM.ibm.raleigh.dhcpsgui.view.ViewUser;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class HierarchicalView
extends Panel
implements View,
ListCriteria,
TreeViewEventListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    static final String HIERARCHICAL_VIEW_NAME = "Hierarchical View";
    boolean structureChanged = true;
    boolean allExpanded = true;
    boolean resetTop = true;
    ViewUser userToBeNotified;
    String viewName = "Hierarchical View";
    Configuration configToDisplay;
    ConfigItem currentItemSelected;
    ViewIcons vIcons;
    ViewSchemes vSchemes;
    TreeView tv;
    addableToTreeView theRoot;
    static final int WIDTH = 300;
    static final int HEIGHT = 300;
    ColorsForCanvas cfcColor = new ColorsForCanvas(Color.white, Color.black, Color.yellow);

    public HierarchicalView(Configuration configuration, ViewUser viewUser) {
        this.userToBeNotified = viewUser;
        this.configToDisplay = configuration;
    }

    public HierarchicalView(Configuration configuration, ViewUser viewUser, String string) {
        this(configuration, viewUser);
        this.viewName = string;
    }

    public void loadView() {
        this.loadView(this.configToDisplay);
    }

    public void requestFocus() {
        this.tv.requestFocus();
    }

    public void selectRoot() {
        this.tv.selectTreeViewNode(this.theRoot);
        this.tv.showTreeViewNode(this.theRoot);
        this.tv.requestFocus();
    }

    protected void loadView(addableToTreeView addableToTreeView2) {
        this.vIcons = ViewIcons.getViewIcons(this);
        this.vSchemes = ViewSchemes.getViewSchemes(this.vIcons);
        this.theRoot = addableToTreeView2;
        this.tv = new TreeView(this.theRoot, new Dimension(300, 300), this.cfcColor, null, null, this.vIcons.getIcon("plus.gif"), this.vIcons.getIcon("minus.gif"));
        this.tv.addTreeViewEventListener((TreeViewEventListener)this);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.tv);
    }

    public void initializeView() {
        Vector vector = this.configToDisplay.getConfigItems(this, true);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            configItem.addObserver(this);
        }
        this.expandAll();
        this.refresh(true);
    }

    public Object meetsCriteria(ConfigItem configItem) {
        if (configItem instanceof Option || configItem instanceof VendorOption) {
            return null;
        }
        return configItem;
    }

    public void refresh(boolean bl) {
        this.structureChanged = bl;
        this.resetTop = true;
        this.refresh();
    }

    public void refresh(boolean bl, boolean bl2) {
        this.structureChanged = bl;
        this.resetTop = bl2;
        this.refresh();
    }

    public void refresh() {
        if (this.structureChanged) {
            this.rebuildTree();
        }
        ConfigItem configItem = this.userToBeNotified.getNodeSelected();
        this.selectItem(configItem);
        this.tv.committ(this.structureChanged);
        if (this.resetTop && this.currentItemSelected != null && this.allExpanded) {
            if (this.currentItemSelected instanceof Configuration || this.currentItemSelected instanceof ServerParameters || this.currentItemSelected instanceof Global || this.currentItemSelected instanceof BINLServerParameters || this.currentItemSelected instanceof BINLGlobal) {
                this.tv.showTreeViewNode((addableToTreeView)this.configToDisplay);
            } else {
                this.tv.showTreeViewNode((addableToTreeView)this.currentItemSelected);
            }
        }
        this.resetTop = true;
        this.structureChanged = false;
    }

    public void rebuildTree() {
    }

    protected void selectItem(ConfigItem configItem) {
        if (configItem != this.currentItemSelected) {
            this.structureChanged = true;
            this.tv.selectTreeViewNode((addableToTreeView)configItem);
            this.currentItemSelected = configItem;
        }
    }

    public void unselect() {
        this.tv.unSelectTreeViewNode();
    }

    public String getViewName() {
        return this.viewName;
    }

    public void expandAll() {
        this.structureChanged = true;
        this.expandAll(this.configToDisplay, true);
        this.allExpanded = true;
    }

    public void collapseAll() {
        this.structureChanged = true;
        this.expandAll(this.configToDisplay, false);
        this.allExpanded = false;
    }

    private void expandAll(ConfigItem configItem, boolean bl) {
        if (configItem instanceof Option || configItem instanceof VendorOption) {
            return;
        }
        if (!configItem.hasChildren()) {
            return;
        }
        this.tv.expandTreeViewNode((addableToTreeView)configItem, bl, false);
        Enumeration enumeration = configItem.getChildren();
        while (enumeration.hasMoreElements()) {
            this.expandAll((ConfigItem)enumeration.nextElement(), bl);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Option || object instanceof VendorOption) {
            return;
        }
        if (object != null) {
            this.tv.expandTreeViewNode((addableToTreeView)observable, this.allExpanded, false);
        }
        this.structureChanged = true;
        this.tv.committ(false);
    }

    public void postNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        this.currentItemSelected = (ConfigItem)addableToTreeView2;
        this.userToBeNotified.setNodeSelected(this.currentItemSelected, this);
    }

    public void nodeDoubleClicked(TreeView treeView, addableToTreeView addableToTreeView2) {
        this.currentItemSelected = (ConfigItem)addableToTreeView2;
        this.userToBeNotified.doubleClickOn(this.currentItemSelected, this);
    }

    public void postNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public void postNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public boolean preNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }
}

